/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WebXMLSupport
implements Node.Cookie {
    public static final String PROP_TAGLIBRARYMAP = "tagLibraryMap";
    protected DataObject dobj;
    protected Map tagLibraryMap;
    private transient PropertyChangeSupport pcs;
    private static final Map association = new WeakHashMap();

    public WebXMLSupport(DataObject dataObject) {
        this.dobj = dataObject;
        dataObject.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                WebXMLSupport.this.invalidate();
            }

            public void fileDeleted(FileEvent fileEvent) {
                WebXMLSupport.this.invalidate();
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                WebXMLSupport.this.invalidate();
            }
        });
    }

    public Map getTagLibraryMap() {
        if (this.tagLibraryMap == null) {
            WebXMLSupport webXMLSupport = this;
            synchronized (webXMLSupport) {
                if (this.tagLibraryMap == null) {
                    this.tagLibraryMap = this.createTagLibraryMap();
                }
            }
        }
        return this.tagLibraryMap;
    }

    private Map createTagLibraryMap() {
        TreeMap<String, String> treeMap;
        block9: {
            treeMap = new TreeMap<String, String>();
            try {
                Document document = XMLDataObject.parse((URL)this.dobj.getPrimaryFile().getURL(), (ErrorHandler)new ErrorHandler(){

                    public void error(SAXParseException sAXParseException) throws SAXException {
                    }

                    public void fatalError(SAXParseException sAXParseException) throws SAXException {
                        throw sAXParseException;
                    }

                    public void warning(SAXParseException sAXParseException) throws SAXException {
                    }
                }, (boolean)true);
                NodeList nodeList = document.getElementsByTagName("taglib");
                if (nodeList.getLength() != 0) {
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Element element = (Element)nodeList.item(n);
                        NodeList nodeList2 = element.getChildNodes();
                        String string = null;
                        String string2 = null;
                        int n2 = 0;
                        while (n2 < nodeList2.getLength()) {
                            Text text;
                            Node node = nodeList2.item(n2);
                            String string3 = node.getNodeName();
                            if (string3.equals("taglib-location") && (text = (Text)node.getFirstChild()) != null && (string = text.getData()) != null && !(string = string.trim()).startsWith("/")) {
                                string = "/WEB-INF/" + string;
                            }
                            if (string3.equals("taglib-uri") && (text = (Text)node.getFirstChild()) != null && (string2 = text.getData()) != null) {
                                string2 = string2.trim();
                            }
                            ++n2;
                        }
                        if (string != null && string2 != null) {
                            treeMap.put(string2, string);
                        }
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
            }
            catch (SAXException sAXException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)sAXException);
            }
        }
        return treeMap;
    }

    private synchronized void invalidate() {
        this.tagLibraryMap = null;
        this.fireWebXMLChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            return;
        }
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    void fireWebXMLChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_TAGLIBRARYMAP, null, null);
        }
    }

    public static WebXMLSupport getWebXMLSupport(DataObject dataObject) {
        WebXMLSupport webXMLSupport = (WebXMLSupport)association.get(dataObject);
        if (webXMLSupport == null) {
            webXMLSupport = new WebXMLSupport(dataObject);
            association.put(dataObject, webXMLSupport);
        }
        return webXMLSupport;
    }
}

