/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.dd.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.dd.model.Servlet;
import org.netbeans.modules.web.dd.model.ServletMapping;
import org.openide.WizardDescriptor;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServletPanel
implements WizardDescriptor.Panel {
    private ServletVisualPanel component;
    private transient boolean inited = false;
    private final Set listeners = new HashSet(1);

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ServletVisualPanel();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("jsp_create");
    }

    public boolean isValid() {
        return this.component.isOK();
    }

    Servlet getServlet(TemplateWizard templateWizard) {
        if (!this.inited) {
            this.initWizard(templateWizard);
        }
        return this.component.getServlet();
    }

    ServletMapping getMapping(TemplateWizard templateWizard) {
        if (!this.inited) {
            this.initWizard(templateWizard);
        }
        return this.component.getMapping();
    }

    private void initWizard(TemplateWizard templateWizard) {
        this.inited = true;
        String string = null;
        try {
            string = templateWizard.getTargetFolder().getPrimaryFile().getPackageName('.');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = templateWizard.getTargetName();
        if (string2 == null) {
            string2 = templateWizard.getTemplate().getPrimaryFile().getName();
        }
        string = (string == null || string.length() == 0 ? "" : string + ".") + string2;
        ((ServletVisualPanel)this.getComponent()).updateState(string2, string);
    }

    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    protected final void fireChangeEvent() {
        Iterator iterator;
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        if (object instanceof TemplateWizard) {
            this.initWizard((TemplateWizard)object);
        }
    }

    public void storeSettings(Object object) {
    }

    private class ServletVisualPanel
    extends JPanel
    implements ItemListener,
    KeyListener {
        private JTextField jTFservletname;
        private JTextField jTFservletdisp;
        private JTextField jTFservletdesc;
        private JTextField jTFservletorder;
        private JTextField jTFmappingname;
        private JTextField jTFmappingurl;
        private JCheckBox jCBservlet;
        private JCheckBox jCBload_on_startup;
        private JCheckBox jCBmapping;
        private JLabel jLservletname;
        private JLabel jLservletdisp;
        private JLabel jLservletdesc;
        private JLabel jLservletorder;
        private JLabel jLmappingname;
        private JLabel jLmappingurl;
        private JPanel jPanel1;
        private JPanel jPanel2;
        static /* synthetic */ Class class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel;

        public ServletVisualPanel() {
            this.initComponents();
            this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"TITLE_ServletDeploymentWizardPanel"));
        }

        private void updateState(String string, String string2) {
            this.jTFservletname.setText(string);
            this.jTFmappingname.setText(string);
            this.jTFmappingurl.setText("/servlet/" + string2);
        }

        private boolean isOK() {
            if (this.jCBservlet.isSelected()) {
                if (this.jTFservletname.getText().length() == 0) {
                    return false;
                }
                if (this.jCBload_on_startup.isSelected()) {
                    try {
                        Integer.valueOf(this.jTFservletorder.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
            }
            return !this.jCBmapping.isSelected() || this.jTFmappingname.getText().length() != 0 && this.jTFmappingurl.getText().length() != 0;
        }

        private Servlet getServlet() {
            if (this.jCBservlet.isSelected()) {
                Servlet servlet = new Servlet();
                servlet.setServletName(this.jTFservletname.getText());
                servlet.setDescription(this.jTFservletdesc.getText());
                servlet.setDisplayName(this.jTFservletdisp.getText());
                if (this.jCBload_on_startup.isSelected()) {
                    try {
                        servlet.setLoadOnStartup(Integer.valueOf(this.jTFservletorder.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return servlet;
            }
            return null;
        }

        private ServletMapping getMapping() {
            if (this.jCBmapping.isSelected()) {
                ServletMapping servletMapping = new ServletMapping();
                servletMapping.setServletName(this.jTFmappingname.getText());
                servletMapping.setUrlPattern(this.jTFmappingurl.getText());
                return servletMapping;
            }
            return null;
        }

        private void initComponents() {
            GridBagConstraints gridBagConstraints;
            this.jTFservletname = new JTextField(25);
            this.jTFservletdisp = new JTextField(30);
            this.jTFservletdesc = new JTextField(30);
            this.jTFservletorder = new JTextField(3);
            this.jTFmappingname = new JTextField(25);
            this.jTFmappingurl = new JTextField(30);
            this.jCBservlet = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_servlet"), true);
            this.jCBservlet.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_servlet_Mnem").charAt(0));
            this.jCBload_on_startup = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_load_on_startup"));
            this.jCBload_on_startup.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_load_on_startup_Mnem").charAt(0));
            this.jCBmapping = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_mapping"), true);
            this.jCBmapping.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_mapping_Mnem").charAt(0));
            this.jLservletname = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_name"));
            this.jLservletname.setLabelFor(this.jTFservletname);
            this.jLservletname.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_name_Mnem").charAt(0));
            this.jLservletdisp = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_display_name"));
            this.jLservletdisp.setLabelFor(this.jTFservletdisp);
            this.jLservletdisp.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_display_name_Mnem").charAt(0));
            this.jLservletdesc = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_description"));
            this.jLservletdesc.setLabelFor(this.jTFservletdesc);
            this.jLservletdesc.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_description_Mnem").charAt(0));
            this.jLservletorder = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_order"));
            this.jLservletorder.setLabelFor(this.jTFservletorder);
            this.jLservletorder.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_order_Mnem").charAt(0));
            this.jLmappingname = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_name"));
            this.jLmappingname.setLabelFor(this.jTFmappingname);
            this.jLmappingname.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_name_Mnem").charAt(0));
            this.jLmappingurl = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_url"));
            this.jLmappingurl.setLabelFor(this.jTFmappingurl);
            this.jLmappingurl.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_url_Mnem").charAt(0));
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel));
            this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_servlet_deployment"));
            this.jTFservletname.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_servlet_name"));
            this.jTFservletdisp.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_servlet_disp"));
            this.jTFservletdesc.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_servlet_desc"));
            this.jTFservletorder.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_servlet_order"));
            this.jTFmappingname.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_mapping_name"));
            this.jTFmappingurl.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_mapping_url"));
            this.jCBservlet.addItemListener(this);
            this.jCBload_on_startup.addItemListener(this);
            this.jCBmapping.addItemListener(this);
            this.jTFmappingname.setEnabled(false);
            this.jTFservletname.addKeyListener(this);
            this.jTFservletorder.addKeyListener(this);
            this.jTFservletorder.setEnabled(false);
            this.jTFmappingurl.addKeyListener(this);
            JComponent[] jComponentArray = new JComponent[]{this.jCBservlet, this.jTFservletname, this.jTFservletdisp, this.jTFservletdesc, this.jTFservletorder, this.jTFmappingname, this.jTFmappingurl, this.jCBload_on_startup, this.jCBmapping, this.jLservletname, this.jLservletdisp, this.jLservletdesc, this.jLservletorder, this.jLmappingname, this.jLmappingurl};
            int[][] nArrayArray = new int[][]{{0, 0, 2, 1, 2}, {1, 1, 1, 1, 0}, {1, 2, 1, 1, 2}, {1, 3, 1, 1, 2}, {1, 5, 1, 1, 0}, {1, 7, 1, 1, 0}, {1, 8, 1, 1, 2}, {0, 4, 1, 1, 2}, {0, 6, 2, 1, 2}, {0, 1, 1, 1, 0}, {0, 2, 1, 1, 0}, {0, 3, 1, 1, 0}, {0, 5, 1, 1, 0}, {0, 7, 1, 1, 0}, {0, 8, 1, 1, 0}};
            Insets[] insetsArray = new Insets[]{new Insets(0, 0, 5, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 12, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 12, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 24, 12, 0), new Insets(0, 24, 5, 0), new Insets(0, 24, 12, 0)};
            this.setLayout(new GridBagLayout());
            this.setPreferredSize(new Dimension(450, 250));
            int n = 0;
            while (n < jComponentArray.length) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = nArrayArray[n][0];
                gridBagConstraints.gridy = nArrayArray[n][1];
                gridBagConstraints.gridwidth = nArrayArray[n][2];
                gridBagConstraints.gridheight = nArrayArray[n][3];
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = nArrayArray[n][4];
                gridBagConstraints.insets = insetsArray[n];
                this.add((Component)jComponentArray[n], gridBagConstraints);
                ++n;
            }
            this.jPanel1 = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.jPanel1, gridBagConstraints);
            this.jPanel2 = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.jPanel2, gridBagConstraints);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl;
            boolean bl2 = bl = itemEvent.getStateChange() == 1;
            if (itemEvent.getSource() == this.jCBservlet) {
                this.jTFservletname.setEnabled(bl);
                this.jTFservletdisp.setEnabled(bl);
                this.jTFservletdesc.setEnabled(bl);
                this.jCBload_on_startup.setEnabled(bl);
                this.jTFservletorder.setEnabled(bl && this.jCBload_on_startup.isSelected());
                this.jCBmapping.setEnabled(bl);
                this.jTFmappingurl.setEnabled(bl && this.jCBmapping.isSelected());
            } else if (itemEvent.getSource() == this.jCBmapping) {
                this.jTFmappingurl.setEnabled(bl);
            } else if (itemEvent.getSource() == this.jCBload_on_startup) {
                this.jTFservletorder.setEnabled(bl);
            }
            ServletPanel.this.fireChangeEvent();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource() == this.jTFservletname) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ServletVisualPanel this$1;
                    {
                        this.this$1 = servletVisualPanel;
                    }

                    public void run() {
                        ServletVisualPanel.access$500(this.this$1).setText(ServletVisualPanel.access$400(this.this$1).getText());
                        ServletVisualPanel.access$600(this.this$1).fireChangeEvent();
                    }
                });
                return;
            }
            if (keyEvent.getSource() == this.jTFservletorder || keyEvent.getSource() == this.jTFmappingurl) {
                ServletPanel.this.fireChangeEvent();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ JTextField access$400(ServletVisualPanel servletVisualPanel) {
            return servletVisualPanel.jTFservletname;
        }

        static /* synthetic */ JTextField access$500(ServletVisualPanel servletVisualPanel) {
            return servletVisualPanel.jTFmappingname;
        }

        static /* synthetic */ ServletPanel access$600(ServletVisualPanel servletVisualPanel) {
            return servletVisualPanel.ServletPanel.this;
        }
    }
}

