/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webdata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.j2ee.server.datamodel.AppChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.AppChangeListener;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebAppStandardData;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.webdata.StandardDataImpl;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebMappingImpl;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public class WebApplicationImpl
extends StandardDataImpl
implements WebAppStandardData,
PropertyChangeListener,
RepositoryListener {
    protected WebAppStandardData.WebMapping[] webMappings = null;
    protected Set appChangeListeners = new HashSet(5);
    protected FileObject fileObject = null;
    protected DataObject dataObject = null;
    protected String fileSystemName = null;

    public WebApplicationImpl(FileObject fileObject) {
        this.fileObject = fileObject;
        this.addListener();
        this.init();
    }

    protected void addListener() {
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)this.fileObject);
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
            this.dataObject = dataObject;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)dataObjectNotFoundException);
        }
    }

    protected void init() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.fileObject);
            this.webMappings = new WebAppStandardData.WebMapping[1];
            WebModuleImpl webModuleImpl = WebDataFactory.getFactory().findWebModule(this.fileObject);
            DataObject dataObject2 = DataObject.find((FileObject)this.fileObject);
            if (dataObject2 instanceof WebContextObject) {
                WebContextObject webContextObject = (WebContextObject)dataObject2;
                this.webMappings[0] = new WebMappingImpl(webModuleImpl, webContextObject.getURIParameter());
            } else {
                this.webMappings[0] = new WebMappingImpl(webModuleImpl, "");
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)dataObjectNotFoundException);
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public WebAppStandardData.WebMapping[] getWebModules() {
        return this.webMappings;
    }

    public void addAppChangeListener(AppChangeListener appChangeListener) {
        if (this.appChangeListeners == null) {
            WebApplicationImpl webApplicationImpl = this;
            synchronized (webApplicationImpl) {
                if (this.appChangeListeners == null) {
                    this.appChangeListeners = new HashSet(5);
                }
            }
        }
        this.appChangeListeners.add(appChangeListener);
    }

    public void removeAppChangeListener(AppChangeListener appChangeListener) {
        if (this.appChangeListeners != null) {
            this.appChangeListeners.remove(appChangeListener);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("URI_CHANGE")) {
            this.fireWebModuleChange();
        }
        if (string.equals("valid")) {
            TopManager.getDefault().getRepository().addRepositoryListener((RepositoryListener)this);
            try {
                this.fileSystemName = this.fileObject.getFileSystem().getSystemName();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)fileStateInvalidException);
            }
        }
    }

    protected void fireWebModuleChange() {
        this.init();
        AppChangeEvent appChangeEvent = new AppChangeEvent(2, 2, (StandardData)this);
        Iterator iterator = this.appChangeListeners.iterator();
        while (iterator.hasNext()) {
            ((AppChangeListener)iterator.next()).fireAppChangeEvent(appChangeEvent);
        }
    }

    protected void webModuleInit() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                WebDataFactory.getFactory().findWebModule(WebApplicationImpl.this.fileObject).init();
            }
        }, (int)100);
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        if (this.fileSystemName == null || this.fileSystemName.equals(repositoryEvent.getFileSystem().getSystemName())) {
            TopManager.getDefault().getRepository().removeRepositoryListener((RepositoryListener)this);
            this.fileSystemName = null;
            this.webModuleInit();
            this.addListener();
            this.fireWebModuleChange();
        }
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
    }
}

