/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.api.IntrospectionCookie;
import org.apache.tools.ant.module.nodes.DataTypeNode;
import org.apache.tools.ant.module.nodes.ElementNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ElementChildren
extends Children.Keys
implements EventListener {
    protected Element el;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$IntrospectionCookie;
    static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$ElementChildren;

    public ElementChildren(Element element) {
        this.el = element;
    }

    protected ElementChildren() {
    }

    protected Element getElement() {
        return this.el;
    }

    protected void addNotify() {
        AntModule.err.log("ElementChildren.addNotify");
        this.refreshKeys();
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof EventTarget) {
            ((EventTarget)((Object)element)).addEventListener("DOMSubtreeModified", this, false);
        } else {
            AntModule.err.log(16, "Element was not an EventTarget: " + element);
        }
    }

    protected void removeNotify() {
        AntModule.err.log("ElementChildren.removeNotify");
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof EventTarget) {
            ((EventTarget)((Object)element)).removeEventListener("DOMSubtreeModified", this, false);
        } else {
            AntModule.err.log(16, "Element was not an EventTarget: " + element);
        }
        this.setKeys(Collections.EMPTY_SET);
    }

    protected void refreshKeys() {
        AntModule.err.log("ElementChildren.refreshKeys: node=" + this.getNode().getDisplayName());
        Element element = this.getElement();
        if (element == null) {
            this.setKeys(Collections.EMPTY_SET);
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<org.w3c.dom.Node> arrayList = new ArrayList<org.w3c.dom.Node>(n);
        int n2 = 0;
        while (n2 < n) {
            org.w3c.dom.Node node = nodeList.item(n2);
            if (node instanceof Element) {
                AntModule.err.log("\tnode=" + node.getNodeName());
                arrayList.add(node);
            }
            ++n2;
        }
        this.setKeys(arrayList);
    }

    protected Node[] createNodes(Object object) {
        String string;
        Element element = (Element)object;
        IntrospectionCookie introspectionCookie = (IntrospectionCookie)this.getNode().getCookie(class$org$apache$tools$ant$module$api$IntrospectionCookie == null ? (class$org$apache$tools$ant$module$api$IntrospectionCookie = ElementChildren.class$("org.apache.tools.ant.module.api.IntrospectionCookie")) : class$org$apache$tools$ant$module$api$IntrospectionCookie);
        if (introspectionCookie != null) {
            String string2 = this.el.getNodeName();
            String string3 = introspectionCookie.getClassName();
            Map map = IntrospectedInfo.getDefaults().isKnown(string3) ? IntrospectedInfo.getDefaults().getElements(string3) : (AntSettings.getDefault().getCustomDefs().isKnown(string3) ? AntSettings.getDefault().getCustomDefs().getElements(string3) : null);
            if (map != null) {
                String string4 = element.getNodeName();
                String string5 = (String)map.get(string4);
                if (string5 != null) {
                    return new Node[]{new DataTypeNode(element, string5)};
                }
                string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$ElementChildren == null ? (class$org$apache$tools$ant$module$nodes$ElementChildren = ElementChildren.class$("org.apache.tools.ant.module.nodes.ElementChildren")) : class$org$apache$tools$ant$module$nodes$ElementChildren), (String)"ERR_no_subelements", (Object)string2, (Object)string4);
            } else {
                string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$ElementChildren == null ? (class$org$apache$tools$ant$module$nodes$ElementChildren = ElementChildren.class$("org.apache.tools.ant.module.nodes.ElementChildren")) : class$org$apache$tools$ant$module$nodes$ElementChildren), (String)"ERR_not_analyzed", (Object)string2);
            }
        } else {
            string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$ElementChildren == null ? (class$org$apache$tools$ant$module$nodes$ElementChildren = ElementChildren.class$("org.apache.tools.ant.module.nodes.ElementChildren")) : class$org$apache$tools$ant$module$nodes$ElementChildren), (String)"ERR_parent_also");
        }
        return new Node[]{new ElementNode(element, string)};
    }

    public void handleEvent(Event event) {
        AntModule.err.log("ElementChildren.handleEvent: " + event.getType());
        this.refreshKeys();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

