/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.CustomizeScriptPanel;
import org.apache.tools.ant.module.wizards.shortcut.IntroPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectFolderPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectKeyboardShortcutPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectTargetPanel;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShortcutIterator
implements TemplateWizard.Iterator {
    public static final String PROP_CODE_NAME = "wizdata.codeName";
    public static final String PROP_CONTENTS = "wizdata.contents";
    public static final String PROP_SHOW_CUST = "wizdata.show.cust";
    public static final String PROP_SHOW_MENU = "wizdata.show.menu";
    public static final String PROP_SHOW_TOOL = "wizdata.show.tool";
    public static final String PROP_SHOW_PROJ = "wizdata.show.proj";
    public static final String PROP_SHOW_KEYB = "wizdata.show.keyb";
    public static final String PROP_FOLDER_MENU = "wizdata.folder.menu";
    public static final String PROP_FOLDER_TOOL = "wizdata.folder.tool";
    public static final String PROP_FOLDER_PROJ = "wizdata.folder.proj";
    public static final String PROP_STROKE = "wizdata.stroke";
    private static final long serialVersionUID = 47387529866399027L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor.Panel[] currentPanels;
    private transient TemplateWizard wiz;
    private transient Set listeners = new HashSet(1);
    static /* synthetic */ Class class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator;

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new IntroPanel(), new SelectTargetPanel(), new CustomizeScriptPanel(), new SelectFolderPanel(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_menu_to_add_to"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_TEXT_menu_locn"), TopManager.getDefault().getPlaces().folders().menus().getNodeDelegate(), false, true, PROP_FOLDER_MENU), new SelectFolderPanel(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_toolbar"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_TEXT_toolbar_locn"), TopManager.getDefault().getPlaces().folders().toolbars().getNodeDelegate(), false, false, PROP_FOLDER_TOOL), new SelectFolderPanel(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_proj_folder"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_TEXT_select_project_locn"), TopManager.getDefault().getPlaces().nodes().projectDesktop(), true, false, PROP_FOLDER_PROJ), new SelectKeyboardShortcutPanel()};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_choose_options"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_select_ant_target"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_cust_script"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_add_to_menu"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_add_to_toolbar"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_add_to_proj"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"SI_LBL_make_keyboard_shortcut")};
    }

    private void dumpContents() {
        String[] stringArray = new String[]{PROP_CODE_NAME, PROP_CONTENTS, PROP_SHOW_CUST, PROP_SHOW_MENU, PROP_SHOW_TOOL, PROP_SHOW_PROJ, PROP_SHOW_KEYB, PROP_FOLDER_MENU, PROP_FOLDER_TOOL, PROP_FOLDER_PROJ, PROP_STROKE};
        System.err.println("TemplateWizard:");
        int n = 0;
        while (n < stringArray.length) {
            System.err.println("\t" + stringArray[n] + " = " + this.wiz.getProperty(stringArray[n]));
            ++n;
        }
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        if (this.showing(PROP_SHOW_KEYB)) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Shortcuts");
            KeyStroke keyStroke = (KeyStroke)templateWizard.getProperty(PROP_STROKE);
            this.create(DataFolder.findFolder((FileObject)fileObject), Utilities.keyToString((KeyStroke)keyStroke));
        }
        if (this.showing(PROP_SHOW_MENU)) {
            this.create((DataFolder)templateWizard.getProperty(PROP_FOLDER_MENU), null);
        }
        if (this.showing(PROP_SHOW_TOOL)) {
            this.create((DataFolder)templateWizard.getProperty(PROP_FOLDER_TOOL), null);
        }
        if (this.showing(PROP_SHOW_PROJ)) {
            return Collections.singleton(this.create((DataFolder)templateWizard.getProperty(PROP_FOLDER_PROJ), null));
        }
        return Collections.EMPTY_SET;
    }

    private DataObject create(DataFolder dataFolder, String string) throws IOException {
        final String string2 = string != null ? string : (String)this.wiz.getProperty(PROP_CODE_NAME);
        final String string3 = (String)this.wiz.getProperty(PROP_CONTENTS);
        final FileObject fileObject = dataFolder.getPrimaryFile();
        final FileObject[] fileObjectArray = new FileObject[1];
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                fileObjectArray[0] = fileObject.createData(string2, "xml");
                FileLock fileLock = fileObjectArray[0].lock();
                try {
                    OutputStream outputStream = fileObjectArray[0].getOutputStream(fileLock);
                    try {
                        outputStream.write(string3.getBytes("UTF-8"));
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        outputStream.close();
                        throw throwable;
                    }
                    outputStream.close();
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    fileLock.releaseLock();
                    throw throwable;
                }
                fileLock.releaseLock();
            }
        });
        return DataObject.find((FileObject)fileObjectArray[0]);
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        int n = 0;
        while (n < this.panels.length) {
            Component component = this.panels[n].getComponent();
            if (stringArray[n] == null) {
                stringArray[n] = component.getName();
            }
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(n));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
            }
            ++n;
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator == null ? (class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator = ShortcutIterator.class$("org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator")) : class$org$apache$tools$ant$module$wizards$shortcut$ShortcutIterator), (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    private boolean showing(String string) {
        Boolean bl = (Boolean)this.wiz.getProperty(string);
        return bl == null || bl != false;
    }

    private boolean showing(int n) throws NoSuchElementException {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.showing(PROP_SHOW_CUST);
            }
            case 3: {
                return this.showing(PROP_SHOW_MENU);
            }
            case 4: {
                return this.showing(PROP_SHOW_TOOL);
            }
            case 5: {
                return this.showing(PROP_SHOW_PROJ);
            }
            case 6: {
                return this.showing(PROP_SHOW_KEYB);
            }
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        int n = this.index + 1;
        while (n < this.panels.length) {
            if (this.showing(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        ++this.index;
        while (!this.showing(this.index)) {
            ++this.index;
        }
        if (this.index == 1) {
            this.fireChangeEvent();
        }
    }

    public void previousPanel() {
        --this.index;
        while (!this.showing(this.index)) {
            --this.index;
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    protected final void fireChangeEvent() {
        Iterator iterator;
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new HashSet(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

