/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.ElementCookie;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.api.IntrospectionCookie;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.w3c.dom.Element;

public class ElementSupport
implements ElementCookie {
    private final Element el;

    public ElementSupport(Element element) {
        this.el = element;
    }

    public Element getElement() {
        return this.el;
    }

    public static class Instance
    extends ElementSupport
    implements InstanceCookie {
        private Class clazz;
        private String clazzname;
        private ClassNotFoundException cnfe = null;
        private Map subels = null;

        public Instance(Element element, Class clazz) {
            super(element);
            this.clazz = clazz;
            this.clazzname = clazz.getName();
        }

        public Instance(Element element, String string) {
            super(element);
            this.clazzname = string;
        }

        public String toString() {
            return "ElementSupport.Instance[clazzname=" + this.clazzname + ",subels=" + this.subels + "]";
        }

        public String instanceName() {
            return this.getElement().getNodeName();
        }

        public Map getSubelements() throws IOException, ClassNotFoundException {
            if (this.subels != null) {
                return this.subels;
            }
            Instance instance = this;
            synchronized (instance) {
                if (this.subels != null) {
                    Map map = this.subels;
                    return map;
                }
                if (this.clazzname == null) {
                    this.instanceClass();
                }
                this.subels = IntrospectedInfo.getDefaults().isKnown(this.clazzname) ? IntrospectedInfo.getDefaults().getElements(this.clazzname) : (AntSettings.getDefault().getCustomDefs().isKnown(this.clazzname) ? AntSettings.getDefault().getCustomDefs().getElements(this.clazzname) : null);
                Map map = this.subels;
                return map;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            if (this.clazz != null) {
                return this.clazz;
            }
            if (this.cnfe != null) {
                throw this.cnfe;
            }
            Instance instance = this;
            synchronized (instance) {
                if (this.clazz != null) {
                    Class clazz = this.clazz;
                    return clazz;
                }
                if (this.cnfe != null) {
                    throw this.cnfe;
                }
                if (this.clazzname == null) {
                    throw new IOException("Must specify clazz or clazzname");
                }
                try {
                    Class<?> clazz = this.clazz = TopManager.getDefault().currentClassLoader().loadClass(this.clazzname);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.cnfe = classNotFoundException;
                    throw classNotFoundException;
                }
            }
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            throw new IOException("UNIMPLEMENTED");
        }
    }

    public static class Introspection
    extends ElementSupport
    implements IntrospectionCookie {
        private String clazzname;

        public Introspection(Element element, String string) {
            super(element);
            this.clazzname = string;
        }

        public String getClassName() {
            return this.clazzname;
        }
    }
}

