/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.tax.AbstractTreeDTD;
import org.netbeans.tax.AbstractUtil;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.spec.Document;

public class TreeDocumentType
extends AbstractTreeDTD
implements TreeDTDRoot,
Document.Child {
    public static final String PROP_ELEMENT_NAME = "elementName";
    public static final String PROP_PUBLIC_ID = "publicId";
    public static final String PROP_SYSTEM_ID = "systemId";
    private String elementName;
    private String publicId;
    private String systemId;
    private TreeObjectList externalDTDList;
    private String internalDTDText;

    public TreeDocumentType(String elementName, String publicId, String systemId) throws InvalidArgumentException {
        this.checkElementName(elementName);
        this.checkPublicId(publicId);
        this.checkSystemId(systemId);
        this.elementName = elementName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.externalDTDList = new TreeObjectList(this.createExternalDTDListContentManager());
    }

    public TreeDocumentType(String elementName) throws InvalidArgumentException {
        this(elementName, null, null);
    }

    protected TreeDocumentType(TreeDocumentType documentType, boolean deep) {
        super(documentType, deep);
        this.elementName = documentType.elementName;
        this.publicId = documentType.publicId;
        this.systemId = documentType.systemId;
        this.internalDTDText = documentType.internalDTDText;
        this.externalDTDList = new TreeObjectList(this.createExternalDTDListContentManager());
        if (deep) {
            this.externalDTDList.addAll((Collection)((TreeObjectList)documentType.externalDTDList.clone()));
        }
    }

    public Object clone(boolean deep) {
        return new TreeDocumentType(this, deep);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeDocumentType peer = (TreeDocumentType)object;
        if (!AbstractUtil.equals(this.getElementName(), peer.getElementName())) {
            return false;
        }
        if (!AbstractUtil.equals(this.getPublicId(), peer.getPublicId())) {
            return false;
        }
        if (!AbstractUtil.equals(this.getSystemId(), peer.getSystemId())) {
            return false;
        }
        return AbstractUtil.equals(this.externalDTDList, peer.externalDTDList);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeDocumentType peer = (TreeDocumentType)treeObject;
        this.setElementNameImpl(peer.getElementName());
        this.setPublicIdImpl(peer.getPublicId());
        this.setSystemIdImpl(peer.getSystemId());
        this.internalDTDText = peer.internalDTDText;
        this.externalDTDList.merge(peer.externalDTDList);
    }

    protected void setReadOnly(boolean newReadOnly) {
        super.setReadOnly(newReadOnly);
        this.externalDTDList.setReadOnly(newReadOnly);
    }

    public boolean hasChildNodes(Class childClass, boolean recursive) {
        Iterator[] its = new Iterator[]{this.getChildNodes().iterator(), this.externalDTDList.iterator()};
        int i = 0;
        while (i < its.length) {
            Iterator it = its[i];
            while (it.hasNext()) {
                TreeChild child = (TreeChild)it.next();
                if (childClass == null || childClass.isAssignableFrom(child.getClass())) {
                    return true;
                }
                if (!recursive || !(child instanceof TreeParentNode) || !((TreeParentNode)child).hasChildNodes(childClass, true)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public Collection getChildNodes(Class childClass, boolean recursive) {
        LinkedList<TreeChild> allChildNodes = new LinkedList<TreeChild>();
        Iterator[] its = new Iterator[]{this.getChildNodes().iterator(), this.externalDTDList.iterator()};
        int i = 0;
        while (i < its.length) {
            Iterator it = its[i];
            while (it.hasNext()) {
                TreeChild child = (TreeChild)it.next();
                if (childClass == null || childClass.isAssignableFrom(child.getClass())) {
                    allChildNodes.add(child);
                }
                if (!recursive || !(child instanceof TreeParentNode)) continue;
                allChildNodes.addAll(((TreeParentNode)child).getChildNodes(childClass, true));
            }
            ++i;
        }
        return allChildNodes;
    }

    public final TreeObjectList getExternalDTD() {
        return this.externalDTDList;
    }

    public final String getElementName() {
        return this.elementName;
    }

    private final void setElementNameImpl(String newElementName) {
        String oldElementName = this.elementName;
        this.elementName = newElementName;
        this.firePropertyChange(PROP_ELEMENT_NAME, oldElementName, newElementName);
    }

    public final void setElementName(String newElementName) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.elementName, newElementName)) {
            return;
        }
        this.checkReadOnly();
        this.checkElementName(newElementName);
        this.setElementNameImpl(newElementName);
    }

    protected final void checkElementName(String elementName) throws InvalidArgumentException {
        TreeUtilities.checkDocumentTypeElementName(elementName);
    }

    public final String getPublicId() {
        return this.publicId;
    }

    private final void setPublicIdImpl(String newPublicId) {
        String oldPublicId = this.publicId;
        this.publicId = newPublicId;
        this.firePropertyChange(PROP_PUBLIC_ID, oldPublicId, newPublicId);
    }

    public final void setPublicId(String newPublicId) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.publicId, newPublicId)) {
            return;
        }
        this.checkReadOnly();
        this.checkPublicId(newPublicId);
        this.setPublicIdImpl(newPublicId);
    }

    protected final void checkPublicId(String publicId) throws InvalidArgumentException {
        TreeUtilities.checkDocumentTypePublicId(publicId);
    }

    public final String getSystemId() {
        return this.systemId;
    }

    private final void setSystemIdImpl(String newSystemId) {
        String oldSystemId = this.systemId;
        this.systemId = newSystemId;
        this.firePropertyChange(PROP_SYSTEM_ID, oldSystemId, newSystemId);
    }

    public final void setSystemId(String newSystemId) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.systemId, newSystemId)) {
            return;
        }
        this.checkReadOnly();
        this.checkSystemId(newSystemId);
        this.setSystemIdImpl(newSystemId);
    }

    protected final void checkSystemId(String systemId) throws InvalidArgumentException {
        TreeUtilities.checkDocumentTypeSystemId(systemId);
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected TreeObjectList.ContentManager createExternalDTDListContentManager() {
        return new ExternalDTDContentManager();
    }

    protected class ExternalDTDContentManager
    extends TreeParentNode.ChildListContentManager {
        static /* synthetic */ Class class$org$netbeans$tax$spec$DTD$Child;

        protected ExternalDTDContentManager() {
            super(TreeDocumentType.this);
        }

        public TreeNode getOwnerNode() {
            return TreeDocumentType.this;
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(class$org$netbeans$tax$spec$DTD$Child == null ? (class$org$netbeans$tax$spec$DTD$Child = ExternalDTDContentManager.class$("org.netbeans.tax.spec.DTD$Child")) : class$org$netbeans$tax$spec$DTD$Child, obj);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected class ChildListContentManager
    extends AbstractTreeDTD.ChildListContentManager {
        static /* synthetic */ Class class$org$netbeans$tax$spec$DocumentType$Child;

        protected ChildListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeDocumentType.this;
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(class$org$netbeans$tax$spec$DocumentType$Child == null ? (class$org$netbeans$tax$spec$DocumentType$Child = ChildListContentManager.class$("org.netbeans.tax.spec.DocumentType$Child")) : class$org$netbeans$tax$spec$DocumentType$Child, obj);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

