/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.tax.AbstractUtil;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCharacterData;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeData;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNamespace;
import org.netbeans.tax.TreeNamespaceContext;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.GeneralEntityReference;

public class TreeElement
extends TreeParentNode
implements Document.Child,
DocumentFragment.Child,
Element.Child,
GeneralEntityReference.Child {
    public static final String PROP_TAG_NAME = "tagName";
    public static final String PROP_ATTRIBUTES = "attributes";
    private TreeName tagName;
    private TreeNamespaceContext namespaceContext;
    private TreeNamedObjectMap attributes;
    private boolean empty;
    private boolean containsCharacterData;

    public TreeElement(String tagName, boolean empty) throws InvalidArgumentException {
        TreeName treeName = new TreeName(tagName);
        this.checkTagName(treeName);
        this.tagName = treeName;
        this.empty = empty;
        this.containsCharacterData = false;
        this.namespaceContext = new TreeNamespaceContext(this);
        this.attributes = new TreeNamedObjectMap(this.createAttributesContentManager());
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeElement:: : name = " + tagName + " : empty = " + empty);
        }
    }

    public TreeElement(String qName) throws InvalidArgumentException {
        this(qName, false);
    }

    protected TreeElement(TreeElement element, boolean deep) {
        super(element, deep);
        this.tagName = element.tagName;
        this.empty = this.empty;
        this.namespaceContext = new TreeNamespaceContext(this);
        this.attributes = new TreeNamedObjectMap(this.createAttributesContentManager());
        this.attributes.addAll((Collection)((TreeNamedObjectMap)element.attributes.clone()));
    }

    public Object clone(boolean deep) {
        return new TreeElement(this, deep);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeElement peer = (TreeElement)object;
        if (this.empty != peer.empty) {
            return false;
        }
        if (!AbstractUtil.equals(this.getTreeName(), peer.getTreeName())) {
            return false;
        }
        return AbstractUtil.equals(this.getAttributes(), peer.getAttributes());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeElement peer = (TreeElement)treeObject;
        this.empty = this.empty || peer.empty;
        try {
            this.setTreeName(peer.getTreeName());
        }
        catch (Exception exc) {
            throw new CannotMergeException(treeObject, exc);
        }
        this.attributes.merge(peer.getAttributes());
    }

    protected void setReadOnly(boolean newReadOnly) {
        super.setReadOnly(newReadOnly);
        this.attributes.setReadOnly(newReadOnly);
    }

    public final String getQName() {
        return this.tagName.getQualifiedName();
    }

    public final void setQName(String newTagName) throws ReadOnlyException, InvalidArgumentException {
        this.setTreeName(new TreeName(newTagName));
    }

    public final TreeName getTreeName() {
        return this.tagName;
    }

    private final void setTreeNameImpl(TreeName newTagName) {
        TreeName oldTagName = this.tagName;
        this.tagName = newTagName;
        this.firePropertyChange(PROP_TAG_NAME, oldTagName, newTagName);
    }

    public final void setTreeName(TreeName newTagName) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.tagName, newTagName)) {
            return;
        }
        this.checkReadOnly();
        this.checkTagName(newTagName);
        this.setTreeNameImpl(newTagName);
    }

    public boolean isEmpty() {
        if (!this.empty) {
            return false;
        }
        return this.getChildNodes().size() == 0;
    }

    protected final void checkTagName(TreeName tagName) throws InvalidArgumentException {
        TreeUtilities.checkElementTagName(tagName);
    }

    protected final TreeNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public final TreeNamespace getNamespace() {
        String prefix = this.getNamespacePrefix();
        String uri = this.namespaceContext.getURI(prefix);
        if (uri == null) {
            return TreeNamespace.NO_NAMESPACE;
        }
        return new TreeNamespace(prefix, uri);
    }

    public final String getNamespacePrefix() {
        return this.tagName.getPrefix();
    }

    public final String getNamespaceURI() {
        return this.getNamespace().getURI();
    }

    public final String getLocalName() {
        return this.tagName.getName();
    }

    public final int getAttributesNumber() {
        return this.attributes.size();
    }

    public final boolean hasAttributes() {
        return this.attributes.size() != 0;
    }

    public final boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public final TreeNamedObjectMap getAttributes() {
        return this.attributes;
    }

    public final TreeAttribute getAttribute(String name) {
        try {
            TreeName treeName = new TreeName(name);
            return (TreeAttribute)this.attributes.get(treeName);
        }
        catch (InvalidArgumentException exc) {
            return null;
        }
    }

    public final TreeAttribute addAttribute(String name, String value) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        TreeAttribute newAttr = new TreeAttribute(name, value);
        TreeAttribute oldAttr = this.removeAttribute(name);
        this.attributes.add(newAttr);
        return oldAttr;
    }

    public final void addAttribute(TreeAttribute newAttr) throws ReadOnlyException, InvalidArgumentException {
        String qName = newAttr.getQName();
        this.checkReadOnly();
        TreeAttribute oldAttr = this.removeAttribute(qName);
        this.attributes.add(newAttr);
    }

    public final TreeAttribute removeAttribute(String name) throws ReadOnlyException {
        return this.removeAttribute(this.getAttribute(name));
    }

    public final TreeAttribute removeAttribute(TreeAttribute oldAttr) throws ReadOnlyException {
        this.checkReadOnly();
        this.attributes.remove(oldAttr);
        return oldAttr;
    }

    public final void removeAttributes() throws ReadOnlyException {
        this.checkReadOnly();
        this.attributes.clear();
    }

    public final void normalize() throws ReadOnlyException {
        this.checkReadOnly();
        try {
            try {
                this.getChildNodes().getEventManager().setFirePolicy((short)2);
                int i = 0;
                while (true) {
                    TreeChild child;
                    if ((child = this.item(i)) instanceof TreeElement) {
                        ((TreeElement)child).normalize();
                    } else if (child instanceof TreeText) {
                        TreeChild child2;
                        while ((child2 = this.item(i + 1)) instanceof TreeText) {
                            try {
                                ((TreeText)child).appendData(((TreeText)child2).getData());
                                this.removeChild(child2);
                            }
                            catch (InvalidArgumentException exc) {
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
                Object var6_6 = null;
                this.getChildNodes().getEventManager().setFirePolicy((short)1);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.getChildNodes().getEventManager().setFirePolicy((short)1);
            throw throwable;
        }
    }

    public final boolean containsCharacterData() {
        return this.containsCharacterData;
    }

    private void updateContainsCharacterData() {
        Iterator it = this.getChildNodes().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof TreeCharacterData)) continue;
            TreeCharacterData charData = (TreeCharacterData)obj;
            if (charData instanceof TreeData) {
                if (!((TreeData)((Object)charData)).onlyWhiteSpaces()) {
                    this.containsCharacterData = true;
                }
            } else {
                this.containsCharacterData = true;
            }
            if (!this.containsCharacterData) continue;
            return;
        }
        this.containsCharacterData = false;
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected TreeNamedObjectMap.ContentManager createAttributesContentManager() {
        return new AttributesContentManager();
    }

    protected class AttributesContentManager
    extends TreeNamedObjectMap.ContentManager {
        static /* synthetic */ Class class$org$netbeans$tax$spec$Element$Attribute;

        protected AttributesContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeElement.this;
        }

        public void checkAssignableObject(Object obj) {
            this.checkAssignableClass(class$org$netbeans$tax$spec$Element$Attribute == null ? (class$org$netbeans$tax$spec$Element$Attribute = AttributesContentManager.class$("org.netbeans.tax.spec.Element$Attribute")) : class$org$netbeans$tax$spec$Element$Attribute, obj);
        }

        public void objectInserted(TreeObject obj) {
            ((TreeAttribute)obj).setOwnerElement(TreeElement.this);
            TreeElement.this.firePropertyChange(TreeElement.PROP_ATTRIBUTES, TreeElement.this.attributes, null);
        }

        public void objectRemoved(TreeObject obj) {
            ((TreeAttribute)obj).setOwnerElement(null);
            TreeElement.this.firePropertyChange(TreeElement.PROP_ATTRIBUTES, TreeElement.this.attributes, null);
        }

        public void orderChanged(int[] permutation) {
            TreeElement.this.firePropertyChange(TreeElement.PROP_ATTRIBUTES, TreeElement.this.attributes, null);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected class ChildListContentManager
    extends TreeParentNode.ChildListContentManager {
        static /* synthetic */ Class class$org$netbeans$tax$spec$Element$Child;

        protected ChildListContentManager() {
            super(TreeElement.this);
        }

        public TreeNode getOwnerNode() {
            return TreeElement.this;
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(class$org$netbeans$tax$spec$Element$Child == null ? (class$org$netbeans$tax$spec$Element$Child = ChildListContentManager.class$("org.netbeans.tax.spec.Element$Child")) : class$org$netbeans$tax$spec$Element$Child, obj);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

