/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import org.netbeans.tax.AbstractUtil;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.decl.EMPTYType;
import org.netbeans.tax.decl.parser.ContentSpecParser;
import org.netbeans.tax.decl.parser.ParserReader;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeElementDecl
extends TreeNodeDecl
implements DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_NAME = "name";
    public static final String PROP_CONTENT_TYPE = "contentType";
    private String name;
    private ContentType contentType;

    public TreeElementDecl(String name, ContentType contentType) throws InvalidArgumentException {
        this.checkName(name);
        this.checkContentType(contentType);
        this.name = name;
        this.contentType = contentType;
        this.contentType.setNodeDecl(this);
    }

    protected TreeElementDecl(TreeElementDecl elementDecl) {
        super(elementDecl);
        this.name = elementDecl.name;
        this.contentType = (ContentType)elementDecl.contentType.clone();
    }

    public Object clone() {
        return new TreeElementDecl(this);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeElementDecl peer = (TreeElementDecl)object;
        if (!AbstractUtil.equals(this.getName(), peer.getName())) {
            return false;
        }
        return AbstractUtil.equals(this.contentType, peer.contentType);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeElementDecl peer = (TreeElementDecl)treeObject;
        this.setNameImpl(peer.getName());
        this.setContentTypeImpl(peer.getContentType());
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(PROP_NAME, oldName, newName);
    }

    public final void setName(String newName) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.name, newName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(newName);
        this.setNameImpl(newName);
    }

    protected final void checkName(String name) throws InvalidArgumentException {
        TreeUtilities.checkElementDeclName(name);
    }

    public final ContentType getContentType() {
        return this.contentType;
    }

    private final void setContentTypeImpl(ContentType newContentType) {
        ContentType oldContentType = this.contentType;
        this.contentType = newContentType;
        this.firePropertyChange(PROP_CONTENT_TYPE, oldContentType, newContentType);
    }

    public final void setContentType(ContentType newContentType) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.contentType, newContentType)) {
            return;
        }
        this.checkReadOnly();
        this.checkContentType(newContentType);
        this.setContentTypeImpl(newContentType);
    }

    public final void setContentType(String newContentType) throws ReadOnlyException, InvalidArgumentException {
        this.setContentType(new ContentSpecParser().parseModel(new ParserReader(newContentType)));
    }

    protected final void checkContentType(ContentType contentType) throws InvalidArgumentException {
        TreeUtilities.checkElementDeclContentType(contentType);
    }

    public boolean isMixed() {
        return this.getContentType().isMixed();
    }

    public boolean isEmpty() {
        return !this.allowText() && !this.allowElements();
    }

    public boolean allowText() {
        return this.getContentType().allowText();
    }

    public boolean allowElements() {
        return this.getContentType().allowElements();
    }

    public Collection getAttributeDefs() {
        if (this.getOwnerDTD() == null) {
            return null;
        }
        return this.getOwnerDTD().getAttributeDeclarations(this.getName());
    }

    public static abstract class ContentType
    extends TreeNodeDecl.Content
    implements Comparable {
        private String multiplicity;
        private int index;
        private static int counter = 0;

        protected ContentType(TreeElementDecl elementDecl) {
            super(elementDecl);
            this.multiplicity = new String();
            this.index = counter++;
        }

        protected ContentType() {
            this((TreeElementDecl)null);
        }

        protected ContentType(ContentType contentType) {
            super(contentType);
            this.multiplicity = contentType.multiplicity;
            this.index = counter++;
        }

        public boolean equals(Object object, boolean deep) {
            if (!super.equals(object, deep)) {
                return false;
            }
            ContentType peer = (ContentType)object;
            if (this.index != peer.index) {
                return false;
            }
            return AbstractUtil.equals(this.getMultiplicity(), peer.getMultiplicity());
        }

        public void merge(TreeObject treeObject) throws CannotMergeException {
            super.merge(treeObject);
            ContentType peer = (ContentType)treeObject;
            this.index = peer.index;
            this.setMultiplicity(peer.getMultiplicity());
        }

        public final void removeFromContext() throws ReadOnlyException {
            if (this.isInContext()) {
                this.getOwnerElementDecl().setContentTypeImpl(new EMPTYType());
            }
        }

        public final TreeElementDecl getOwnerElementDecl() {
            return (TreeElementDecl)this.getNodeDecl();
        }

        public void setMultiplicity(char s) {
            this.multiplicity = new String(new char[]{s});
        }

        public void setMultiplicity(String s) {
            this.multiplicity = s;
        }

        public void addMultiplicity(String s) {
            if (this.multiplicity.equals(s)) {
                return;
            }
            if ("".equals(this.multiplicity)) {
                this.multiplicity = s;
            } else if (!"".equals(s)) {
                this.multiplicity = "*";
            }
        }

        public String getMultiplicity() {
            return this.multiplicity;
        }

        public boolean isMixed() {
            return this.allowText() && this.allowElements();
        }

        public abstract boolean allowElements();

        public abstract boolean allowText();

        public abstract String toString();

        public int compareTo(Object obj) {
            if (this.equals(obj)) {
                return 0;
            }
            ContentType type = (ContentType)obj;
            return this.index - type.index;
        }
    }
}

