/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openidex.nodes.looks.DefaultLook;
import org.openidex.nodes.looks.Look;
import org.openidex.nodes.looks.LookChildren;
import org.openidex.nodes.looks.LookProperties;

public final class LookNode
extends Node
implements Node.Cookie {
    private static Image DEFAULT_ICON_16;
    private static Image DEFAULT_ICON_32;
    private static final String DEFAULT_ICON_16_NAME = "org/openidex/nodes/looks/resources/defaultNode.gif";
    private static final String DEFAULT_ICON_32_NAME = "org/openidex/nodes/looks/resources/defaultNode32.gif";
    private SubstituteImpl substitute = null;
    private final String lock = "LookNode.lock";
    private Look look = null;
    private Look lookCandidate = null;
    private CookieSet cookieSet = null;
    static /* synthetic */ Class class$org$openidex$nodes$looks$Look;
    static /* synthetic */ Class class$org$openidex$nodes$looks$LookNode;

    public LookNode(Object object) {
        this(object, null);
    }

    public LookNode(Object object, Look look) {
        super((Children)new LookChildren());
        this.substitute = new SubstituteImpl(object);
        this.look = look;
        if (look != null) {
            look.attachTo(this.substitute);
        }
    }

    Look.NodeSubstitute getSubstitute() {
        return this.substitute;
    }

    public Object getRepresentedObject() {
        return this.substitute.getRepresentedObject();
    }

    public void setLook(Look look) {
        this.lookCandidate = look;
        this.look = look;
        this.getLook().attachTo(this.getSubstitute());
        this.fireCookieChange();
        this.refreshChildren();
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    private CookieSet getCookieSet() {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null) {
            return cookieSet;
        }
        LookNode lookNode = this;
        synchronized (lookNode) {
            if (this.cookieSet != null) {
                CookieSet cookieSet2 = this.cookieSet;
                return cookieSet2;
            }
            this.cookieSet = new CookieSet();
            this.cookieSet.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    LookNode.super.fireCookieChange();
                }
            });
            CookieSet cookieSet3 = this.cookieSet;
            return cookieSet3;
        }
    }

    void refreshChildren() {
        ((LookChildren)this.getChildren()).refreshChildren();
    }

    public Look getLook() {
        if (this.look != null) {
            return this.look;
        }
        Node node = this.getParentNode();
        if (node == null || !(node instanceof LookNode)) {
            if (this.lookCandidate != null) {
                this.look = this.lookCandidate;
                this.look.attachTo(this.substitute);
                return this.look;
            }
            return DefaultLook.INSTANCE;
        }
        return ((LookNode)node).getLook();
    }

    final Look getHardLook() {
        return this.look;
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == (class$org$openidex$nodes$looks$Look == null ? (class$org$openidex$nodes$looks$Look = LookNode.class$("org.openidex.nodes.looks.Look")) : class$org$openidex$nodes$looks$Look)) {
            return this.getLook();
        }
        if (clazz == (class$org$openidex$nodes$looks$LookNode == null ? (class$org$openidex$nodes$looks$LookNode = LookNode.class$("org.openidex.nodes.looks.LookNode")) : class$org$openidex$nodes$looks$LookNode)) {
            return this;
        }
        Node.Cookie cookie = this.getCookieSet().getCookie(clazz);
        if (cookie == null) {
            return this.getLook().getCookie(this.substitute, clazz);
        }
        return cookie;
    }

    public Node.Handle getHandle() {
        return this.getLook().getHandle(this.substitute);
    }

    public Node cloneNode() {
        LookNode lookNode = new LookNode(this.getRepresentedObject());
        lookNode.lookCandidate = this.look != null ? this.look : this.lookCandidate;
        return lookNode;
    }

    public String getDisplayName() {
        String string = this.getLook().getDisplayName(this.substitute);
        if (string == null) {
            return this.getName();
        }
        return string;
    }

    public void setDisplayName(String string) {
    }

    public String getName() {
        return this.getLook().getName(this.substitute);
    }

    public void setName(String string) {
        this.getLook().setName(this.substitute, string);
    }

    public void setShortDescription(String string) {
    }

    public String getShortDescription() {
        String string = this.getLook().getShortDescription(this.substitute);
        if (string == null) {
            return this.getDisplayName();
        }
        return string;
    }

    public Image getIcon(int n) {
        Image image = this.getLook().getIcon(this.substitute, n);
        if (image == null) {
            if (n == 2 || n == 4) {
                if (DEFAULT_ICON_32 == null) {
                    DEFAULT_ICON_32 = Utilities.loadImage((String)DEFAULT_ICON_32_NAME);
                }
                return DEFAULT_ICON_32;
            }
            if (DEFAULT_ICON_16 == null) {
                DEFAULT_ICON_16 = Utilities.loadImage((String)DEFAULT_ICON_16_NAME);
            }
            return DEFAULT_ICON_16;
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = this.getLook().getOpenedIcon(this.substitute, n);
        if (image == null) {
            return this.getIcon(n);
        }
        return image;
    }

    public HelpCtx getHelpCtx() {
        return this.getLook().getHelpCtx(this.substitute);
    }

    public NewType[] getNewTypes() {
        return this.getLook().getNewTypes(this.substitute);
    }

    public SystemAction[] getActions() {
        SystemAction[] systemActionArray = this.getLook().getActions(this.substitute);
        if (systemActionArray == null) {
            systemActionArray = super.getActions();
        }
        int n = systemActionArray.length;
        SystemAction[] systemActionArray2 = new SystemAction[n + 2];
        System.arraycopy(systemActionArray, 0, systemActionArray2, 0, n);
        SystemAction systemAction = LookProperties.getSetLookAction(this);
        System.arraycopy(new SystemAction[]{null, systemAction}, 0, systemActionArray2, n, 2);
        return systemActionArray2;
    }

    public SystemAction[] getContextActions() {
        return this.getLook().getContextActions(this.substitute);
    }

    public SystemAction getDefaultAction() {
        return this.getLook().getDefaultAction(this.substitute);
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet[] propertySetArray = this.getLook().getPropertySets(this.substitute);
        Node.PropertySet[] propertySetArray2 = new Node.PropertySet[propertySetArray.length + 1];
        System.arraycopy(propertySetArray, 0, propertySetArray2, 0, propertySetArray.length);
        Sheet.Set set = LookProperties.getLookPropertySet(this);
        propertySetArray2[propertySetArray2.length - 1] = set;
        return propertySetArray2;
    }

    public Component getCustomizer() {
        return this.getLook().getCustomizer(this.substitute);
    }

    public boolean hasCustomizer() {
        return this.getLook().hasCustomizer(this.substitute);
    }

    public boolean canRename() {
        return this.getLook().canRename(this.substitute);
    }

    public boolean canDestroy() {
        return this.getLook().canDestroy(this.substitute);
    }

    public boolean canCopy() {
        return this.getLook().canCopy(this.substitute);
    }

    public boolean canCut() {
        return this.getLook().canCut(this.substitute);
    }

    public PasteType[] getPasteTypes(Transferable transferable) {
        return this.getLook().getPasteTypes(this.substitute, transferable);
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return this.getLook().getDropType(this.substitute, transferable, n, n2);
    }

    public Transferable clipboardCopy() throws IOException {
        return this.getLook().clipboardCopy(this.substitute);
    }

    public Transferable clipboardCut() throws IOException {
        return this.getLook().clipboardCut(this.substitute);
    }

    public Transferable drag() throws IOException {
        return this.getLook().drag(this.substitute);
    }

    public void destroy() throws IOException {
        this.getLook().destroy(this.substitute);
        super.destroy();
    }

    boolean hasLookNodeParent() {
        Node node = this.getParentNode();
        return node != null && node instanceof LookNode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SubstituteImpl
    extends Look.NodeSubstitute {
        private Object representedObject;
        private CookieSet cookieSet;

        private SubstituteImpl(Object object) {
            this.representedObject = object;
        }

        public Object getRepresentedObject() {
            return this.representedObject;
        }

        public final void firePropertyChange(String string, Object object, Object object2) {
            LookNode.super.firePropertyChange(string, object, object2);
        }

        public final void fireNameChange(String string, String string2) {
            LookNode.super.fireNameChange(string, string2);
        }

        public final void fireDisplayNameChange(String string, String string2) {
            LookNode.super.fireDisplayNameChange(string, string2);
        }

        public final void fireShortDescriptionChange(String string, String string2) {
            LookNode.super.fireShortDescriptionChange(string, string2);
        }

        public final void fireIconChange() {
            LookNode.super.fireIconChange();
        }

        public final void fireOpenedIconChange() {
            LookNode.super.fireOpenedIconChange();
        }

        public final void firePropertySetsChange(Node.PropertySet[] propertySetArray, Node.PropertySet[] propertySetArray2) {
            LookNode.super.firePropertySetsChange(propertySetArray, propertySetArray2);
        }

        public final void fireCookieChange() {
            LookNode.super.fireCookieChange();
        }

        public final void fireNodeDestroyed() {
            LookNode.super.fireNodeDestroyed();
        }

        public final void refreshChildren() {
            LookNode.this.refreshChildren();
        }

        public CookieSet getCookieSet() {
            if (this.cookieSet == null) {
                this.cookieSet = new CookieSet();
            }
            return this.cookieSet;
        }
    }
}

