/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.logging;

import java.io.Writer;
import javax.servlet.ServletContext;
import org.apache.jasper.logging.JasperLogger;
import org.apache.jasper.util.Queue;

class LogDaemon
extends Thread {
    static char[] newline;
    static String separator;
    Runnable flusher = new Runnable(){

        public void run() {
            do {
                JasperLogger.LogEntry logEntry = (JasperLogger.LogEntry)LogDaemon.this.logQueue.pull();
                if (LogDaemon.this.servletContext != null) {
                    LogDaemon.this.servletContext.log(logEntry.toString());
                    LogDaemon.this.servletContext.log(separator);
                    continue;
                }
                Writer writer = logEntry.getWriter();
                if (writer == null) continue;
                try {
                    writer.write(logEntry.toString());
                    writer.write(newline);
                    writer.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } while (!LogDaemon.this.logQueue.isEmpty());
        }
    };
    private Queue logQueue;
    private ServletContext servletContext;

    static {
        separator = System.getProperty("line.separator", "\n");
        newline = separator.toCharArray();
    }

    LogDaemon(Queue logQueue, ServletContext servletContext) {
        this.logQueue = logQueue;
        this.servletContext = servletContext;
        this.setDaemon(true);
    }

    public void flush() {
        Thread workerThread = new Thread(this.flusher);
        workerThread.start();
    }

    public void run() {
        while (true) {
            this.flusher.run();
        }
    }
}

