/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.httpfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.javadoc.httpfs.HTTPFileInputStream;
import org.netbeans.modules.javadoc.httpfs.HTTPFileSystem;
import org.netbeans.modules.javadoc.httpfs.ResourceUtils;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

class HTTPFileObject
extends FileObject {
    private static final long serialVersionUID = 200104L;
    transient HTTPFileSystem parentFileSystem;
    String uriStem;
    private transient HTTPFileObject parentFileObject;
    private transient Map childFileObjects;
    transient URL fileURL;
    private transient String fullFileName;
    private transient String fileName;
    private transient String fileExtension;
    private transient boolean wasFileHeaderRead;
    private transient long fileSize;
    private transient String fileMIMEType;
    private transient Date fileDate;
    private transient Hashtable fileAttributes;
    private transient boolean areFolderContentsKnown;
    private transient Vector listeners;

    HTTPFileObject(String string, HTTPFileSystem hTTPFileSystem) {
        this.initialize(string, hTTPFileSystem);
    }

    protected HTTPFileObject() {
    }

    private void initialize(String string, HTTPFileSystem hTTPFileSystem) {
        try {
            this.parentFileSystem = hTTPFileSystem;
            this.parentFileObject = null;
            this.childFileObjects = Collections.synchronizedMap(new Hashtable());
            this.uriStem = string;
            this.fileURL = new URL(hTTPFileSystem.baseURL, "." + string);
            this.fileAttributes = new Hashtable(0);
            this.areFolderContentsKnown = true;
            this.listeners = new Vector();
            this.fullFileName = "";
            this.fileName = "";
            this.fileExtension = "";
            if (this.isFolder()) {
                this.wasFileHeaderRead = true;
                this.fullFileName = string.substring(0, string.length() - 1);
            } else {
                this.wasFileHeaderRead = false;
                this.fileSize = -1L;
                this.fileMIMEType = "";
                this.fileDate = new Date();
                this.fullFileName = string;
            }
            this.fullFileName = this.fullFileName.substring(this.fullFileName.lastIndexOf(47) + 1);
            if (this.fullFileName.lastIndexOf(46) != -1) {
                this.fileName = this.fullFileName.substring(0, this.fullFileName.lastIndexOf(46));
                this.fileExtension = this.fullFileName.substring(this.fullFileName.lastIndexOf(46) + 1);
            } else {
                this.fileName = this.fullFileName;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.parentFileSystem.getSystemName());
        objectOutputStream.writeObject(this.uriStem);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = (String)objectInputStream.readObject();
        HTTPFileSystem hTTPFileSystem = (HTTPFileSystem)Repository.getDefault().findFileSystem(string);
        String string2 = (String)objectInputStream.readObject();
        this.initialize(string2, hTTPFileSystem);
    }

    private void readFileHeader() {
        try {
            this.getFileConnection("HEAD").disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpURLConnection getFileConnection(String string) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.fileURL.openConnection();
        httpURLConnection.setUseCaches(true);
        httpURLConnection.setRequestMethod(string);
        if (!this.wasFileHeaderRead) {
            this.readFileHeadersFromConnection(httpURLConnection);
        }
        return httpURLConnection;
    }

    private HttpURLConnection getFileConnection() throws IOException {
        return this.getFileConnection("GET");
    }

    private void readFileHeadersFromConnection(HttpURLConnection httpURLConnection) {
        this.fileSize = httpURLConnection.getContentLength();
        this.fileMIMEType = httpURLConnection.getContentType();
        this.fileDate = new Date(httpURLConnection.getLastModified());
        this.wasFileHeaderRead = true;
    }

    public FileSystem getFileSystem() throws FileStateInvalidException {
        if (this.parentFileSystem != null) {
            return this.parentFileSystem;
        }
        throw new FileStateInvalidException(ResourceUtils.getBundledString("MSG_FilesystemNotFound"));
    }

    public String getName() {
        return this.fileName;
    }

    public String getExt() {
        return this.fileExtension;
    }

    public String getNameExt() {
        return this.fullFileName;
    }

    public long getSize() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileSize;
    }

    public String getMIMEType() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileMIMEType;
    }

    public FileObject getParent() {
        return this.parentFileObject;
    }

    public Date lastModified() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileDate;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValid() {
        return this.fileURL != null;
    }

    public boolean isRoot() {
        return this.uriStem.equals("/");
    }

    public boolean isFolder() {
        return this.uriStem.endsWith("/");
    }

    public boolean isData() {
        return !this.isFolder();
    }

    public FileLock lock() throws IOException {
        return FileLock.NONE;
    }

    public FileObject createData(String string, String string2) throws IOException {
        throw new IOException();
    }

    public FileObject createFolder(String string) throws IOException {
        throw new IOException();
    }

    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        throw new IOException();
    }

    public void delete(FileLock fileLock) throws IOException {
        throw new IOException();
    }

    public void setImportant(boolean bl) {
    }

    public Enumeration getAttributes() {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileAttributes.keys();
    }

    public Object getAttribute(String string) {
        if (!this.wasFileHeaderRead) {
            this.readFileHeader();
        }
        return this.fileAttributes.get(string);
    }

    public void setAttribute(String string, Object object) throws IOException {
        throw new IOException();
    }

    public FileObject[] getChildren() {
        return this.getChildFileObjects(true).values().toArray(new FileObject[0]);
    }

    public FileObject getFileObject(String string, String string2) {
        if (!string2.equals("")) {
            return this.child(string + "." + string2);
        }
        return this.child(string);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        try {
            return new HTTPFileInputStream(this.getFileConnection());
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
    }

    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        throw new IOException();
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.listeners.add(fileChangeListener);
    }

    public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.listeners.remove(fileChangeListener);
    }

    void addChild(HTTPFileObject hTTPFileObject) {
        hTTPFileObject.parentFileObject = this;
        this.childFileObjects.put(hTTPFileObject.getNameExt(), hTTPFileObject);
        if (!this.listeners.isEmpty()) {
            if (hTTPFileObject.isData()) {
                this.fireFileDataCreatedEvent(this.listeners.elements(), new FileEvent((FileObject)this, (FileObject)hTTPFileObject, true));
            } else {
                this.fireFileFolderCreatedEvent(this.listeners.elements(), new FileEvent((FileObject)this, (FileObject)hTTPFileObject, true));
            }
        }
    }

    void removeAllChildren() {
        Map map = this.childFileObjects;
        synchronized (map) {
            Iterator iterator = this.childFileObjects.values().iterator();
            while (iterator.hasNext()) {
                HTTPFileObject hTTPFileObject = (HTTPFileObject)((Object)iterator.next());
                iterator.remove();
                hTTPFileObject.parentFileObject = null;
                if (this.listeners.isEmpty()) continue;
                this.fireFileDeletedEvent(this.listeners.elements(), new FileEvent((FileObject)this, (FileObject)hTTPFileObject, true));
            }
        }
    }

    void addChild(String string) {
        this.addChild(new HTTPFileObject(string, this.parentFileSystem));
    }

    boolean addOptionalChild(String string) {
        boolean bl;
        HttpURLConnection httpURLConnection = null;
        try {
            block8: {
                try {
                    HTTPFileObject hTTPFileObject = new HTTPFileObject(string, this.parentFileSystem);
                    httpURLConnection = hTTPFileObject.getFileConnection("HEAD");
                    if (httpURLConnection.getResponseCode() < 400) {
                        this.addChild(hTTPFileObject);
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    bl = false;
                    Object var7_6 = null;
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
            Object var7_5 = null;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw throwable;
        }
        return bl;
    }

    HTTPFileObject child(String string) {
        return this.child(string, true);
    }

    HTTPFileObject child(String string, boolean bl) {
        return (HTTPFileObject)((Object)this.getChildFileObjects(bl).get(string));
    }

    private Map getChildFileObjects(boolean bl) {
        if (bl) {
            Map map = this.childFileObjects;
            synchronized (map) {
                if (!this.areFolderContentsKnown) {
                    this.readPackageContents();
                }
            }
        }
        return this.childFileObjects;
    }

    void makePackage() {
        this.areFolderContentsKnown = false;
    }

    private void readPackageContents() {
        block10: {
            HTTPFileObject hTTPFileObject;
            HTTPFileObject hTTPFileObject2 = new HTTPFileObject(this.uriStem + "package-summary.html", this.parentFileSystem);
            this.addChild(hTTPFileObject2);
            this.addOptionalChild(this.uriStem + "package-frame.html");
            this.addOptionalChild(this.uriStem + "package-tree.html");
            if (this.addOptionalChild(this.uriStem + "package-use.html")) {
                hTTPFileObject = new HTTPFileObject(this.uriStem + "class-use/", this.parentFileSystem);
                this.addChild(hTTPFileObject);
            } else {
                hTTPFileObject = null;
            }
            try {
                try {
                    InputStream inputStream = hTTPFileObject2.getInputStream();
                    HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
                    HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
                    hTMLEditorKit.read(new InputStreamReader(inputStream), (Document)hTMLDocument, 0);
                    HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
                    while (iterator.isValid()) {
                        String string = (String)iterator.getAttributes().getAttribute(HTML.Attribute.HREF);
                        if (!(string == null || string.indexOf(47) != -1 || string.startsWith(".") || string.startsWith("#") || string.indexOf(58) != -1 || string.startsWith("package-"))) {
                            this.addChild(this.uriStem + string);
                            if (hTTPFileObject != null) {
                                hTTPFileObject.addChild(hTTPFileObject.uriStem + string);
                            }
                        }
                        iterator.next();
                    }
                    inputStream.close();
                }
                catch (BadLocationException badLocationException) {
                    Object var11_9 = null;
                    this.areFolderContentsKnown = true;
                    break block10;
                }
                catch (IOException iOException) {
                    Object var11_10 = null;
                    this.areFolderContentsKnown = true;
                }
                Object var11_8 = null;
                this.areFolderContentsKnown = true;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.areFolderContentsKnown = true;
                throw throwable;
            }
        }
    }
}

