/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.httpfs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.netbeans.modules.javadoc.httpfs.HTTPFileObject;
import org.netbeans.modules.javadoc.httpfs.HTTPRootFileObject;
import org.netbeans.modules.javadoc.httpfs.RefreshAction;
import org.netbeans.modules.javadoc.httpfs.ResourceUtils;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public class HTTPFileSystem
extends FileSystem
implements VetoableChangeListener {
    public static final String PROP_URL = "URL";
    public static final String PROP_REFRESH_RATE = "RefreshRate";
    public static final String PROP_STATE = "State";
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_READING = 1;
    public static final int STATE_COMPLETE = 2;
    private static final long serialVersionUID = 200104L;
    private static final String DEFAULT_URL = "http://www.netbeans.org/download/apis/";
    transient URL baseURL;
    transient HTTPRootFileObject rootFileObject;
    transient int refreshRate;
    transient int currentState;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$httpfs$RefreshAction;

    public HTTPFileSystem() {
        FileSystemCapability.Bean bean = new FileSystemCapability.Bean();
        bean.setDoc(true);
        bean.setExecute(false);
        bean.setCompile(false);
        bean.setDebug(false);
        this.setCapability((FileSystemCapability)bean);
        this.setHidden(true);
        this.addVetoableChangeListener(this);
        this.refreshRate = 0;
        this.currentState = 0;
        try {
            this.setURL(DEFAULT_URL);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.baseURL.toString());
        objectOutputStream.writeInt(this.refreshRate);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.addVetoableChangeListener(this);
        try {
            this.setURL((String)objectInputStream.readObject());
            try {
                this.refreshRate = objectInputStream.readInt();
            }
            catch (IOException iOException) {
                this.refreshRate = 0;
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IOException(propertyVetoException.getMessage());
        }
    }

    public String getURL() {
        return this.baseURL.toString();
    }

    public synchronized void setURL(String string) throws PropertyVetoException {
        URL uRL = this.baseURL;
        HTTPRootFileObject hTTPRootFileObject = this.rootFileObject;
        try {
            try {
                this.baseURL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new PropertyVetoException(malformedURLException.toString(), new PropertyChangeEvent(this, PROP_URL, uRL != null ? uRL.toExternalForm() : null, string));
            }
            this.rootFileObject = new HTTPRootFileObject(this);
            this.fireVetoableChange(PROP_URL, uRL != null ? uRL.toExternalForm() : null, string);
            this.setSystemName(this.getClass().getName() + "/" + this.baseURL.toExternalForm());
        }
        catch (PropertyVetoException propertyVetoException) {
            this.baseURL = uRL;
            this.rootFileObject = hTTPRootFileObject;
            throw propertyVetoException;
        }
        this.firePropertyChange(PROP_URL, uRL != null ? uRL.toExternalForm() : null, string);
        this.firePropertyChange("root", hTTPRootFileObject, this.rootFileObject);
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int n) throws PropertyVetoException {
        int n2 = this.refreshRate;
        try {
            this.refreshRate = n;
            this.fireVetoableChange(PROP_REFRESH_RATE, new Integer(n2), new Integer(n));
        }
        catch (PropertyVetoException propertyVetoException) {
            this.refreshRate = n2;
            throw propertyVetoException;
        }
        this.firePropertyChange(PROP_REFRESH_RATE, new Integer(n2), new Integer(n));
    }

    public int getState() {
        return this.currentState;
    }

    void setState(int n) {
        if (n != this.currentState) {
            String string = this.getDisplayName();
            int n2 = this.currentState;
            this.currentState = n;
            this.firePropertyChange(PROP_STATE, new Integer(n2), new Integer(n));
            if (!string.equals(this.getDisplayName())) {
                this.firePropertyChange("displayName", string, this.getDisplayName());
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        int n;
        if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals(PROP_URL)) {
            URL uRL;
            try {
                uRL = new URL((String)propertyChangeEvent.getNewValue());
            }
            catch (MalformedURLException malformedURLException) {
                throw new PropertyVetoException(malformedURLException.toString(), propertyChangeEvent);
            }
            if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) {
                throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_NotHTTPProtocol"), propertyChangeEvent);
            }
            if (!uRL.toExternalForm().endsWith("/")) {
                throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_NotDirectory"), propertyChangeEvent);
            }
        } else if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals(PROP_REFRESH_RATE) && (n = ((Integer)propertyChangeEvent.getNewValue()).intValue()) < 0) {
            throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_RefreshRateCannotBeNegative"), propertyChangeEvent);
        }
    }

    public FileObject getRoot() {
        return this.rootFileObject;
    }

    public String getDisplayName() {
        Object[] objectArray = new Object[]{this.baseURL.toExternalForm()};
        String string = this.getState() == 1 ? "DisplayName_Scanning" : "DisplayName_Normal";
        return ResourceUtils.getFormattedBundledString(string, objectArray);
    }

    public FileObject findResource(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        HTTPFileObject hTTPFileObject = (HTTPFileObject)this.getRoot();
        while (hTTPFileObject != null && stringTokenizer.hasMoreElements()) {
            hTTPFileObject = hTTPFileObject.child((String)stringTokenizer.nextElement());
        }
        return hTTPFileObject;
    }

    public boolean isReadOnly() {
        return true;
    }

    public SystemAction[] getActions() {
        Class clazz = class$org$netbeans$modules$javadoc$httpfs$RefreshAction == null ? (class$org$netbeans$modules$javadoc$httpfs$RefreshAction = HTTPFileSystem.class$("org.netbeans.modules.javadoc.httpfs.RefreshAction")) : class$org$netbeans$modules$javadoc$httpfs$RefreshAction;
        RefreshAction refreshAction = (RefreshAction)SharedClassObject.findObject((Class)clazz, (boolean)true);
        return new SystemAction[]{refreshAction};
    }

    public void prepareEnvironment(FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        throw new EnvironmentNotSupportedException((FileSystem)this);
    }

    protected void finalize() throws Throwable {
        this.removeVetoableChangeListener(this);
        this.rootFileObject = null;
        this.baseURL = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

