/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.ResourceUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

class SearchThreadJdk12
extends IndexSearchThread {
    private BufferedReader in;
    private URL contextURL;
    private boolean stopSearch = false;
    private boolean splitedIndex = false;
    private int currentIndexNumber;
    private FileObject folder = null;
    private static final String STR_CLASS = ResourceUtils.getBundledString("JDK12_CLASS");
    private static final String STR_INTERFACE = ResourceUtils.getBundledString("JDK12_INTERFACE");
    private static final String STR_EXCEPTION = ResourceUtils.getBundledString("JDK12_EXCEPTION");
    private static final String STR_CONSTRUCTOR = ResourceUtils.getBundledString("JDK12_CONSTRUCTOR");
    private static final String STR_METHOD = ResourceUtils.getBundledString("JDK12_METHOD");
    private static final String STR_ERROR = ResourceUtils.getBundledString("JDK12_ERROR");
    private static final String STR_VARIABLE = ResourceUtils.getBundledString("JDK12_VARIABLE");
    private static final String STR_STATIC = ResourceUtils.getBundledString("JDK12_STATIC");
    private static final String STR_DASH = ResourceUtils.getBundledString("JDK12_DASH");
    private static final String STR_PACKAGE = ResourceUtils.getBundledString("JDK12_PACKAGE");
    private static final int IN_BALAST = 0;
    private static final int IN_DT = 1;
    private static final int IN_AREF = 2;
    private static final int IN_B = 3;
    private static final int IN_DESCRIPTION = 4;
    private static final int IN_DESCRIPTION_SUFFIX = 5;

    public SearchThreadJdk12(String string, FileObject fileObject, IndexSearchThread.DocIndexItemConsumer docIndexItemConsumer, boolean bl) {
        super(string, fileObject, docIndexItemConsumer, bl);
        if (fileObject.isFolder()) {
            this.folder = fileObject;
            this.currentIndexNumber = Character.toUpperCase(this.lastField.charAt(0)) - 65 + 1;
            if (this.currentIndexNumber < 1) {
                this.currentIndexNumber = 1;
            } else if (this.currentIndexNumber > 26) {
                this.currentIndexNumber = 27;
            }
            this.findFileObject(0);
            this.splitedIndex = true;
        } else {
            try {
                this.contextURL = this.fo.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw new InternalError("Can't create documentation folder URL - file state invalid");
            }
            this.splitedIndex = false;
        }
    }

    public void stopSearch() {
        this.stopSearch = true;
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void run() {
        ParserDelegator parserDelegator = new ParserDelegator();
        if (this.fo == null || this.lastField == null || this.lastField.length() == 0) {
            this.taskFinished();
            return;
        }
        SearchCallbackJdk12 searchCallbackJdk12 = null;
        int n = 0;
        do {
            if (searchCallbackJdk12 != null) {
                if (searchCallbackJdk12.badFile != n) break;
                this.findFileObject(searchCallbackJdk12.badFile);
                if (this.fo == null) break;
            }
            try {
                this.in = new BufferedReader(new InputStreamReader(this.fo.getInputStream()));
                searchCallbackJdk12 = new SearchCallbackJdk12(this.splitedIndex, this.caseSensitive);
                parserDelegator.parse(this.in, searchCallbackJdk12, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (searchCallbackJdk12.badFile == 0 || n != 0) continue;
            n = searchCallbackJdk12.badFile;
        } while (searchCallbackJdk12.badFile != 0);
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.taskFinished();
    }

    void findFileObject(int n) {
        if (n < 0) {
            --this.currentIndexNumber;
        } else if (n > 0) {
            ++this.currentIndexNumber;
        }
        do {
            if (this.currentIndexNumber < 0 || this.currentIndexNumber > 27) {
                this.fo = null;
                return;
            }
            Integer n2 = new Integer(this.currentIndexNumber);
            String string = new String("index-" + n2.toString());
            if (this.folder == null) {
                this.fo = null;
                return;
            }
            this.fo = this.folder.getFileObject(string, "html");
            if (this.fo != null) {
                try {
                    this.contextURL = this.fo.getURL();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    throw new InternalError("Can't create documentation folder URL - file state invalid");
                }
            } else {
                this.currentIndexNumber += n > 0 ? 1 : -1;
            }
        } while (this.fo == null);
    }

    private class SearchCallbackJdk12
    extends HTMLEditorKit.ParserCallback {
        private String hrefVal;
        private DocIndexItem currentDii = null;
        private int where = 0;
        private boolean splited;
        private boolean stopOnNext = false;
        private int badFile = 0;
        int printText = 0;

        SearchCallbackJdk12(boolean bl, boolean bl2) {
            this.splited = bl;
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            if (tag == HTML.Tag.DT) {
                this.where = 1;
                this.currentDii = null;
            } else if (tag == HTML.Tag.A && this.where == 1) {
                this.where = 2;
                Object object = mutableAttributeSet.getAttribute(HTML.Attribute.HREF);
                if (object != null) {
                    this.hrefVal = object.toString();
                    this.currentDii = new DocIndexItem(null, null, SearchThreadJdk12.this.contextURL, this.hrefVal);
                }
            } else if (tag != HTML.Tag.A || this.where != 5) {
                this.where = tag == HTML.Tag.B && this.where == 2 ? 2 : 0;
            }
        }

        public void handleText(char[] cArray, int n) {
            if (this.where == 2) {
                char c;
                char c2;
                if (this.stopOnNext) {
                    try {
                        SearchThreadJdk12.this.in.close();
                        this.where = 0;
                        return;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                String string = new String(cArray);
                if (this.splited && (c2 = Character.toUpperCase(SearchThreadJdk12.this.lastField.charAt(0))) != (c = Character.toUpperCase(cArray[0]))) {
                    this.badFile = c2 < c ? -1 : 1;
                    try {
                        SearchThreadJdk12.this.in.close();
                        this.where = 0;
                        return;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                this.currentDii.setField(string.trim());
                this.where = 4;
            } else if (this.where == 4) {
                String string = new String(cArray);
                this.currentDii.setRemark(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(STR_DASH)) {
                    string2 = stringTokenizer.nextToken();
                }
                boolean bl = false;
                if (string2.equalsIgnoreCase(STR_STATIC)) {
                    bl = true;
                    string2 = stringTokenizer.nextToken();
                }
                if (string2.equalsIgnoreCase(STR_CLASS)) {
                    this.currentDii.setIconIndex(2);
                } else if (string2.equalsIgnoreCase(STR_INTERFACE)) {
                    this.currentDii.setIconIndex(3);
                } else if (string2.equalsIgnoreCase(STR_EXCEPTION)) {
                    this.currentDii.setIconIndex(4);
                } else if (string2.equalsIgnoreCase(STR_ERROR)) {
                    this.currentDii.setIconIndex(5);
                } else if (string2.equalsIgnoreCase(STR_PACKAGE)) {
                    this.currentDii.setIconIndex(1);
                } else if (string2.equalsIgnoreCase(STR_CONSTRUCTOR)) {
                    this.currentDii.setIconIndex(6);
                } else if (string2.equalsIgnoreCase(STR_METHOD)) {
                    this.currentDii.setIconIndex(bl ? 8 : 7);
                } else if (string2.equalsIgnoreCase(STR_VARIABLE)) {
                    this.currentDii.setIconIndex(bl ? 10 : 9);
                }
                if (string.endsWith(".")) {
                    this.where = 5;
                    this.currentDii.setPackage(string.substring(string.lastIndexOf(32)).trim());
                } else {
                    this.where = 0;
                }
            } else if (this.where == 5) {
                this.currentDii.setRemark(this.currentDii.getRemark() + new String(cArray));
                String string = new String(cArray).trim();
                if (!".".equals(string)) {
                    this.currentDii.setDeclaringClass(string);
                    SearchThreadJdk12.this.insertDocIndexItem(this.currentDii);
                }
            } else {
                this.where = 0;
            }
        }
    }
}

