/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.netbeans.lib.javac.v8.code.ClassReader;
import org.netbeans.lib.javac.v8.code.ClassWriter;
import org.netbeans.lib.javac.v8.code.Symbol;
import org.netbeans.lib.javac.v8.comp.Attr;
import org.netbeans.lib.javac.v8.comp.AttrContext;
import org.netbeans.lib.javac.v8.comp.Check;
import org.netbeans.lib.javac.v8.comp.Enter;
import org.netbeans.lib.javac.v8.comp.Env;
import org.netbeans.lib.javac.v8.comp.Flow;
import org.netbeans.lib.javac.v8.comp.Gen;
import org.netbeans.lib.javac.v8.comp.Infer;
import org.netbeans.lib.javac.v8.comp.Resolve;
import org.netbeans.lib.javac.v8.comp.Symtab;
import org.netbeans.lib.javac.v8.comp.TransInner;
import org.netbeans.lib.javac.v8.comp.TransTypes;
import org.netbeans.lib.javac.v8.parser.Parser;
import org.netbeans.lib.javac.v8.parser.Scanner;
import org.netbeans.lib.javac.v8.tree.Pretty;
import org.netbeans.lib.javac.v8.tree.Tree;
import org.netbeans.lib.javac.v8.tree.TreeMaker;
import org.netbeans.lib.javac.v8.util.Abort;
import org.netbeans.lib.javac.v8.util.Hashtable;
import org.netbeans.lib.javac.v8.util.List;
import org.netbeans.lib.javac.v8.util.ListBuffer;
import org.netbeans.lib.javac.v8.util.Log;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Set;
import org.netbeans.lib.javac.v8.util.StaticName;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
implements ClassReader.SourceCompleter {
    protected Log log;
    public final Symtab syms;
    protected Check chk;
    Infer infer;
    protected Resolve rs;
    protected TreeMaker make;
    protected Enter enter;
    protected Attr attr;
    Gen gen;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean attrParseOnly;
    public boolean classOutput;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    public boolean gj;
    public boolean allowAsserts;
    public boolean genCrt;
    public String encoding;
    private boolean switchCheck;
    protected ListBuffer<Env<AttrContext>> todo = new ListBuffer();
    Set<File> inputFiles = Set.make();

    public static String version() {
        return System.getProperty("java.version");
    }

    public JavaCompiler(Log log, Symtab symtab, Hashtable<String, String> hashtable) {
        this.log = log;
        this.syms = symtab;
        this.syms.reader.sourceCompleter = this;
        this.chk = new Check(log, symtab, hashtable);
        this.infer = new Infer(log, symtab);
        this.rs = new Resolve(log, symtab, this.chk, this.infer);
        this.make = new TreeMaker();
        this.enter = this.makeEnter();
        this.attr = new Attr(log, symtab, this.rs, this.chk, this.infer, this.make, this.enter, hashtable);
        this.gen = new Gen(log, symtab, this.chk, this.rs, this.make, hashtable);
        this.switchCheck = hashtable.get("-Xswitchcheck") != null;
        this.verbose = hashtable.get("-verbose") != null;
        this.sourceOutput = hashtable.get("-s") != null;
        this.classOutput = hashtable.get("-retrofit") == null;
        this.printFlat = hashtable.get("-printflat") != null;
        this.deprecation = hashtable.get("-deprecation") != null;
        this.warnunchecked = hashtable.get("-warnunchecked") != null;
        this.gj = hashtable.get("-gj") != null;
        this.attrParseOnly = hashtable.get("-attrparseonly") != null;
        this.encoding = hashtable.get("-encoding");
        String string = hashtable.get("-source");
        this.allowAsserts = string != null && string.equals("1.4");
        this.genCrt = hashtable.get("-Xjcov") != null;
    }

    protected Enter makeEnter() {
        return new Enter(this.log, this.syms, this.rs, this.chk, this.make, null, this.todo);
    }

    public static JavaCompiler make(Log log, Hashtable<String, String> hashtable) {
        try {
            return new JavaCompiler(log, new Symtab(new ClassReader(hashtable), new ClassWriter(hashtable)), hashtable);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            log.error(0, completionFailure.getMessage());
            return null;
        }
    }

    public static JavaCompiler make(Hashtable<String, String> hashtable) {
        return JavaCompiler.make(new Log(hashtable.get("-prompt") != null, hashtable.get("-nowarn") == null), hashtable);
    }

    public static JavaCompiler make() {
        return JavaCompiler.make(Hashtable.<String, String>make());
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    public InputStream openSource(String string) {
        try {
            File file = new File(string);
            this.inputFiles.put(file);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            this.log.error(0, "cant.read.file", string);
            return null;
        }
    }

    public Tree.TopLevel parse(String string, InputStream inputStream) {
        long l = System.currentTimeMillis();
        Name name = this.log.useSource(StaticName.fromString(string));
        Tree.TopLevel topLevel = this.make.TopLevel(null, Tree.emptyList);
        if (inputStream != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", string);
            }
            try {
                Scanner scanner = new Scanner(inputStream, this.log, this.encoding);
                inputStream.close();
                Parser parser = new Parser(scanner, this.make, this.log, this.gj, this.keepComments(), this.allowAsserts, this.genCrt);
                topLevel = parser.compilationUnit();
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - l));
                }
            }
            catch (IOException iOException) {
                this.log.error(0, "error.reading.file", string, iOException.toString());
            }
        }
        this.log.useSource(name);
        topLevel.sourcefile = StaticName.fromString(string);
        return topLevel;
    }

    protected boolean keepComments() {
        return this.sourceOutput;
    }

    public Tree.TopLevel parse(String string) {
        return this.parse(string, this.openSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        File file = this.syms.writer.outputFile(classDef.sym, ".java");
        if (this.inputFiles.contains(file)) {
            this.log.error(classDef.pos, "source.cant.overwrite.input.file", file.toString());
        } else {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                new Pretty(printStream).printUnit(env.toplevel, classDef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", file.getPath());
                }
                Object var6_5 = null;
                printStream.close();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                printStream.close();
                throw throwable;
            }
        }
    }

    void genCode(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        this.gen.genClass(env, classDef);
        this.writeClass(classDef.sym);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClass(Symbol.ClassSymbol classSymbol) throws IOException {
        File file = this.syms.writer.outputFile(classSymbol, ".class");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.syms.writer.writeClassFile(fileOutputStream, classSymbol);
            if (this.verbose) {
                this.printVerbose("wrote.file", file.getPath());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    @Override
    public void complete(Symbol.ClassSymbol classSymbol, String string, InputStream inputStream) throws Symbol.CompletionFailure {
        Tree.TopLevel topLevel = this.parse(string, inputStream);
        this.enter.main(List.make(topLevel));
        if (classSymbol.members() == null) {
            ClassReader classReader = this.syms.reader;
            classReader.getClass();
            throw new ClassReader.BadClassFile(classReader, classSymbol, string, Log.getLocalizedString("file.doesnt.contain.class", classSymbol.fullname.toJava()));
        }
    }

    public List<Symbol.ClassSymbol> compile(List<String> list) throws Throwable {
        int n;
        long l = System.currentTimeMillis();
        ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
        try {
            Object object;
            List list2;
            Object object2;
            this.inputFiles.reset();
            Symbol.reset();
            this.chk.compiled.reset();
            ListBuffer<Tree.TopLevel> listBuffer2 = new ListBuffer<Tree.TopLevel>();
            List<String> list3 = list;
            while (list3.nonEmpty()) {
                listBuffer2.append(this.parse((String)list3.head));
                list3 = list3.tail;
            }
            List<Tree> list4 = listBuffer2.toList();
            this.enter.main(list4);
            List<Tree.ClassDef> list5 = null;
            if (this.sourceOutput) {
                object2 = new ListBuffer();
                list2 = list4;
                while (list2.nonEmpty()) {
                    object = ((Tree.TopLevel)list2.head).defs;
                    while (((List)object).nonEmpty()) {
                        if (((List)object).head instanceof Tree.ClassDef) {
                            ((ListBuffer)object2).append((Tree.ClassDef)((List)object).head);
                        }
                        object = ((List)object).tail;
                    }
                    list2 = list2.tail;
                }
                list5 = ((ListBuffer)object2).toList();
            }
            while (this.todo.nonEmpty()) {
                object2 = this.todo.first();
                this.todo.remove();
                list2 = ((Env)object2).tree;
                if (this.verbose) {
                    this.printVerbose("checking.attribution", ((Env)object2).enclClass.sym.toJava());
                }
                object = this.log.useSource(((Env)object2).enclClass.sym.sourcefile);
                this.attr.attribClass(((Env)object2).tree.pos, ((Env)object2).enclClass.sym);
                if (this.attrParseOnly) continue;
                TreeMaker treeMaker = new TreeMaker(((Env)object2).toplevel);
                if (this.errorCount() == 0) {
                    new Flow(this.log, this.syms, this.chk, treeMaker, this.switchCheck).analyzeDef(((Env)object2).tree);
                }
                if (this.errorCount() == 0) {
                    ((Env)object2).tree = new TransTypes(this.log, this.syms, treeMaker).translateTopLevelClass(((Env)object2).tree);
                }
                if (this.errorCount() == 0) {
                    Tree.ClassDef classDef = null;
                    try {
                        if (this.sourceOutput) {
                            classDef = (Tree.ClassDef)((Env)object2).tree;
                            if (list2 instanceof Tree.ClassDef && list5.contains((Tree.ClassDef)((Object)list2))) {
                                this.printSource((Env<AttrContext>)object2, classDef);
                            }
                        } else {
                            List<Tree> list6;
                            List<Tree> list7 = list6 = new TransInner(this.log, this.syms, this.rs, this.chk, this.attr, treeMaker).translateTopLevelClass((Env<AttrContext>)object2, ((Env)object2).tree);
                            while (this.errorCount() == 0 && list7.nonEmpty()) {
                                classDef = (Tree.ClassDef)list7.head;
                                if (this.printFlat) {
                                    this.printSource((Env<AttrContext>)object2, classDef);
                                } else if (this.classOutput) {
                                    this.genCode((Env<AttrContext>)object2, classDef);
                                }
                                listBuffer.append(classDef.sym);
                                list7 = list7.tail;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        this.log.error(classDef.pos, "class.cant.write", classDef.sym.toJava(), iOException.getMessage());
                    }
                }
                this.log.useSource((Name)object);
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - l));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource.toString());
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.noteUnchecked(this.chk.uncheckedSource.toString());
        }
        if ((n = this.errorCount()) == 1) {
            this.printCount("error", n);
        } else {
            this.printCount("error.plural", n);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
        } else {
            this.printCount("warn.plural", this.log.nwarnings);
        }
        return listBuffer.toList();
    }

    public void flush() {
        this.log.flush();
    }

    private void printVerbose(String string, String string2) {
        System.err.println(Log.getLocalizedString(new StringBuffer().append("verbose.").append(string).toString(), string2));
    }

    private void noteDeprecated(String string) {
        if (string.equals("*")) {
            this.log.note("deprecated.plural");
        } else {
            this.log.note("deprecated.filename", string);
        }
        this.log.note("deprecated.recompile");
    }

    void noteUnchecked(String string) {
        if (string.equals("*")) {
            this.log.note("unchecked.plural");
        } else {
            this.log.note("unchecked.filename", string);
        }
        this.log.note("unchecked.recompile");
    }

    void printCount(String string, int n) {
        if (n != 0) {
            this.log.errWriter.println(Log.getLocalizedString(new StringBuffer().append("count.").append(string).toString(), Integer.toString(n)));
            this.log.flush();
        }
    }
}

