/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.netbeans.lib.javac.v8.parser.JavaDocComment;
import org.netbeans.lib.javac.v8.parser.Tokens;
import org.netbeans.lib.javac.v8.util.LayoutCharacters;
import org.netbeans.lib.javac.v8.util.Log;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Names;
import org.netbeans.lib.javac.v8.util.Position;
import org.netbeans.lib.javac.v8.util.StaticName;

public class Scanner
implements Tokens,
LayoutCharacters {
    int token;
    int pos;
    int endPos;
    int prevEndPos;
    int errPos = 0;
    Name name;
    int radix;
    boolean deprecatedFlag = false;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int line;
    private int col;
    private int unicodeConversionBp = -1;
    private static byte[] key;
    private static int maxKey;
    Log log;
    JavaDocComment docComment = null;
    private char[] buffer;
    private int count;
    int tabWidth = 8;
    private static Name[] tokenName;

    public Scanner(InputStream inputStream, Log log, String string, int n) {
        this(inputStream, log, string);
        this.tabWidth = n;
    }

    public Scanner(char[] cArray, Log log, int n) {
        this.tabWidth = n;
        this.log = log;
        this.buflen = cArray.length;
        this.buf = new char[this.buflen + 1];
        System.arraycopy(cArray, 0, this.buf, 0, cArray.length);
        this.buf[this.buflen] = '\u0000';
        this.line = 1;
        this.col = 0;
        this.bp = -1;
        this.scanChar();
        this.nextToken();
    }

    public Scanner(InputStream inputStream, Log log, String string) {
        this.log = log;
        try {
            int n;
            InputStreamReader inputStreamReader;
            int n2 = inputStream.available() + 1;
            if (this.buf == null || this.buf.length < n2) {
                this.buf = new char[n2];
            }
            this.buflen = 0;
            InputStreamReader inputStreamReader2 = inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            while ((n = inputStreamReader.read(this.buf, this.buflen, this.buf.length - this.buflen)) >= 0) {
                this.buflen += n;
                if (this.buflen < this.buf.length) continue;
                char[] cArray = new char[this.buflen * 2];
                System.arraycopy(this.buf, 0, cArray, 0, this.buflen);
                this.buf = cArray;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.lexError("unsupported.encoding", string);
            this.buf = new char[1];
            this.buflen = 0;
        }
        catch (IOException iOException) {
            this.lexError("io.exception", iOException.toString());
            this.buf = new char[1];
            this.buflen = 0;
        }
        this.buf[this.buflen] = '\u0000';
        this.line = 1;
        this.col = 0;
        this.bp = -1;
        this.scanChar();
        this.nextToken();
    }

    private void lexError(int n, String string, String string2) {
        this.log.error(n, string, string2);
        this.token = 1;
        this.errPos = n;
    }

    private void lexError(int n, String string) {
        this.lexError(n, string, null);
    }

    private void lexError(String string) {
        this.lexError(this.pos, string, null);
    }

    private void lexError(String string, String string2) {
        this.lexError(this.pos, string, string2);
    }

    private void convertUnicode() {
        int n = this.col++;
        if (this.ch == '\\') {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                    ++this.col;
                } while (this.ch == 'u');
                int n2 = this.bp + 3;
                if (n2 < this.buflen) {
                    int n3;
                    int n4 = n3 = Character.digit(this.ch, 16);
                    while (this.bp < n2 && n3 >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        ++this.col;
                        n3 = Character.digit(this.ch, 16);
                        n4 = (n4 << 4) + n3;
                    }
                    if (n3 >= 0) {
                        this.ch = (char)n4;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.lexError(Position.make(this.line, n), "illegal.unicode.esc");
            } else {
                --this.bp;
                this.ch = (char)92;
                --this.col;
            }
        }
    }

    private void scanChar() {
        ++this.bp;
        this.ch = this.buf[this.bp];
        ++this.col;
        if (this.ch == '\\') {
            this.convertUnicode();
        }
    }

    private void scanCommentChar() {
        ++this.bp;
        this.ch = this.buf[this.bp];
        ++this.col;
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\') {
                ++this.bp;
                ++this.col;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void expandCommentBuffer() {
        char[] cArray = new char[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
        this.buffer = cArray;
    }

    private void scanDocCommentChar() {
        ++this.bp;
        this.ch = this.buf[this.bp];
        ++this.col;
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\') {
                if (this.count == this.buffer.length) {
                    this.expandCommentBuffer();
                }
                this.buffer[this.count++] = this.ch;
                ++this.bp;
                ++this.col;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void putChar(char c) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = c;
    }

    private void dch() {
        System.err.print(this.ch);
        System.out.flush();
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                ++this.col;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char c = this.ch;
                        int n = Character.digit(this.ch, 8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            n = n * 8 + Character.digit(this.ch, 8);
                            this.scanChar();
                            if (c <= '3' && '0' <= this.ch && this.ch <= '7') {
                                n = n * 8 + Character.digit(this.ch, 8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)n);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError(Position.make(this.line, this.col), "illegal.esc.char");
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }

    private void scanFraction() {
        while (Character.digit(this.ch, 10) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        int n = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                return;
            }
            this.lexError("malformed.fp.lit");
            this.sp = n;
        }
    }

    private void scanFractionAndSuffix() {
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.scanChar();
            this.token = 54;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.scanChar();
            }
            this.token = 55;
        }
    }

    private void scanNumber(int n) {
        this.radix = n;
        while (Character.digit(this.ch, n == 8 ? 10 : n) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        if (n <= 10 && this.ch == '.') {
            this.putChar(this.ch);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (n <= 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = 53;
        } else {
            this.token = 52;
        }
    }

    private void scanIdent() {
        int n = this.bp;
        block3: while (true) {
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
            } else {
                this.sbuf[this.sp++] = this.ch;
            }
            ++this.bp;
            this.ch = this.buf[this.bp];
            ++this.col;
            if (this.ch == '\\') {
                this.convertUnicode();
            }
            switch (this.ch) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
            }
            if (this.ch <= '\u0080' || !Character.isJavaIdentifierPart(this.ch)) break;
        }
        this.name = Name.fromChars(StaticName.table, this.sbuf, 0, this.sp);
        this.token = this.name.index <= maxKey ? key[this.name.index] : 2;
    }

    private boolean isSpecial(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.ch);
            Name name = StaticName.fromChars(this.sbuf, 0, this.sp);
            if (name.index > maxKey || key[name.index] == 2) {
                --this.sp;
                break;
            }
            this.name = name;
            this.token = key[name.index];
            this.scanChar();
        } while (this.isSpecial(this.ch));
    }

    private void scanDocCommentTag() {
        int n = this.bp + 1;
        do {
            this.scanDocCommentChar();
        } while ('a' <= this.ch && this.ch <= 'z');
        if (StaticName.fromChars(this.buf, n, this.bp - n) == Names.deprecated) {
            this.deprecatedFlag = true;
        }
    }

    private void skipComment() {
        block8: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\u001a': {
                    this.lexError(this.pos, "unclosed.comment");
                    return;
                }
                case '*': {
                    this.scanChar();
                    if (this.ch != '/') continue block8;
                    return;
                }
                case '\t': {
                    this.col = (this.col - 1) / this.tabWidth * this.tabWidth + this.tabWidth;
                    this.scanCommentChar();
                    break;
                }
                case '\f': {
                    this.col = 0;
                    this.scanCommentChar();
                    break;
                }
                case '\r': {
                    if (this.unicodeConversionBp != this.bp) {
                        ++this.line;
                        this.col = 0;
                    }
                    this.scanCommentChar();
                    if (this.ch != '\n') continue block8;
                    if (this.unicodeConversionBp != this.bp) {
                        this.col = 0;
                    }
                    this.scanCommentChar();
                    break;
                }
                case '\n': {
                    if (this.unicodeConversionBp != this.bp) {
                        ++this.line;
                        this.col = 0;
                    }
                    this.scanCommentChar();
                    break;
                }
                default: {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                    ++this.col;
                    if (this.ch != '\\') continue block8;
                    if (this.buf[this.bp + 1] == '\\') {
                        ++this.bp;
                        ++this.col;
                        break;
                    }
                    this.convertUnicode();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String scanDocComment() {
        block48: {
            if (this.buffer == null) {
                this.buffer = new char[1024];
            }
            this.count = 0;
            var1_1 = false;
            var2_2 = true;
            while (this.bp < this.buflen && this.ch == '*') {
                this.scanDocCommentChar();
            }
            if (this.bp < this.buflen && this.ch == '/') {
                return "";
            }
            if (this.bp >= this.buflen) ** GOTO lbl126
            if (this.ch != '\n') break block48;
            if (this.unicodeConversionBp != this.bp) {
                ++this.line;
                this.col = 0;
            }
            this.scanDocCommentChar();
            var2_2 = false;
            ** GOTO lbl126
        }
        if (this.ch != '\r') ** GOTO lbl126
        if (this.unicodeConversionBp != this.bp) {
            ++this.line;
            this.col = 0;
        }
        this.scanDocCommentChar();
        if (this.ch != '\n') ** GOTO lbl126
        if (this.unicodeConversionBp != this.bp) {
            this.col = 0;
        }
        this.scanDocCommentChar();
        var2_2 = false;
        ** GOTO lbl126
        {
            switch (this.ch) {
                case ' ': {
                    this.scanDocCommentChar();
                    break;
                }
                case '\t': {
                    this.col = (this.col - 1) / this.tabWidth * this.tabWidth + this.tabWidth;
                    this.scanDocCommentChar();
                    break;
                }
                case '\f': {
                    this.col = 0;
                    this.scanDocCommentChar();
                    break;
                }
                default: {
                    ** GOTO lbl47
                }
            }
            do {
                if (this.bp < this.buflen) continue block17;
lbl47:
                // 2 sources

                if (this.ch == '*') {
                    do {
                        this.scanDocCommentChar();
                    } while (this.ch == '*');
                    if (this.ch == '/') {
                        break block17;
                    }
                } else if (!var2_2) {
                    var3_3 = 0;
                    while (var3_3 < this.col) {
                        if (this.count == this.buffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.buffer[this.count++] = 32;
                        ++var3_3;
                    }
                }
                var1_1 = true;
                block21: while (this.bp < this.buflen) {
                    switch (this.ch) {
                        case '\u001a': {
                            this.lexError(this.pos, "unclosed.comment");
                            break block17;
                        }
                        case '*': {
                            var1_1 = false;
                            this.scanDocCommentChar();
                            if (this.ch == '/') break block17;
                            if (this.count == this.buffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.buffer[this.count++] = 42;
                            break;
                        }
                        case ' ': {
                            if (this.count == this.buffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.buffer[this.count++] = this.ch;
                            this.scanDocCommentChar();
                            break;
                        }
                        case '\f': {
                            this.col = 0;
                            this.scanDocCommentChar();
                            break block21;
                        }
                        case '\r': {
                            if (this.unicodeConversionBp != this.bp) {
                                ++this.line;
                                this.col = 0;
                            }
                            this.scanDocCommentChar();
                            if (this.ch != '\n') {
                                if (this.count == this.buffer.length) {
                                    this.expandCommentBuffer();
                                }
                                this.buffer[this.count++] = 10;
                                break;
                            }
                            if (this.unicodeConversionBp != this.bp) {
                                --this.line;
                            }
                        }
                        case '\n': {
                            if (this.unicodeConversionBp != this.bp) {
                                ++this.line;
                                this.col = 0;
                            }
                            if (this.count == this.buffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.buffer[this.count++] = this.ch;
                            this.scanDocCommentChar();
                            break block21;
                        }
                        default: {
                            if (this.ch == '@' && var1_1) {
                                var3_3 = this.bp + 1;
                                do {
                                    if (this.count == this.buffer.length) {
                                        this.expandCommentBuffer();
                                    }
                                    this.buffer[this.count++] = this.ch;
                                    this.scanDocCommentChar();
                                } while ('a' <= this.ch && this.ch <= 'z');
                                if (StaticName.fromChars(this.buf, var3_3, this.bp - var3_3) == Names.deprecated) {
                                    this.deprecatedFlag = true;
                                }
                            } else {
                                if (this.count == this.buffer.length) {
                                    this.expandCommentBuffer();
                                }
                                this.buffer[this.count++] = this.ch;
                                this.scanDocCommentChar();
                            }
                            var1_1 = false;
                        }
                    }
                }
                var2_2 = false;
lbl126:
                // 6 sources

            } while (this.bp < this.buflen);
        }
        if (this.count > 0) {
            var3_3 = this.count - 1;
            block23: while (var3_3 > -1) {
                switch (this.buffer[var3_3]) {
                    case '*': {
                        --var3_3;
                        break;
                    }
                    default: {
                        break block23;
                    }
                }
            }
            this.count = var3_3 + 1;
            return new String(this.buffer, 0, this.count);
        }
        return "";
    }

    public String stringVal() {
        return new String(this.sbuf, 0, this.sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nextToken() {
        block66: {
            block65: {
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        block58: {
                                            block57: {
                                                block56: {
                                                    block55: {
                                                        block54: {
                                                            block53: {
                                                                block52: {
                                                                    block51: {
                                                                        try {
                                                                            this.prevEndPos = this.endPos;
                                                                            this.sp = 0;
                                                                            this.docComment = null;
                                                                            block24: while (true) {
                                                                                this.pos = (this.line << 10) + this.col;
                                                                                int n = this.bp++;
                                                                                switch (this.ch) {
                                                                                    case ' ': {
                                                                                        this.ch = this.buf[this.bp];
                                                                                        ++this.col;
                                                                                        if (this.ch != '\\') continue block24;
                                                                                        this.convertUnicode();
                                                                                        continue block24;
                                                                                    }
                                                                                    case '\t': {
                                                                                        this.col = (this.col - 1) / this.tabWidth * this.tabWidth + this.tabWidth;
                                                                                        this.scanChar();
                                                                                        continue block24;
                                                                                    }
                                                                                    case '\f': {
                                                                                        this.col = 0;
                                                                                        this.scanChar();
                                                                                        continue block24;
                                                                                    }
                                                                                    case '\r': {
                                                                                        if (this.unicodeConversionBp != this.bp) {
                                                                                            ++this.line;
                                                                                            this.col = 0;
                                                                                        }
                                                                                        this.scanChar();
                                                                                        if (this.ch != '\n') continue block24;
                                                                                        if (this.unicodeConversionBp != this.bp) {
                                                                                            this.col = 0;
                                                                                        }
                                                                                        this.scanChar();
                                                                                        continue block24;
                                                                                    }
                                                                                    case '\n': {
                                                                                        if (this.unicodeConversionBp != this.bp) {
                                                                                            ++this.line;
                                                                                            this.col = 0;
                                                                                        }
                                                                                        this.scanChar();
                                                                                        continue block24;
                                                                                    }
                                                                                    case '$': 
                                                                                    case 'A': 
                                                                                    case 'B': 
                                                                                    case 'C': 
                                                                                    case 'D': 
                                                                                    case 'E': 
                                                                                    case 'F': 
                                                                                    case 'G': 
                                                                                    case 'H': 
                                                                                    case 'I': 
                                                                                    case 'J': 
                                                                                    case 'K': 
                                                                                    case 'L': 
                                                                                    case 'M': 
                                                                                    case 'N': 
                                                                                    case 'O': 
                                                                                    case 'P': 
                                                                                    case 'Q': 
                                                                                    case 'R': 
                                                                                    case 'S': 
                                                                                    case 'T': 
                                                                                    case 'U': 
                                                                                    case 'V': 
                                                                                    case 'W': 
                                                                                    case 'X': 
                                                                                    case 'Y': 
                                                                                    case 'Z': 
                                                                                    case '_': 
                                                                                    case 'a': 
                                                                                    case 'b': 
                                                                                    case 'c': 
                                                                                    case 'd': 
                                                                                    case 'e': 
                                                                                    case 'f': 
                                                                                    case 'g': 
                                                                                    case 'h': 
                                                                                    case 'i': 
                                                                                    case 'j': 
                                                                                    case 'k': 
                                                                                    case 'l': 
                                                                                    case 'm': 
                                                                                    case 'n': 
                                                                                    case 'o': 
                                                                                    case 'p': 
                                                                                    case 'q': 
                                                                                    case 'r': 
                                                                                    case 's': 
                                                                                    case 't': 
                                                                                    case 'u': 
                                                                                    case 'v': 
                                                                                    case 'w': 
                                                                                    case 'x': 
                                                                                    case 'y': 
                                                                                    case 'z': {
                                                                                        this.scanIdent();
                                                                                        Object var3_2 = null;
                                                                                        this.endPos = (this.line << 10) + this.col - 1;
                                                                                        return;
                                                                                    }
                                                                                    case '0': {
                                                                                        this.scanChar();
                                                                                        if (this.ch == 'x' || this.ch == 'X') {
                                                                                            this.scanChar();
                                                                                            if (Character.digit(this.ch, 16) < 0) {
                                                                                                this.lexError("invalid.hex.number");
                                                                                            }
                                                                                            this.scanNumber(16);
                                                                                            break block51;
                                                                                        } else {
                                                                                            this.putChar('0');
                                                                                            this.scanNumber(8);
                                                                                        }
                                                                                        break block51;
                                                                                    }
                                                                                    case '1': 
                                                                                    case '2': 
                                                                                    case '3': 
                                                                                    case '4': 
                                                                                    case '5': 
                                                                                    case '6': 
                                                                                    case '7': 
                                                                                    case '8': 
                                                                                    case '9': {
                                                                                        this.scanNumber(10);
                                                                                        break block52;
                                                                                    }
                                                                                    case '.': {
                                                                                        this.scanChar();
                                                                                        if ('0' <= this.ch && this.ch <= '9') {
                                                                                            this.putChar('.');
                                                                                            this.scanFractionAndSuffix();
                                                                                            break block53;
                                                                                        } else {
                                                                                            this.token = 69;
                                                                                        }
                                                                                        break block53;
                                                                                    }
                                                                                    case ',': {
                                                                                        this.scanChar();
                                                                                        this.token = 68;
                                                                                        break block54;
                                                                                    }
                                                                                    case ';': {
                                                                                        this.scanChar();
                                                                                        this.token = 67;
                                                                                        break block55;
                                                                                    }
                                                                                    case '(': {
                                                                                        this.scanChar();
                                                                                        this.token = 61;
                                                                                        break block56;
                                                                                    }
                                                                                    case ')': {
                                                                                        this.scanChar();
                                                                                        this.token = 62;
                                                                                        break block57;
                                                                                    }
                                                                                    case '[': {
                                                                                        this.scanChar();
                                                                                        this.token = 65;
                                                                                        break block58;
                                                                                    }
                                                                                    case ']': {
                                                                                        this.scanChar();
                                                                                        this.token = 66;
                                                                                        break block59;
                                                                                    }
                                                                                    case '{': {
                                                                                        this.scanChar();
                                                                                        this.token = 63;
                                                                                        break block60;
                                                                                    }
                                                                                    case '}': {
                                                                                        this.scanChar();
                                                                                        this.token = 64;
                                                                                        break block61;
                                                                                    }
                                                                                    case '/': {
                                                                                        this.scanChar();
                                                                                        if (this.ch == '/') {
                                                                                            do {
                                                                                                ++this.bp;
                                                                                                this.ch = this.buf[this.bp];
                                                                                                ++this.col;
                                                                                                if (this.ch != '\\') continue;
                                                                                                if (this.buf[this.bp + 1] == '\\') {
                                                                                                    ++this.bp;
                                                                                                    ++this.col;
                                                                                                    continue;
                                                                                                }
                                                                                                this.convertUnicode();
                                                                                            } while (this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen);
                                                                                            continue block24;
                                                                                        }
                                                                                        if (this.ch == '*') {
                                                                                            this.scanChar();
                                                                                            if (this.ch == '*') {
                                                                                                this.docComment = new JavaDocComment(this.scanDocComment(), this.pos, (this.line << 10) + this.col + 1);
                                                                                            } else {
                                                                                                this.skipComment();
                                                                                            }
                                                                                            if (this.ch == '/') {
                                                                                                this.scanChar();
                                                                                                continue block24;
                                                                                            }
                                                                                            this.lexError("unclosed.comment");
                                                                                            break block62;
                                                                                        }
                                                                                        if (this.ch == '=') {
                                                                                            this.name = Names.slashequals;
                                                                                            this.token = 99;
                                                                                            this.scanChar();
                                                                                            break block63;
                                                                                        } else {
                                                                                            this.name = Names.slash;
                                                                                            this.token = 88;
                                                                                        }
                                                                                        break block63;
                                                                                    }
                                                                                    case '\'': {
                                                                                        this.scanChar();
                                                                                        if (this.ch == '\'') {
                                                                                            this.lexError("empty.char.lit");
                                                                                            break block64;
                                                                                        }
                                                                                        if (this.ch == '\r' || this.ch == '\n') {
                                                                                            this.lexError(this.pos, "illegal.line.end.in.char.lit");
                                                                                        }
                                                                                        this.scanLitChar();
                                                                                        if (this.ch == '\'') {
                                                                                            this.scanChar();
                                                                                            this.token = 56;
                                                                                            break block64;
                                                                                        } else {
                                                                                            this.lexError(this.pos, "unclosed.char.lit");
                                                                                        }
                                                                                        break block64;
                                                                                    }
                                                                                    case '\"': {
                                                                                        this.scanChar();
                                                                                        while (true) {
                                                                                            if (this.ch == '\"' || this.ch == '\r' || this.ch == '\n' || this.bp >= this.buflen) {
                                                                                                if (this.ch != '\"') break;
                                                                                                this.token = 57;
                                                                                                this.scanChar();
                                                                                                break block65;
                                                                                            }
                                                                                            this.scanLitChar();
                                                                                        }
                                                                                        this.lexError(this.pos, "unclosed.str.lit");
                                                                                        break block65;
                                                                                    }
                                                                                    default: {
                                                                                        if (this.isSpecial(this.ch)) {
                                                                                            this.scanOperator();
                                                                                            break block24;
                                                                                        }
                                                                                        if (Character.isJavaIdentifierStart(this.ch)) {
                                                                                            this.scanIdent();
                                                                                            break block24;
                                                                                        }
                                                                                        if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
                                                                                            this.token = 0;
                                                                                            break block24;
                                                                                        }
                                                                                        this.lexError("illegal.char", String.valueOf((int)this.ch));
                                                                                        this.scanChar();
                                                                                        break block24;
                                                                                    }
                                                                                }
                                                                                break;
                                                                            }
                                                                            break block66;
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            Object var3_19 = null;
                                                                            this.endPos = (this.line << 10) + this.col - 1;
                                                                            throw throwable;
                                                                        }
                                                                    }
                                                                    Object var3_3 = null;
                                                                    this.endPos = (this.line << 10) + this.col - 1;
                                                                    return;
                                                                }
                                                                Object var3_4 = null;
                                                                this.endPos = (this.line << 10) + this.col - 1;
                                                                return;
                                                            }
                                                            Object var3_5 = null;
                                                            this.endPos = (this.line << 10) + this.col - 1;
                                                            return;
                                                        }
                                                        Object var3_6 = null;
                                                        this.endPos = (this.line << 10) + this.col - 1;
                                                        return;
                                                    }
                                                    Object var3_7 = null;
                                                    this.endPos = (this.line << 10) + this.col - 1;
                                                    return;
                                                }
                                                Object var3_8 = null;
                                                this.endPos = (this.line << 10) + this.col - 1;
                                                return;
                                            }
                                            Object var3_9 = null;
                                            this.endPos = (this.line << 10) + this.col - 1;
                                            return;
                                        }
                                        Object var3_10 = null;
                                        this.endPos = (this.line << 10) + this.col - 1;
                                        return;
                                    }
                                    Object var3_11 = null;
                                    this.endPos = (this.line << 10) + this.col - 1;
                                    return;
                                }
                                Object var3_12 = null;
                                this.endPos = (this.line << 10) + this.col - 1;
                                return;
                            }
                            Object var3_13 = null;
                            this.endPos = (this.line << 10) + this.col - 1;
                            return;
                        }
                        Object var3_14 = null;
                        this.endPos = (this.line << 10) + this.col - 1;
                        return;
                    }
                    Object var3_15 = null;
                    this.endPos = (this.line << 10) + this.col - 1;
                    return;
                }
                Object var3_16 = null;
                this.endPos = (this.line << 10) + this.col - 1;
                return;
            }
            Object var3_17 = null;
            this.endPos = (this.line << 10) + this.col - 1;
            return;
        }
        Object var3_18 = null;
        this.endPos = (this.line << 10) + this.col - 1;
    }

    public String token2string(int n) {
        switch (n) {
            case 2: {
                return Log.getLocalizedString("token.identifier");
            }
            case 56: {
                return Log.getLocalizedString("token.character");
            }
            case 57: {
                return Log.getLocalizedString("token.string");
            }
            case 52: {
                return Log.getLocalizedString("token.integer");
            }
            case 53: {
                return Log.getLocalizedString("token.long-integer");
            }
            case 54: {
                return Log.getLocalizedString("token.float");
            }
            case 55: {
                return Log.getLocalizedString("token.double");
            }
            case 69: {
                return "'.'";
            }
            case 68: {
                return "','";
            }
            case 67: {
                return "';'";
            }
            case 61: {
                return "'('";
            }
            case 62: {
                return "')'";
            }
            case 65: {
                return "'['";
            }
            case 66: {
                return "']'";
            }
            case 63: {
                return "'{'";
            }
            case 64: {
                return "'}'";
            }
            case 1: {
                return Log.getLocalizedString("token.bad-symbol");
            }
            case 0: {
                return Log.getLocalizedString("token.end-of-input");
            }
        }
        return tokenName[n].toJava();
    }

    private static void enterKeyword(String string, int n) {
        Name name;
        Scanner.tokenName[n] = name = StaticName.fromString(string);
        if (name.index > maxKey) {
            maxKey = name.index;
        }
    }

    static {
        maxKey = 0;
        tokenName = new Name[107];
        int n = 0;
        while (n < 107) {
            Scanner.tokenName[n] = null;
            ++n;
        }
        Scanner.enterKeyword("+", 85);
        Scanner.enterKeyword("-", 86);
        Scanner.enterKeyword("!", 73);
        Scanner.enterKeyword("%", 92);
        Scanner.enterKeyword("^", 91);
        Scanner.enterKeyword("&", 89);
        Scanner.enterKeyword("*", 87);
        Scanner.enterKeyword("|", 90);
        Scanner.enterKeyword("~", 74);
        Scanner.enterKeyword("/", 88);
        Scanner.enterKeyword(">", 71);
        Scanner.enterKeyword("<", 72);
        Scanner.enterKeyword("?", 75);
        Scanner.enterKeyword(":", 76);
        Scanner.enterKeyword("=", 70);
        Scanner.enterKeyword("++", 83);
        Scanner.enterKeyword("--", 84);
        Scanner.enterKeyword("==", 77);
        Scanner.enterKeyword("<=", 78);
        Scanner.enterKeyword(">=", 79);
        Scanner.enterKeyword("!=", 80);
        Scanner.enterKeyword("<<", 93);
        Scanner.enterKeyword(">>", 94);
        Scanner.enterKeyword(">>>", 95);
        Scanner.enterKeyword("+=", 96);
        Scanner.enterKeyword("-=", 97);
        Scanner.enterKeyword("*=", 98);
        Scanner.enterKeyword("/=", 99);
        Scanner.enterKeyword("&=", 100);
        Scanner.enterKeyword("|=", 101);
        Scanner.enterKeyword("^=", 102);
        Scanner.enterKeyword("%=", 103);
        Scanner.enterKeyword("<<=", 104);
        Scanner.enterKeyword(">>=", 105);
        Scanner.enterKeyword(">>>=", 106);
        Scanner.enterKeyword("||", 82);
        Scanner.enterKeyword("&&", 81);
        Scanner.enterKeyword("abstract", 3);
        Scanner.enterKeyword("assert", 4);
        Scanner.enterKeyword("boolean", 5);
        Scanner.enterKeyword("break", 6);
        Scanner.enterKeyword("byte", 7);
        Scanner.enterKeyword("case", 8);
        Scanner.enterKeyword("catch", 9);
        Scanner.enterKeyword("char", 10);
        Scanner.enterKeyword("class", 11);
        Scanner.enterKeyword("const", 12);
        Scanner.enterKeyword("continue", 13);
        Scanner.enterKeyword("default", 14);
        Scanner.enterKeyword("do", 15);
        Scanner.enterKeyword("double", 16);
        Scanner.enterKeyword("else", 17);
        Scanner.enterKeyword("extends", 18);
        Scanner.enterKeyword("final", 19);
        Scanner.enterKeyword("finally", 20);
        Scanner.enterKeyword("float", 21);
        Scanner.enterKeyword("for", 22);
        Scanner.enterKeyword("goto", 23);
        Scanner.enterKeyword("if", 24);
        Scanner.enterKeyword("implements", 25);
        Scanner.enterKeyword("import", 26);
        Scanner.enterKeyword("instanceof", 27);
        Scanner.enterKeyword("int", 28);
        Scanner.enterKeyword("interface", 29);
        Scanner.enterKeyword("long", 30);
        Scanner.enterKeyword("native", 31);
        Scanner.enterKeyword("new", 32);
        Scanner.enterKeyword("package", 33);
        Scanner.enterKeyword("private", 34);
        Scanner.enterKeyword("protected", 35);
        Scanner.enterKeyword("public", 36);
        Scanner.enterKeyword("return", 37);
        Scanner.enterKeyword("short", 38);
        Scanner.enterKeyword("static", 39);
        Scanner.enterKeyword("strictfp", 40);
        Scanner.enterKeyword("super", 41);
        Scanner.enterKeyword("switch", 42);
        Scanner.enterKeyword("synchronized", 43);
        Scanner.enterKeyword("this", 44);
        Scanner.enterKeyword("throw", 45);
        Scanner.enterKeyword("throws", 46);
        Scanner.enterKeyword("transient", 47);
        Scanner.enterKeyword("try", 48);
        Scanner.enterKeyword("void", 49);
        Scanner.enterKeyword("volatile", 50);
        Scanner.enterKeyword("while", 51);
        Scanner.enterKeyword("true", 58);
        Scanner.enterKeyword("false", 59);
        Scanner.enterKeyword("null", 60);
        key = new byte[maxKey + 1];
        int n2 = 0;
        while (n2 <= maxKey) {
            Scanner.key[n2] = 2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 107) {
            if (tokenName[n3] != null) {
                Scanner.key[Scanner.tokenName[n3].index] = n3;
            }
            n3 = (byte)(n3 + 1);
        }
    }
}

