/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.java.CleanCompilerGroup;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ProgressEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.MultiDataObject;

final class CleanCompiler
extends Compiler {
    JavaDataObject jdo;
    CleanCompilerGroup group;
    FileSystem target;
    static /* synthetic */ Class class$org$netbeans$modules$java$CleanCompilerGroup;

    public CleanCompiler(CompilerJob compilerJob, JavaDataObject javaDataObject, FileSystem fileSystem) {
        super(compilerJob);
        this.jdo = javaDataObject;
        this.target = fileSystem;
    }

    private boolean isCrossCompiling() {
        return this.target != null;
    }

    public boolean isUpToDate() {
        return this.jdo.files().size() == 1;
    }

    public FileSystem getFileSystem() {
        if (this.target != null) {
            return this.target;
        }
        try {
            return this.jdo.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    protected Collection getCleanables() {
        ArrayList<FileObject> arrayList = null;
        if (!this.isCrossCompiling() || this.target.isValid()) {
            Set set = this.jdo.secondaryEntries();
            Iterator iterator = set.iterator();
            arrayList = new ArrayList<FileObject>(set.size());
            while (iterator.hasNext()) {
                MultiDataObject.Entry entry = (MultiDataObject.Entry)iterator.next();
                FileObject fileObject = entry.getFile();
                if (!fileObject.getExt().equals("class")) continue;
                arrayList.add(fileObject);
            }
        }
        return arrayList == null || arrayList.size() == 0 ? Collections.EMPTY_LIST : arrayList;
    }

    private void reportError(FileObject fileObject, IOException iOException) {
        String string = MessageFormat.format(JavaCompilerType.getString("MSG_CannotClean"), fileObject, iOException.getLocalizedMessage());
        ErrorEvent errorEvent = new ErrorEvent((CompilerGroup)this.group, this.jdo.getPrimaryFile(), 0, 0, string, "");
        this.group.ireErrorEvent(errorEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteClasses(JavaDataObject javaDataObject) throws IOException {
        Collection collection = this.getCleanables();
        Iterator iterator = collection.iterator();
        FileSystem fileSystem = this.jdo.getPrimaryFile().getFileSystem();
        boolean bl = true;
        block8: while (iterator.hasNext()) {
            Object var10_11;
            FileLock fileLock;
            FileObject fileObject = (FileObject)iterator.next();
            try {
                fileLock = fileObject.lock();
            }
            catch (IOException iOException) {
                bl = false;
                this.reportError(fileObject, iOException);
                continue;
            }
            this.group.ireProgressEvent(new ProgressEvent((CompilerGroup)this.group, fileObject, 4));
            try {
                fileObject.delete(fileLock);
                var10_11 = null;
            }
            catch (Throwable throwable) {
                var10_11 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            FileObject fileObject2 = fileObject.getParent();
            if (this.target == fileSystem || fileObject2.getFileSystem() != this.target) continue;
            while (true) {
                block12: {
                    Object var12_13;
                    if (fileObject2.isRoot() || fileObject2.getChildren().length != 0) continue block8;
                    fileLock = null;
                    try {
                        try {
                            fileLock = fileObject2.lock();
                            fileObject2.delete(fileLock);
                        }
                        catch (IOException iOException) {
                            var12_13 = null;
                            if (fileLock == null) continue block8;
                            fileLock.releaseLock();
                            continue block8;
                        }
                        var12_13 = null;
                        if (fileLock == null) break block12;
                    }
                    catch (Throwable throwable) {
                        var12_13 = null;
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                        throw throwable;
                    }
                    fileLock.releaseLock();
                }
                fileObject2 = fileObject2.getParent();
            }
            break;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CleanCompiler)) {
            return false;
        }
        return this.jdo == ((CleanCompiler)((Object)object)).jdo;
    }

    public int hashCode() {
        return this.jdo == null ? 0 : ((Object)((Object)this.jdo)).hashCode();
    }

    boolean compile() {
        try {
            return this.deleteClasses(this.jdo);
        }
        catch (IOException iOException) {
            this.group.printThrowable(iOException);
            return false;
        }
    }

    public final boolean getClearEnv() {
        return false;
    }

    public Class compilerGroupClass() {
        return class$org$netbeans$modules$java$CleanCompilerGroup == null ? (class$org$netbeans$modules$java$CleanCompilerGroup = CleanCompiler.class$("org.netbeans.modules.java.CleanCompilerGroup")) : class$org$netbeans$modules$java$CleanCompilerGroup;
    }

    public Object compilerGroupKey() {
        ArrayList<Object> arrayList;
        block2: {
            arrayList = new ArrayList<Object>(2);
            try {
                arrayList.add(super.compilerGroupKey());
                arrayList.add(this.jdo.getPrimaryFile().getFileSystem());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                fileStateInvalidException.printStackTrace();
            }
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

