/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Format;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.text.FilterDocument;
import org.openide.text.IndentEngine;

public abstract class IndentFileEntry
extends FileEntry.Format {
    private static final String NEWLINE = "\n";
    private static final String EA_PREFORMATTED = "org-netbeans-modules-java-preformattedSource";
    private ThreadLocal indentEngine;

    IndentFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        super(multiDataObject, fileObject);
    }

    private EditorKit createEditorKit(String string) {
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = new DefaultEditorKit();
        }
        return editorKit;
    }

    final void setIndentEngine(IndentEngine indentEngine) {
        IndentFileEntry indentFileEntry = this;
        synchronized (indentFileEntry) {
            if (this.indentEngine == null) {
                this.indentEngine = new ThreadLocal();
            }
        }
        this.indentEngine.set(indentEngine);
    }

    final void initializeIndentEngine() {
        StyledDocument styledDocument = this.createDocument(this.createEditorKit(this.getFile().getMIMEType()));
        IndentEngine indentEngine = IndentEngine.find((Document)styledDocument);
        this.setIndentEngine(indentEngine);
    }

    private StyledDocument createDocument(EditorKit editorKit) {
        Document document = editorKit.createDefaultDocument();
        if (document instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        String string2 = this.getFile().getExt();
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
        }
        FileObject fileObject2 = fileObject.createData(string, string2);
        Format format = this.createFormat(fileObject, string, string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
        StyledDocument styledDocument = this.createDocument(this.createEditorKit(fileObject2.getMIMEType()));
        IndentEngine indentEngine = (IndentEngine)this.indentEngine.get();
        if (indentEngine == null) {
            indentEngine = IndentEngine.find((Document)styledDocument);
        }
        Object object = this.getFile().getAttribute(EA_PREFORMATTED);
        boolean bl = false;
        if (object != null && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        try {
            FileLock fileLock = fileObject2.lock();
            try {
                block16: {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject2.getOutputStream(fileLock));
                    try {
                        try {
                            String string4 = null;
                            int n = 0;
                            while (true) {
                                String string3;
                                if ((string3 = bufferedReader.readLine()) == null) {
                                    styledDocument.insertString(styledDocument.getLength(), NEWLINE, null);
                                    outputStreamWriter.write(styledDocument.getText(0, styledDocument.getLength()));
                                    break;
                                }
                                if (string4 != null) {
                                    styledDocument.insertString(n, NEWLINE, null);
                                    ++n;
                                }
                                string4 = format.format(string3);
                                if (!bl || !string4.equals(string3)) {
                                    string4 = IndentFileEntry.safeIndent(indentEngine, string4, styledDocument, n);
                                }
                                styledDocument.insertString(n, string4, null);
                                n += string4.length();
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Object var17_18 = null;
                            outputStreamWriter.close();
                            break block16;
                        }
                        Object var17_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        outputStreamWriter.close();
                        throw throwable;
                    }
                    outputStreamWriter.close();
                }
                Object var19_21 = null;
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
        fileObject2.setAttribute("template", null);
        return fileObject2;
    }

    public static String safeIndent(IndentEngine indentEngine, String string, StyledDocument styledDocument, int n) {
        if (indentEngine == null) {
            return string;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Writer writer = indentEngine.createWriter((Document)styledDocument, n, (Writer)stringWriter);
            writer.write(string);
            writer.close();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, 16, "Indentation engine error", Util.getString("EXMSG_IndentationEngineError"), (Throwable)exception, null);
            ErrorManager.getDefault().notify((Throwable)exception);
            return string;
        }
    }
}

