/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.environment;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.java.environment.LibraryArchive;
import org.netbeans.modules.java.environment.Utilities;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class LibraryProcessor
extends FilterNode
implements XMLDataObject.Processor,
InstanceCookie {
    static final String TAG_LIBRARY_OLD = "Library";
    static final String TAG_LIBRARY = "library";
    static final String TAG_ARCHIVE_OLD = "Archive";
    static final String TAG_ARCHIVE = "archive";
    static final String ATTR_NAME = "name";
    static final String ATTR_COMPILE = "compile";
    static final String ATTR_EXECUTE = "execute";
    static final String ATTR_DEBUG = "debug";
    static final String ATTR_DOCUMENT = "document";
    static final String VALUE_YES = "yes";
    private static final char FILE_SEPARATOR = File.separatorChar;
    protected XMLDataObject xmlDataObject;
    FileSystem libraryFileSystem;
    static /* synthetic */ Class class$org$netbeans$modules$java$environment$LibraryProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$java$environment$LibraryArchive;

    public LibraryProcessor() {
        super((Node)new AbstractNode(Children.LEAF), Children.LEAF);
        this.disableDelegation(48);
    }

    public String getShortDescription() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$java$environment$LibraryProcessor == null ? (class$org$netbeans$modules$java$environment$LibraryProcessor = LibraryProcessor.class$("org.netbeans.modules.java.environment.LibraryProcessor")) : class$org$netbeans$modules$java$environment$LibraryProcessor)).getString("HINT_javaClassLibrary");
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Image getIcon(int n) {
        return org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/java/resources/library.gif");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.java.Filesystem.libraryFS");
    }

    public void attachTo(XMLDataObject xMLDataObject) {
        this.xmlDataObject = xMLDataObject;
        this.changeOriginal((Node)new DataNode((DataObject)xMLDataObject, Children.LEAF), false);
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.libraryFileSystem != null) {
            return this.libraryFileSystem;
        }
        this.loadLibrary(this.xmlDataObject);
        return this.libraryFileSystem;
    }

    public Class instanceClass() {
        return class$org$netbeans$modules$java$environment$LibraryArchive == null ? (class$org$netbeans$modules$java$environment$LibraryArchive = LibraryProcessor.class$("org.netbeans.modules.java.environment.LibraryArchive")) : class$org$netbeans$modules$java$environment$LibraryArchive;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    static void throwNotFoundException(DataObject dataObject, String string) throws SAXException {
        ErrorManager errorManager = ErrorManager.getDefault();
        String string2 = MessageFormat.format(Utilities.getString("FMT_ResourceNotFound"), string, dataObject.getPrimaryFile().toString());
        throw (SAXException)errorManager.annotate((Throwable)new SAXException("Mount resource not found"), 256, null, string2, null, null);
    }

    private void loadLibrary(XMLDataObject xMLDataObject) throws IOException {
        HandlerBase handlerBase = new HandlerBase(){
            private boolean inLibrary = false;
            private boolean inArchive = false;
            private FileSystemCapability.Bean capBean = new FileSystemCapability.Bean();
            private File archiveRoot;
            private boolean capSpecified = false;

            public void startElement(String string, AttributeList attributeList) throws SAXException {
                if (LibraryProcessor.TAG_LIBRARY.equals(string) || LibraryProcessor.TAG_LIBRARY_OLD.equals(string)) {
                    this.inLibrary = true;
                } else if (this.inLibrary && (LibraryProcessor.TAG_ARCHIVE.equals(string) || LibraryProcessor.TAG_ARCHIVE_OLD.equals(string))) {
                    String string2 = attributeList.getValue(LibraryProcessor.ATTR_NAME);
                    if (string2 == null) {
                        return;
                    }
                    if (FILE_SEPARATOR != '/') {
                        string2.replace('/', FILE_SEPARATOR);
                    }
                    this.archiveRoot = Utilities.findInstalledFile(string2);
                    if (this.archiveRoot == null) {
                        LibraryProcessor.throwNotFoundException((DataObject)LibraryProcessor.this.xmlDataObject, string2);
                    }
                    String string3 = attributeList.getValue(LibraryProcessor.ATTR_COMPILE);
                    this.capBean.setCompile(LibraryProcessor.VALUE_YES.equals(string3));
                    this.capSpecified |= string3 != null;
                    string3 = attributeList.getValue(LibraryProcessor.ATTR_DEBUG);
                    this.capBean.setDebug(LibraryProcessor.VALUE_YES.equals(string3));
                    this.capSpecified |= string3 != null;
                    string3 = attributeList.getValue(LibraryProcessor.ATTR_EXECUTE);
                    this.capBean.setExecute(LibraryProcessor.VALUE_YES.equals(string3));
                    this.capSpecified |= string3 != null;
                    string3 = attributeList.getValue(LibraryProcessor.ATTR_DOCUMENT);
                    this.capBean.setDoc(LibraryProcessor.VALUE_YES.equals(string3));
                    this.capSpecified |= string3 != null;
                }
            }

            public void endElement(String string) throws SAXException {
                if (LibraryProcessor.TAG_LIBRARY.equals(string) || LibraryProcessor.TAG_LIBRARY_OLD.equals(string)) {
                    this.inLibrary = false;
                } else if (LibraryProcessor.TAG_ARCHIVE.equals(string) || LibraryProcessor.TAG_ARCHIVE_OLD.equals(string)) {
                    String string2 = LibraryProcessor.this.xmlDataObject.getPrimaryFile().getPackageNameExt('/', '.');
                    LibraryArchive libraryArchive = this.capSpecified ? new LibraryArchive(string2, (FileSystemCapability)this.capBean) : new LibraryArchive(string2);
                    try {
                        libraryArchive.setJarFile(this.archiveRoot);
                        libraryArchive.setHidden(true);
                        LibraryProcessor.this.libraryFileSystem = libraryArchive;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.inArchive = false;
                }
            }
        };
        Parser parser = XMLDataObject.createParser();
        parser.setDocumentHandler(handlerBase);
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        try {
            parser.parse(new InputSource(xMLDataObject.getPrimaryFile().getInputStream()));
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)sAXException);
            throw iOException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

