/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.java.imptool.AbstractProp;
import org.netbeans.modules.java.imptool.SourceImport;
import org.netbeans.modules.java.imptool.Util;
import org.openide.explorer.propertysheet.editors.ChoicePropertyEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.Identifier;

public class ImportLineNode
extends AbstractNode {
    private SourceImport sourceImp;
    private PropertyEditor choiceEditor1;
    private PropertyEditor choiceEditor2;
    private PropertyEditor choiceEditor3;

    public ImportLineNode(SourceImport sourceImport) {
        this(sourceImport, Children.LEAF);
    }

    public ImportLineNode(SourceImport sourceImport, Children children) {
        super(children);
        Identifier identifier = sourceImport.getIdentifier();
        String string = sourceImport.getName();
        this.sourceImp = sourceImport;
        this.setName(identifier.getFullName());
        if (sourceImport.isPackage()) {
            string = sourceImport.getPackage();
            this.setIconBase("org/netbeans/modules/java/resources/importPackage");
        } else {
            this.setIconBase("org/netbeans/modules/java/resources/importLine");
        }
        this.setDisplayName(string);
    }

    static ImportLineNode createPackageNode(Collection collection) {
        Iterator iterator = collection.iterator();
        Children.Array array = new Children.Array();
        int n = 0;
        SourceImport sourceImport = null;
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Node[] nodeArray = new Node[collection.size() - 1];
        while (iterator.hasNext()) {
            SourceImport sourceImport2 = (SourceImport)iterator.next();
            if (!sourceImport2.isPackage()) {
                nodeArray[n++] = new ImportLineNode(sourceImport2);
                continue;
            }
            sourceImport = sourceImport2;
        }
        if (nodeArray.length == 0) {
            array = Children.LEAF;
        } else {
            array.add(nodeArray);
        }
        return new ImportLineNode(sourceImport, (Children)array);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        if (this.sourceImp.isClass()) {
            if (this.sourceImp.isUsed()) {
                set.put((Node.Property)new NoActionProp());
            } else {
                set.put((Node.Property)new AddRemoveActionProp());
            }
        } else {
            set.put((Node.Property)new PackageActionProp(this.getChildren() == Children.LEAF));
        }
        return sheet;
    }

    class PackageActionProp
    extends AbstractProp {
        private boolean noSingleNameImport;

        PackageActionProp(boolean bl) {
            super("RESOLVE_ACTION", Integer.TYPE, true);
            this.noSingleNameImport = bl;
        }

        public Object getValue() {
            return new Integer(ImportLineNode.this.sourceImp.isUse() ? 1 : 0);
        }

        public void setValue(Object object) {
            ImportLineNode.this.sourceImp.setUse((Integer)object != 0);
            ImportLineNode.super.firePropertyChange("propertySets", null, null);
        }

        public PropertyEditor getPropertyEditor() {
            if (ImportLineNode.this.choiceEditor3 == null) {
                String[] stringArray = new String[]{this.noSingleNameImport ? Util.getString("PROP_RESOLVE_ACTION_REMOVE") : Util.getString("PROP_RESOLVE_ACTION_SINGLE"), Util.getString("PROP_RESOLVE_ACTION_PACKAGE")};
                ImportLineNode.this.choiceEditor3 = (PropertyEditor)new ChoicePropertyEditor(new int[]{0, 1}, stringArray);
            }
            return ImportLineNode.this.choiceEditor3;
        }
    }

    class NoActionProp
    extends AbstractProp {
        NoActionProp() {
            super("RESOLVE_ACTION", Integer.TYPE, false);
        }

        public Object getValue() {
            return new Integer(0);
        }

        public PropertyEditor getPropertyEditor() {
            if (ImportLineNode.this.choiceEditor2 == null) {
                ImportLineNode.this.choiceEditor2 = (PropertyEditor)new ChoicePropertyEditor(new int[]{0}, new String[]{Util.getString("PROP_RESOLVE_ACTION_NOACTION")});
            }
            return ImportLineNode.this.choiceEditor2;
        }
    }

    class AddRemoveActionProp
    extends AbstractProp {
        AddRemoveActionProp() {
            super("RESOLVE_ACTION", Integer.TYPE, true);
        }

        public Object getValue() {
            return new Integer(ImportLineNode.this.sourceImp.isUse() ? 1 : 0);
        }

        public void setValue(Object object) {
            ImportLineNode.this.sourceImp.setUse((Integer)object != 0);
            ImportLineNode.super.firePropertyChange("propertySets", null, null);
        }

        public PropertyEditor getPropertyEditor() {
            if (ImportLineNode.this.choiceEditor1 == null) {
                ImportLineNode.this.choiceEditor1 = (PropertyEditor)new ChoicePropertyEditor(new int[]{0, 1}, new String[]{Util.getString("PROP_RESOLVE_ACTION_REMOVE"), Util.getString("PROP_RESOLVE_ACTION_USE")});
            }
            return ImportLineNode.this.choiceEditor1;
        }
    }
}

