/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.java.model.ElementImpl;
import org.openide.src.Element;

class EventQueue {
    Collection eventQueue;
    Map sourceMap;
    Map changedElements;
    Set newElements;
    Set removedElements;
    EventQueue parent;
    private boolean firingEvents;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$ElementImpl;

    public EventQueue(EventQueue eventQueue) {
        this.parent = eventQueue;
    }

    public void elementChanged(Element element, Element element2) {
        if (this.containsChanges(element)) {
            return;
        }
        if (this.changedElements == null) {
            this.changedElements = new HashMap(17);
        }
        this.changedElements.put(element, element2);
    }

    public void elementChanged(ElementImpl elementImpl) {
        Element element = elementImpl.getElement();
        if (this.containsChanges(element)) {
            return;
        }
        if (this.changedElements == null) {
            this.changedElements = new HashMap(17);
        }
        this.changedElements.put(element, elementImpl.cloneSelf());
    }

    public void elementCreated(Element element) {
        if (this.newElements == null) {
            this.newElements = new HashSet(17);
        }
        this.newElements.add(element);
    }

    public void elementRemoved(Element element) {
        if (this.newElements != null) {
            this.newElements.remove(element);
        }
        if (this.removedElements == null) {
            this.removedElements = new HashSet(17);
        }
        this.removedElements.add(element);
    }

    public boolean containsChanges(Element element) {
        if (this.newElements != null && this.newElements.contains(element)) {
            return true;
        }
        return this.changedElements != null && this.changedElements.containsKey(element);
    }

    public synchronized void addPropertyChange(ElementImpl elementImpl, PropertyChangeEvent propertyChangeEvent) {
        ElementImpl elementImpl2 = elementImpl;
        Collection collection = this.getQueue(elementImpl2);
        collection.add(propertyChangeEvent);
        if (this.eventQueue == null) {
            this.eventQueue = new LinkedList();
        }
        this.eventQueue.add(elementImpl);
        this.eventQueue.add(propertyChangeEvent);
    }

    public void fireEvents() {
        Object object;
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.firingEvents) {
                return;
            }
            this.firingEvents = true;
        }
        Collection collection = this.pollEventQueue();
        while (collection != null && !collection.isEmpty()) {
            object = collection.iterator();
            while (object.hasNext()) {
                ElementImpl elementImpl = (ElementImpl)object.next();
                PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)object.next();
                elementImpl.firePropertyChangeEvent(propertyChangeEvent);
            }
            collection = this.pollEventQueue();
        }
        object = this;
        synchronized (object) {
            this.firingEvents = false;
        }
    }

    private void fireElementEvents(ElementImpl elementImpl, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)iterator.next();
            elementImpl.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    private synchronized Map pollEvents() {
        Map map = this.sourceMap;
        this.sourceMap = null;
        return map;
    }

    private synchronized Collection pollEventQueue() {
        Collection collection = this.eventQueue;
        this.eventQueue = null;
        this.sourceMap = null;
        return collection;
    }

    private synchronized Collection getQueue(Object object) {
        LinkedList linkedList;
        if (this.sourceMap == null) {
            this.sourceMap = new HashMap(17);
            linkedList = null;
        } else {
            linkedList = (LinkedList)this.sourceMap.get(object);
        }
        if (linkedList != null) {
            return linkedList;
        }
        linkedList = new LinkedList();
        this.sourceMap.put(object, linkedList);
        return linkedList;
    }

    public void fixupChanges() {
        if (this.changedElements == null) {
            return;
        }
        Iterator iterator = this.changedElements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Element element = (Element)entry.getKey();
            Element element2 = (Element)entry.getValue();
            ElementImpl elementImpl = (ElementImpl)element.getCookie(class$org$netbeans$modules$java$model$ElementImpl == null ? EventQueue.class$("org.netbeans.modules.java.model.ElementImpl") : class$org$netbeans$modules$java$model$ElementImpl);
            Element element3 = elementImpl.cloneSelf();
            entry.setValue(new Object[]{element2, element3});
        }
    }

    private void mergeChild(EventQueue eventQueue) {
        if (eventQueue.removedElements != null) {
            if (this.newElements != null) {
                HashSet hashSet = new HashSet(eventQueue.removedElements);
                eventQueue.removedElements.removeAll(this.newElements);
                this.newElements.removeAll(hashSet);
            }
            if (this.removedElements == null) {
                this.removedElements = eventQueue.removedElements;
            } else {
                this.removedElements.addAll(eventQueue.removedElements);
            }
        }
        if (eventQueue.newElements != null) {
            if (this.newElements == null) {
                this.newElements = eventQueue.newElements;
            } else {
                this.newElements.addAll(eventQueue.newElements);
            }
        }
        if (eventQueue.changedElements != null) {
            if (this.newElements != null) {
                eventQueue.changedElements.keySet().removeAll(this.newElements);
            }
            if (this.changedElements != null) {
                eventQueue.changedElements.putAll(this.changedElements);
            }
            this.changedElements = eventQueue.changedElements;
        }
        if (eventQueue.sourceMap != null) {
            this.mergePropertyEventMaps(eventQueue.sourceMap);
        }
        if (eventQueue.eventQueue != null) {
            if (this.eventQueue == null) {
                this.eventQueue = eventQueue.eventQueue;
            } else {
                this.eventQueue.addAll(eventQueue.eventQueue);
            }
        }
    }

    private synchronized void mergePropertyEventMaps(Map map) {
        if (this.sourceMap == null) {
            this.sourceMap = map;
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Collection collection = (Collection)this.sourceMap.get(k);
            if (collection == null) {
                this.sourceMap.put(k, entry.getValue());
                continue;
            }
            collection.addAll((Collection)entry.getValue());
        }
    }

    public void mergeToParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.mergeChild(this);
    }

    public final Map getChangedElements() {
        return this.changedElements;
    }

    public final Set getCreatedElements() {
        return this.newElements;
    }

    public final Set getRemovedElements() {
        return this.removedElements;
    }

    public final EventQueue getParent() {
        return this.parent;
    }

    public void clearSummary() {
        this.removedElements = null;
        this.newElements = null;
        this.changedElements = null;
    }

    public boolean isEmpty() {
        if (this.newElements != null && !this.newElements.isEmpty()) {
            return false;
        }
        if (this.changedElements != null && !this.changedElements.isEmpty()) {
            return false;
        }
        return this.removedElements == null || this.removedElements.isEmpty();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

