/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class ParserAnnotation
extends Annotation
implements PropertyChangeListener {
    private final String error;
    private final int line;
    private final int column;
    private int state;
    private Line docline;
    private ParserAnnotation chained;
    private static final int STATE_NEW = 1;
    private static final int STATE_ATTACHED = 2;
    private static final int STATE_DETACHED = 3;

    ParserAnnotation(int n, int n2, String string) {
        this.line = n;
        this.column = n2;
        this.error = string;
        this.state = 1;
    }

    public String getAnnotationType() {
        return "org-netbeans-modules-java-parser_annotation";
    }

    public String getShortDescription() {
        if (this.chained != null) {
            return this.error + "\n\n" + this.chained.getShortDescription();
        }
        return this.error;
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }

    String getError() {
        return this.error;
    }

    void chain(ParserAnnotation parserAnnotation) {
        if (this.chained != null) {
            this.chained.chain(parserAnnotation);
        } else {
            this.chained = parserAnnotation;
        }
    }

    private int getState() {
        return this.state;
    }

    protected void notifyAttached(Annotatable annotatable) {
        super.notifyAttached(annotatable);
        this.docline.addPropertyChangeListener((PropertyChangeListener)this);
        this.state = 2;
    }

    protected void notifyDetached(Annotatable annotatable) {
        super.notifyDetached(annotatable);
        this.docline.removePropertyChangeListener((PropertyChangeListener)this);
        this.state = 3;
    }

    public boolean equals(Object object) {
        boolean bl = this.shallowEquals(object);
        if (!bl) {
            return false;
        }
        if (this.chained != null) {
            return this.chained.equals(((ParserAnnotation)object).chained);
        }
        return true;
    }

    private boolean shallowEquals(Object object) {
        if (object instanceof ParserAnnotation) {
            ParserAnnotation parserAnnotation = (ParserAnnotation)object;
            if (this == object) {
                return true;
            }
            if (this.line != parserAnnotation.getLine()) {
                return false;
            }
            if (this.column != parserAnnotation.getColumn()) {
                return false;
            }
            if (!this.error.equals(parserAnnotation.getError())) {
                return false;
            }
            return this.getState() != 3 && parserAnnotation.getState() != 3;
        }
        return false;
    }

    public void attachToLineSet(Line.Set set) {
        this.docline = set.getCurrent(this.line - 1);
        char[] cArray = this.docline.getText().toCharArray();
        int n = 0;
        int n2 = cArray.length - 1;
        while (n <= n2 && cArray[n] <= ' ') {
            ++n;
        }
        while (n <= n2 && cArray[n2] <= ' ') {
            --n2;
        }
        Line.Part part = n <= n2 ? this.docline.createPart(n, n2 - n + 1) : this.docline.createPart(0, cArray.length);
        this.attach((Annotatable)part);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null || string == "text") {
            this.detach();
        }
    }
}

