/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.awt.Component;
import java.lang.reflect.Modifier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.util.Utilities;

public class ElementRenderer
extends DefaultListCellRenderer {
    private static ImageIcon[] elementIcons = new ImageIcon[8];
    private static final int PUBLIC_OFFSET = 0;
    private static final int PROTECTED_OFFSET = 1;
    private static final int PRIVATE_OFFSET = 2;
    private static final int PACKAGE_OFFSET = 3;
    private static final int METHOD_BASE = 0;
    private static final int CLASS_BASE = 4;
    private ElementFormat elementFormat;

    public ElementRenderer() {
    }

    public ElementRenderer(ElementFormat elementFormat) {
        this();
        this.setFormat(elementFormat);
    }

    public void setFormat(ElementFormat elementFormat) {
        this.elementFormat = elementFormat;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (!(component instanceof JLabel)) {
            return component;
        }
        JLabel jLabel = (JLabel)component;
        jLabel.setIcon(this.getIcon(object));
        jLabel.setText(this.elementFormat.format((Element)((MethodElement)object)));
        return component;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Icon getIcon(Object object) {
        int n;
        if (!(object instanceof MemberElement)) throw new IllegalArgumentException(object.getClass().toString());
        int n2 = ((MemberElement)object).getModifiers();
        MemberElement memberElement = (MemberElement)object;
        if (memberElement instanceof ClassElement) {
            n = 4;
        } else {
            if (!(memberElement instanceof MethodElement)) throw new IllegalArgumentException(object.getClass().toString());
            n = 0;
        }
        int n3 = Modifier.isPublic(n2) ? 0 : (Modifier.isProtected(n2) ? 1 : (Modifier.isPrivate(n2) ? 2 : 3));
        return elementIcons[n + n3];
    }

    static {
        ElementRenderer.elementIcons[0] = new ImageIcon(Utilities.loadImage((String)"org/openide/resources/src/methodPublic.gif"));
        ElementRenderer.elementIcons[1] = new ImageIcon(Utilities.loadImage((String)"org/openide/resources/src/methodProtected.gif"));
        ElementRenderer.elementIcons[2] = new ImageIcon(Utilities.loadImage((String)"org/openide/resources/src/methodPrivate.gif"));
        ElementRenderer.elementIcons[3] = new ImageIcon(Utilities.loadImage((String)"org/openide/resources/src/methodPackage.gif"));
        ElementRenderer.elementIcons[4] = new ImageIcon(Utilities.loadImage((String)"org/openide/resources/src/class.gif"));
        ElementRenderer.elementIcons[5] = elementIcons[4];
        ElementRenderer.elementIcons[6] = elementIcons[4];
        ElementRenderer.elementIcons[7] = elementIcons[4];
    }
}

