/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.ClassCustomizer;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class ClassPanel
extends JPanel
implements JavaPanel {
    private JavaWizardData wizardData;
    private ClassCustomizer classCustomizer;
    private JLabel headLabel;

    public void initialize(JavaWizardData javaWizardData) {
        this.wizardData = javaWizardData;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.initComponents();
        this.classCustomizer = new ClassCustomizer(this.wizardData.getCustomizedClass());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.classCustomizer, gridBagConstraints);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_ClassPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ClassPanelA11yDesc"));
        this.headLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Basic_class_characteristicsA11yDesc"));
    }

    private void initComponents() {
        this.headLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_ImplementInterface"));
        this.headLabel.setText(JavaWizardIterator.getString("LBL_Basic_class_characteristics"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.headLabel, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        this.classCustomizer.setObject(this.wizardData.getCustomizedClass());
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.wizard.ClassProperties");
    }

    public void readSettings(Object object) {
        if (object instanceof TemplateWizard) {
            TemplateWizard templateWizard = (TemplateWizard)object;
            DataObject dataObject = null;
            DataFolder dataFolder = null;
            try {
                dataFolder = templateWizard.getTargetFolder();
                dataObject = templateWizard.getTemplate();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string = templateWizard.getTargetName();
            if (dataObject == null || dataFolder == null) {
                throw new IllegalStateException("Expected target folder & template, got null(s)");
            }
            String string2 = dataFolder.getPrimaryFile().getPackageNameExt('.', '.');
            if (!Util.isValidPackageName(string2)) {
                String string3 = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalFolderName"), dataFolder.getPrimaryFile().getPackageNameExt('/', '.'), string2);
                throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Illegal folder name"), 256, null, string3, null, null);
            }
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)dataObject.getName(), (String)"java");
            } else if (!Utilities.isJavaIdentifier((String)string)) {
                String string4 = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalTargetName"), string);
                throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Illegal target name"), 256, null, string4, null, null);
            }
            this.wizardData.setTemplate(dataObject);
            this.wizardData.setTarget(dataFolder.getPrimaryFile(), string);
            this.classCustomizer.setObject(this.wizardData.getCustomizedClass());
        }
    }

    public void storeSettings(Object object) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public Component getComponent() {
        return this;
    }
}

