/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.util.ArrayList;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class JavaWizardData {
    public static final String PROP_ORIGINAL_CLASS = "originalClass";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_CUSTOMIZED_CLASS = "customizedClass";
    public static final String PROP_OVERRIDEN_METHODS = "overridenMethods";
    private DataObject obj;
    private ClassElement originalClass;
    private ClassElement customizedClass;
    private InheritanceSupport InheritanceSupport;
    private transient ArrayList propertyChangeListenerList;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    void setTemplate(DataObject dataObject) {
        ClassElement[] classElementArray;
        SourceElement sourceElement;
        if (dataObject.equals(this.obj)) {
            return;
        }
        this.obj = dataObject;
        SourceCookie sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = JavaWizardData.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        ClassElement classElement = null;
        if (sourceCookie != null) {
            sourceElement = sourceCookie.getSource();
            sourceElement.prepare().waitFinished();
            classElementArray = sourceElement.getClasses();
            if (classElementArray != null && classElementArray.length > 0) {
                classElement = classElementArray[0];
            }
        }
        if (classElement == null) {
            classElement = new ClassElement();
        }
        sourceElement = this.originalClass;
        classElementArray = this.customizedClass;
        this.originalClass = classElement;
        this.cloneCustomizedClass();
    }

    private void cloneCustomizedClass() {
        this.customizedClass = new ClassElement();
        this.customizedClass = (ClassElement)this.originalClass.clone();
        this.InheritanceSupport = new InheritanceSupport(this.customizedClass);
    }

    void applyChanges(ClassElement classElement) throws SourceException {
        if (classElement == null || this.customizedClass == null) {
            return;
        }
        classElement.setSuperclass(this.customizedClass.getSuperclass());
        classElement.setInterfaces(this.customizedClass.getInterfaces());
        classElement.setModifiers(this.customizedClass.getModifiers());
        this.copyFields(classElement, this.customizedClass.getFields());
        this.copyConstructors(classElement, this.customizedClass.getConstructors());
        this.copyMethods(classElement, this.customizedClass.getMethods());
    }

    Type[] getParameterTypes(ConstructorElement constructorElement) {
        MethodParameter[] methodParameterArray = constructorElement.getParameters();
        Type[] typeArray = new Type[methodParameterArray.length];
        int n = 0;
        while (n < methodParameterArray.length) {
            typeArray[n] = methodParameterArray[n].getType();
            ++n;
        }
        return typeArray;
    }

    void copyConstructors(ClassElement classElement, ConstructorElement[] constructorElementArray) throws SourceException {
        int n = 0;
        while (n < constructorElementArray.length) {
            ConstructorElement constructorElement = constructorElementArray[n];
            if (classElement.getConstructor(this.getParameterTypes(constructorElement)) == null) {
                constructorElement.setBody("\n");
                classElement.addConstructor(constructorElement);
            }
            ++n;
        }
    }

    void copyMethods(ClassElement classElement, MethodElement[] methodElementArray) throws SourceException {
        int n = 0;
        while (n < methodElementArray.length) {
            MethodElement methodElement = methodElementArray[n];
            if (classElement.getMethod(methodElement.getName(), this.getParameterTypes((ConstructorElement)methodElement)) == null) {
                if ((methodElement.getModifiers() & 0x400) == 0 && methodElement.getBody() != null && methodElement.getBody().length() == 0) {
                    methodElement.setBody("\n");
                }
                classElement.addMethod(methodElement);
            }
            ++n;
        }
    }

    void copyFields(ClassElement classElement, FieldElement[] fieldElementArray) throws SourceException {
        int n = 0;
        while (n < fieldElementArray.length) {
            FieldElement fieldElement = fieldElementArray[n];
            if (classElement.getField(fieldElement.getName()) == null) {
                classElement.addField(fieldElement);
            }
            ++n;
        }
    }

    void setTarget(FileObject fileObject, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!fileObject.isRoot()) {
            stringBuffer.append(fileObject.getPackageName('.'));
            stringBuffer.append('.');
        }
        stringBuffer.append(string);
        try {
            this.customizedClass.setName(Identifier.create((String)stringBuffer.toString(), (String)string));
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    public InheritanceSupport getInheritance() {
        return this.InheritanceSupport;
    }

    public ClassElement getOriginalClass() {
        return this.originalClass;
    }

    public ClassElement getCustomizedClass() {
        return this.customizedClass;
    }

    void setCustomizedClass(ClassElement classElement) {
        this.customizedClass = classElement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

