/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;

class MemberListPanel
extends JPanel {
    private ElementCreator elementCreator;
    private ExplorerManager manager;
    private PropertyChangeListener managerListener;
    private Index indexableParent;
    private static final Node[] EMPTY_SELECTION = new Node[0];
    private ListView listView;
    protected JButton newButton;
    protected JButton duplicateButton;
    protected JButton downButton;
    protected JButton deleteButton;
    protected JButton upButton;
    static /* synthetic */ Class class$org$openide$src$MemberElement;
    static /* synthetic */ Class class$org$openide$nodes$Index;

    public MemberListPanel(ElementCreator elementCreator) {
        this.initComponents();
        this.initAccessibility();
        this.elementCreator = elementCreator;
        this.newButton.setMnemonic(JavaWizardIterator.getString("LBL_New_Mnemonic").charAt(0));
        this.duplicateButton.setMnemonic(JavaWizardIterator.getString("LBL_Duplicate_Mnemonic").charAt(0));
        this.deleteButton.setMnemonic(JavaWizardIterator.getString("LBL_Delete_Mnemonic").charAt(0));
        this.upButton.setMnemonic(JavaWizardIterator.getString("LBL_Up_Mnemonic").charAt(0));
        this.downButton.setMnemonic(JavaWizardIterator.getString("LBL_Down_Mnemonic").charAt(0));
        this.listView.setPopupAllowed(false);
    }

    private void initAccessibility() {
        this.listView.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_FieldListViewA11yName"));
    }

    public void requestFocus() {
        this.listView.requestFocus();
    }

    private void initComponents() {
        this.newButton = new JButton();
        this.duplicateButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.listView = new ListView();
        this.setLayout(new GridBagLayout());
        this.newButton.setToolTipText(JavaWizardIterator.getString("ACS_NewFieldA11yDesc"));
        this.newButton.setText(JavaWizardIterator.getString("LBL_New"));
        this.newButton.setMargin(new Insets(2, 8, 2, 8));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemberListPanel.this.newButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.newButton, gridBagConstraints);
        this.duplicateButton.setToolTipText(JavaWizardIterator.getString("ACS_DuplicateFieldA11yDesc"));
        this.duplicateButton.setText(JavaWizardIterator.getString("LBL_Duplicate"));
        this.duplicateButton.setMargin(new Insets(2, 8, 2, 8));
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemberListPanel.this.duplicateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.duplicateButton, gridBagConstraints);
        this.deleteButton.setToolTipText(JavaWizardIterator.getString("ACS_DeleteFieldA11yDesc"));
        this.deleteButton.setText(JavaWizardIterator.getString("LBL_Delete"));
        this.deleteButton.setMargin(new Insets(2, 8, 2, 8));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemberListPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.deleteButton, gridBagConstraints);
        this.upButton.setToolTipText(JavaWizardIterator.getString("ACS_UpFieldA11yDesc"));
        this.upButton.setText(JavaWizardIterator.getString("LBL_Up"));
        this.upButton.setMargin(new Insets(2, 8, 2, 8));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemberListPanel.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setToolTipText(JavaWizardIterator.getString("ACS_DownFieldA11yDesc"));
        this.downButton.setText(JavaWizardIterator.getString("LBL_Down"));
        this.downButton.setMargin(new Insets(2, 8, 2, 8));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemberListPanel.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.downButton, gridBagConstraints);
        this.listView.setToolTipText(JavaWizardIterator.getString("ACS_FieldListViewA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.listView, gridBagConstraints);
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        try {
            if (nodeArray.length > 0) {
                this.updateSelection(new Node[]{this.manager.getExploredContext().getChildren().findChild(this.elementCreator.duplicateElement((MemberElement)nodeArray[0].getCookie(class$org$openide$src$MemberElement == null ? (class$org$openide$src$MemberElement = MemberListPanel.class$("org.openide.src.MemberElement")) : class$org$openide$src$MemberElement)).getName().getSourceName())});
            }
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        try {
            int n = 0;
            while (n < nodeArray.length) {
                MemberElement memberElement = (MemberElement)nodeArray[n].getCookie(class$org$openide$src$MemberElement == null ? MemberListPanel.class$("org.openide.src.MemberElement") : class$org$openide$src$MemberElement);
                if (this.elementCreator.canDelete(memberElement)) {
                    this.elementCreator.deleteElement(memberElement);
                }
                ++n;
            }
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        this.updateSelection(EMPTY_SELECTION);
        this.updateButtons();
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        this.indexableParent.moveDown(this.indexableParent.indexOf(nodeArray[0]));
        this.updateSelection(EMPTY_SELECTION);
        this.updateSelection(new Node[]{nodeArray[0]});
        this.updateButtons();
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        this.indexableParent.moveUp(this.indexableParent.indexOf(nodeArray[0]));
        this.updateSelection(EMPTY_SELECTION);
        this.updateSelection(new Node[]{nodeArray[0]});
        this.updateButtons();
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.updateSelection(new Node[]{this.manager.getExploredContext().getChildren().findChild(this.elementCreator.createElement().getName().getSourceName())});
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.manager == null) {
            this.manager = ExplorerManager.find((Component)this);
        }
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){
                static /* synthetic */ Class class$org$openide$nodes$Index;

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                        MemberListPanel.this.updateButtons();
                    }
                    if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                        MemberListPanel.this.indexableParent = (Index)((Node)propertyChangeEvent.getNewValue()).getCookie(6.class$org$openide$nodes$Index == null ? (6.class$org$openide$nodes$Index = 6.class$("org.openide.nodes.Index")) : 6.class$org$openide$nodes$Index);
                        MemberListPanel.this.updateButtons();
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            };
        }
        this.manager.addPropertyChangeListener(this.managerListener);
        Node node = this.manager.getExploredContext();
        if (node != null) {
            this.indexableParent = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = MemberListPanel.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        }
        this.updateButtons();
    }

    public void removeNotify() {
        super.removeNotify();
        this.manager.removePropertyChangeListener(this.managerListener);
    }

    private void updateSelection(final Node[] nodeArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    MemberListPanel.this.manager.setSelectedNodes(nodeArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    private void updateButtons() {
        boolean bl;
        ExplorerManager explorerManager = this.manager;
        Node[] nodeArray = explorerManager.getSelectedNodes();
        boolean bl2 = bl = nodeArray.length == 1;
        if (this.indexableParent != null && bl) {
            this.upButton.setEnabled(!this.isFirst(nodeArray[0]));
            this.downButton.setEnabled(!this.isLast(nodeArray[0]));
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        boolean bl3 = false;
        int n = 0;
        while (n < nodeArray.length) {
            if (nodeArray[n].canDestroy() && this.elementCreator.canDelete((MemberElement)nodeArray[n].getCookie(class$org$openide$src$MemberElement == null ? MemberListPanel.class$("org.openide.src.MemberElement") : class$org$openide$src$MemberElement))) {
                bl3 = true;
                break;
            }
            ++n;
        }
        this.deleteButton.setEnabled(bl3);
        this.duplicateButton.setEnabled(bl);
    }

    protected boolean isFirst(Node node) {
        return this.indexableParent.indexOf(node) == 0;
    }

    protected boolean isLast(Node node) {
        return this.indexableParent.indexOf(node) == this.indexableParent.getNodesCount() - 1;
    }

    protected void removeNode(Node node) {
        try {
            node.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void createNewNode(Node node) {
        try {
            node.getNewTypes()[0].create();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface ElementCreator {
        public MemberElement createElement() throws SourceException;

        public MemberElement duplicateElement(MemberElement var1) throws SourceException;

        public void deleteElement(MemberElement var1) throws SourceException;

        public boolean canDelete(MemberElement var1);
    }
}

