/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.AccessLevelPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.MethodTypePanel;
import org.netbeans.modules.java.ui.wizard.ModifierEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class MethodCustomizer
extends JPanel
implements Runnable {
    private static final MethodElement EMPTY_ELEMENT = new MethodElement();
    private MethodElement method;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel exceptionsLabel;
    private JPanel leftPanel;
    private JLabel returnTypeLabel;
    private JLabel parametersLabel;
    private PropertyPanel modifPanel;
    private PropertyPanel paramPanel;
    private PropertyPanel typePanel;
    private PropertyPanel exceptPanel;

    public MethodCustomizer(MethodElement methodElement) {
        this.method = methodElement != null ? methodElement : EMPTY_ELEMENT;
        this.initComponents();
        this.nameField.setText(this.method.getName().toString());
        this.typePanel = new PropertyPanel((Object)this.method, "return", 4);
        this.returnTypeLabel.setLabelFor((Component)this.typePanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.weightx = 1.0;
        this.leftPanel.add((Component)this.typePanel, gridBagConstraints);
        this.paramPanel = new PropertyPanel((Object)this.method, "parameters", 4);
        this.parametersLabel.setLabelFor((Component)this.paramPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.weightx = 1.0;
        this.leftPanel.add((Component)this.paramPanel, gridBagConstraints);
        this.exceptPanel = new PropertyPanel((Object)this.method, "exceptions", 4);
        this.exceptionsLabel.setLabelFor((Component)this.exceptPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.leftPanel.add((Component)this.exceptPanel, gridBagConstraints);
        this.modifPanel = new PropertyPanel((PropertyModel)new TempPropertyModel(this.method, "modifiers"), 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.modifPanel, gridBagConstraints);
        this.nameLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Method_Name_Mnemonic").charAt(0));
        this.exceptionsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Exceptions_Mnemonic").charAt(0));
        this.parametersLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Parameters_Mnemonic").charAt(0));
        this.returnTypeLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Return_Type_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.nameLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_MethodNameA11yDesc"));
        this.nameField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_MethodNameTextFieldA11yName"));
        this.exceptionsLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Return_TypeA11yDesc"));
        this.parametersLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ParametersA11yDesc"));
        this.returnTypeLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ExceptionsA11yDesc"));
    }

    private void initComponents() {
        this.leftPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.returnTypeLabel = new JLabel();
        this.parametersLabel = new JLabel();
        this.exceptionsLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.leftPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText(JavaWizardIterator.getString("LBL_Name"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodCustomizer.this.nameFieldActionPerformed(actionEvent);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodCustomizer.this.nameFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.leftPanel.add((Component)this.nameField, gridBagConstraints);
        this.returnTypeLabel.setText(JavaWizardIterator.getString("LBL_Return_Type"));
        this.returnTypeLabel.setLabelFor((Component)this.typePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.returnTypeLabel, gridBagConstraints);
        this.parametersLabel.setText(JavaWizardIterator.getString("LBL_Parameters"));
        this.parametersLabel.setLabelFor((Component)this.paramPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.parametersLabel, gridBagConstraints);
        this.exceptionsLabel.setText(JavaWizardIterator.getString("LBL_Exceptions"));
        this.exceptionsLabel.setLabelFor((Component)this.exceptPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.exceptionsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.leftPanel, gridBagConstraints);
    }

    private void nameFieldActionPerformed(ActionEvent actionEvent) {
        this.changeName();
    }

    private void nameFieldFocusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.changeName();
        }
    }

    private void changeName() {
        if (this.method == EMPTY_ELEMENT) {
            return;
        }
        String string = this.nameField.getText();
        String string2 = this.method.getName().toString();
        Throwable throwable = null;
        boolean bl = false;
        if (Utilities.isJavaIdentifier((String)string)) {
            if (!string2.equals(string)) {
                Identifier identifier = Identifier.create((String)string);
                try {
                    this.method.setName(identifier);
                    bl = true;
                }
                catch (SourceException sourceException) {
                    throwable = sourceException;
                }
            }
        } else {
            throwable = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate(throwable, 256, null, JavaWizardIterator.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        if (throwable != null) {
            ErrorManager.getDefault().notify(throwable);
        }
        if (!bl) {
            this.nameField.setText(string2);
        }
    }

    public void setEnabled(boolean bl) {
        this.nameField.setEnabled(bl);
        this.modifPanel.setEnabled(bl);
        this.paramPanel.setEnabled(bl);
        this.typePanel.setEnabled(bl);
        this.exceptPanel.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setObject(MethodElement methodElement) {
        this.method = methodElement != null ? methodElement : EMPTY_ELEMENT;
        this.resetPanels();
        this.revalidate();
    }

    private void resetPanels() {
        this.nameField.setText(this.method.getName().toString());
        this.typePanel.setModel((PropertyModel)new DefaultPropertyModel((Object)this.method, "return"));
        this.paramPanel.setModel((PropertyModel)new DefaultPropertyModel((Object)this.method, "parameters"));
        this.paramPanel.setChangeImmediate(false);
        this.exceptPanel.setModel((PropertyModel)new DefaultPropertyModel((Object)this.method, "exceptions"));
        this.exceptPanel.setChangeImmediate(false);
        this.modifPanel.setModel((PropertyModel)new TempPropertyModel(this.method, "modifiers"));
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    void requestNameFocus() {
        int n = this.nameField.getText().length();
        this.nameField.setCaretPosition(0);
        this.nameField.moveCaretPosition(n);
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.nameField.requestFocus();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public Component getComponent() {
        return this;
    }

    public static class MethodModifierEditor
    extends ModifierEditor {
        public MethodModifierEditor() {
            super(new AccessLevelPanel(7, 0), new MethodTypePanel());
        }
    }

    static class TempPropertyModel
    extends DefaultPropertyModel {
        static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor;

        public TempPropertyModel(Object object, String string) throws IllegalArgumentException {
            super(object, string);
        }

        public Class getPropertyEditorClass() {
            return class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor = TempPropertyModel.class$("org.netbeans.modules.java.ui.wizard.MethodCustomizer$MethodModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

