/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.ModifierEditor;
import org.openide.util.NbBundle;

public class MethodTypePanel
extends JPanel
implements ModifierEditor.ModifierPanel {
    private JCheckBox synchronizedCheckBox;
    private JRadioButton regularRadioButton;
    private JCheckBox finalCheckBox;
    private JRadioButton abstractRadioButton;
    private JCheckBox staticCheckBox;
    private JCheckBox nativeCheckBox;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodTypePanel;

    public MethodTypePanel() {
        this.initComponents();
        this.setBorder(new TitledBorder(new EtchedBorder(), NbBundle.getBundle((Class)(class$org$netbeans$modules$java$ui$wizard$MethodTypePanel == null ? (class$org$netbeans$modules$java$ui$wizard$MethodTypePanel = MethodTypePanel.class$("org.netbeans.modules.java.ui.wizard.MethodTypePanel")) : class$org$netbeans$modules$java$ui$wizard$MethodTypePanel)).getString("LBL_MethodType")));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.regularRadioButton);
        buttonGroup.add(this.abstractRadioButton);
        this.regularRadioButton.setSelected(true);
        this.regularRadioButton.setMnemonic(JavaWizardIterator.getString("LBL_DefaultType_Mnemonic").charAt(0));
        this.abstractRadioButton.setMnemonic('a');
        this.finalCheckBox.setMnemonic('i');
        this.nativeCheckBox.setMnemonic('v');
        this.staticCheckBox.setMnemonic('t');
        this.synchronizedCheckBox.setMnemonic('z');
    }

    public void setTypeModifier(int n) {
        this.abstractRadioButton.setSelected(Modifier.isAbstract(n));
        this.regularRadioButton.setSelected(!Modifier.isAbstract(n));
        this.finalCheckBox.setSelected(Modifier.isFinal(n));
        this.nativeCheckBox.setSelected(Modifier.isNative(n));
        this.staticCheckBox.setSelected(Modifier.isStatic(n));
        this.synchronizedCheckBox.setSelected(Modifier.isSynchronized(n));
    }

    public int getTypeModifier() {
        if (this.abstractRadioButton.isSelected()) {
            return 1024;
        }
        int n = 0;
        if (this.finalCheckBox.isSelected()) {
            n |= 0x10;
        }
        if (this.nativeCheckBox.isSelected()) {
            n |= 0x100;
        }
        if (this.staticCheckBox.isSelected()) {
            n |= 8;
        }
        if (this.synchronizedCheckBox.isSelected()) {
            n |= 0x20;
        }
        return n;
    }

    public int getMask() {
        return 1336;
    }

    public Component getComponent() {
        return this;
    }

    private void initComponents() {
        this.regularRadioButton = new JRadioButton();
        this.finalCheckBox = new JCheckBox();
        this.nativeCheckBox = new JCheckBox();
        this.staticCheckBox = new JCheckBox();
        this.synchronizedCheckBox = new JCheckBox();
        this.abstractRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Method Type"));
        this.regularRadioButton.setToolTipText(JavaWizardIterator.getString("ACS_DefaultMethodTypeA11yDesc"));
        this.regularRadioButton.setText(JavaWizardIterator.getString("LBL_DefaultType"));
        this.regularRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MethodTypePanel.this.regularRadioButtonStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.regularRadioButton, gridBagConstraints);
        this.finalCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_FinalMethodModifierA11yDesc"));
        this.finalCheckBox.setText("final");
        this.finalCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodTypePanel.this.checkBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 6);
        this.add((Component)this.finalCheckBox, gridBagConstraints);
        this.nativeCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_NativeMethodModifierA11yDesc"));
        this.nativeCheckBox.setText("native");
        this.nativeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodTypePanel.this.checkBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 6);
        this.add((Component)this.nativeCheckBox, gridBagConstraints);
        this.staticCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_StaticMethodModifierA11yDesc"));
        this.staticCheckBox.setText("static");
        this.staticCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodTypePanel.this.checkBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.staticCheckBox, gridBagConstraints);
        this.synchronizedCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_SynchronizedMethodModifierA11yDesc"));
        this.synchronizedCheckBox.setText("synchronized");
        this.synchronizedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodTypePanel.this.checkBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.synchronizedCheckBox, gridBagConstraints);
        this.abstractRadioButton.setToolTipText(JavaWizardIterator.getString("ACS_AbstractMethodTypeA11yDesc"));
        this.abstractRadioButton.setText("abstract");
        this.abstractRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MethodTypePanel.this.abstractRadioButtonStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.abstractRadioButton, gridBagConstraints);
    }

    private void abstractRadioButtonStateChanged(ChangeEvent changeEvent) {
        if (this.abstractRadioButton.isEnabled()) {
            this.changeChecksEnabled(!this.abstractRadioButton.isSelected());
            this.firePropertyChange("typeModifier", null, null);
        }
    }

    private void regularRadioButtonStateChanged(ChangeEvent changeEvent) {
        this.changeChecksEnabled(this.regularRadioButton.isSelected());
        this.firePropertyChange("typeModifier", null, null);
    }

    private void checkBoxActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange("typeModifier", null, null);
    }

    private void changeChecksEnabled(boolean bl) {
        this.finalCheckBox.setEnabled(bl);
        this.staticCheckBox.setEnabled(bl);
        this.nativeCheckBox.setEnabled(bl);
        this.synchronizedCheckBox.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

