/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.manager;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import tyrex.connector.ConnectionManager;
import tyrex.connector.ManagedConnection;
import tyrex.util.FastThreadLocal;

public class ConnectionContext {
    private static final FastThreadLocal _local = new FastThreadLocal();
    private ContextEntry[] _entries;

    public void add(ConnectionManager connectionManager, ManagedConnection managedConnection) {
        if (this._entries != null) {
            ContextEntry contextEntry = null;
            int n = this._entries.length;
            while (--n >= 0) {
                contextEntry = this._entries[n];
                if (contextEntry == null || connectionManager != contextEntry.manager || managedConnection != contextEntry.managed) continue;
                return;
            }
        }
    }

    public static ConnectionContext createCurrent() {
        ConnectionContext connectionContext = new ConnectionContext();
        _local.set(connectionContext);
        return connectionContext;
    }

    public static ConnectionContext getCurrent() {
        ConnectionContext connectionContext = (ConnectionContext)_local.get();
        return connectionContext;
    }

    public Enumeration listConnections(ConnectionManager connectionManager) {
        return new ConnectionEnumeration(connectionManager, this._entries);
    }

    public void removeContextEntry(ConnectionManager connectionManager, ManagedConnection managedConnection) {
    }

    static class ContextEntry {
        final ConnectionManager manager;
        final ManagedConnection managed;

        ContextEntry(ConnectionManager connectionManager, ManagedConnection managedConnection) {
            this.manager = connectionManager;
            this.managed = managedConnection;
        }
    }

    static class ConnectionEnumeration
    implements Enumeration {
        private final ConnectionManager _manager;
        private final ContextEntry[] _entries;
        private int _index;

        ConnectionEnumeration(ConnectionManager connectionManager, ContextEntry[] contextEntryArray) {
            this._manager = connectionManager;
            if (contextEntryArray == null) {
                this._entries = new ContextEntry[0];
                this._index = 0;
            } else {
                this._entries = (ContextEntry[])contextEntryArray.clone();
                while (this._index < this._entries.length) {
                    if (this._entries[this._index].manager == this._manager) break;
                }
            }
        }

        public boolean hasMoreElements() {
            return this._index < this._entries.length;
        }

        public Object nextElement() {
            if (this._index == this._entries.length) {
                throw new NoSuchElementException();
            }
            ManagedConnection managedConnection = this._entries[this._index].managed;
            ++this._index;
            while (this._index < this._entries.length) {
                if (this._entries[this._index].manager == this._manager) break;
            }
            return managedConnection;
        }
    }
}

