/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.transaction;

import java.io.PrintWriter;
import tyrex.connector.ConnectionException;
import tyrex.connector.ManagedConnection;
import tyrex.connector.ManagedConnectionFactory;
import tyrex.connector.transaction.ConnectionTransactionManager;

public abstract class AbstractConnectionTransactionManager
implements ConnectionTransactionManager {
    private ConnectionTransactionManager.ConnectionTransactionListener[] listeners;
    private PrintWriter logWriter;

    public final synchronized void addListener(ConnectionTransactionManager.ConnectionTransactionListener connectionTransactionListener) {
        if (this.listeners == null) {
            this.listeners = new ConnectionTransactionManager.ConnectionTransactionListener[]{connectionTransactionListener};
        } else {
            ConnectionTransactionManager.ConnectionTransactionListener[] connectionTransactionListenerArray = new ConnectionTransactionManager.ConnectionTransactionListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, connectionTransactionListenerArray, 0, this.listeners.length);
            connectionTransactionListenerArray[this.listeners.length] = connectionTransactionListener;
            this.listeners = connectionTransactionListenerArray;
            connectionTransactionListenerArray = null;
        }
    }

    public abstract boolean canBeShared(ManagedConnection var1, ManagedConnectionFactory var2) throws ConnectionException;

    public abstract boolean delist(ManagedConnection var1, ManagedConnectionFactory var2) throws ConnectionException;

    public abstract void discard(ManagedConnection var1, ManagedConnectionFactory var2) throws ConnectionException;

    public abstract Object enlist(Object var1, ManagedConnection var2, ManagedConnectionFactory var3) throws ConnectionException;

    public final PrintWriter getLogWriter() {
        return this.logWriter;
    }

    protected final synchronized void informNotInLocalTransaction(ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory) {
        if (this.listeners != null) {
            int n = 0;
            while (n < this.listeners.length) {
                this.listeners[n].notInLocalTransaction(managedConnection, managedConnectionFactory);
                ++n;
            }
        }
    }

    public final synchronized void removeListener(ConnectionTransactionManager.ConnectionTransactionListener connectionTransactionListener) {
        if (this.listeners != null) {
            if (this.listeners.length == 1) {
                if (this.listeners[0] == connectionTransactionListener) {
                    this.listeners = null;
                }
            } else {
                int n = this.listeners.length;
                while (--n >= 0) {
                    if (this.listeners[n] != connectionTransactionListener) continue;
                    ConnectionTransactionManager.ConnectionTransactionListener[] connectionTransactionListenerArray = new ConnectionTransactionManager.ConnectionTransactionListener[this.listeners.length - 1];
                    this.listeners[n] = this.listeners[this.listeners.length - 1];
                    System.arraycopy(this.listeners, 0, connectionTransactionListenerArray, 0, this.listeners.length - 1);
                    this.listeners = connectionTransactionListenerArray;
                    connectionTransactionListenerArray = null;
                }
            }
        }
    }

    public final void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }
}

