/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class Logger
extends PrintWriter {
    public static final String Prefix = "Tyrex";
    public static final boolean LogTime = true;
    private static Logger _system = new Logger(System.out).setPrefix("Tyrex");
    private boolean _logTime = true;
    private String _prefix;
    private boolean _newLine;

    public Logger(OutputStream outputStream) {
        super(outputStream, true);
        this.setPrefix(Prefix);
        this._newLine = true;
    }

    public Logger(Writer writer) {
        super(writer, true);
        this.setPrefix(Prefix);
        this._newLine = true;
    }

    public static Logger getSystemLogger() {
        return _system;
    }

    protected final void prefixLine() {
        if (this._newLine) {
            if (this._logTime) {
                this.write(new Date().toString());
                this.write(32);
            }
            if (this._prefix != null) {
                this.write(this._prefix);
            }
        }
    }

    public void print(char c) {
        this.prefixLine();
        super.print(c);
        this._newLine = c == '\n';
    }

    public void print(double d) {
        this.prefixLine();
        super.print(d);
    }

    public void print(float f) {
        this.prefixLine();
        super.print(f);
    }

    public void print(int n) {
        this.prefixLine();
        super.print(n);
    }

    public void print(long l) {
        this.prefixLine();
        super.print(l);
    }

    public void print(Exception exception) {
        this.prefixLine();
        exception.printStackTrace(this);
    }

    public void print(Object object) {
        this.prefixLine();
        this.println(String.valueOf(object));
    }

    public void print(String string) {
        int n = 0;
        int n2 = 0;
        if (string != null) {
            n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '\n') {
                    this.prefixLine();
                    super.write(string, n2, n - n2);
                    super.println();
                    this._newLine = true;
                    n2 = n + 1;
                }
                ++n;
            }
        }
        if (n > n2) {
            this.prefixLine();
            super.write(string, n2, n - n2);
            this._newLine = false;
        }
    }

    public void print(boolean bl) {
        this.prefixLine();
        super.print(bl);
    }

    public void print(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\n') {
                this.prefixLine();
                super.write(cArray, n, n2 - n);
                super.println();
                this._newLine = true;
                n = n2 + 1;
            }
            ++n2;
        }
        if (n2 > n) {
            this.prefixLine();
            super.write(cArray, n, n2 - n);
            this._newLine = false;
        }
    }

    public void println() {
        super.println();
        this._newLine = true;
    }

    public void println(char c) {
        this.prefixLine();
        super.print(c);
        super.println();
        this._newLine = true;
    }

    public void println(double d) {
        this.prefixLine();
        super.print(d);
        super.println();
        this._newLine = true;
    }

    public void println(float f) {
        this.prefixLine();
        super.print(f);
        super.println();
        this._newLine = true;
    }

    public void println(int n) {
        this.prefixLine();
        super.print(n);
        super.println();
        this._newLine = true;
    }

    public void println(long l) {
        this.prefixLine();
        super.print(l);
        super.println();
        this._newLine = true;
    }

    public void println(Exception exception) {
        this.print(exception);
        this._newLine = true;
    }

    public void println(Object object) {
        this.println(String.valueOf(object));
    }

    public void println(String string) {
        this.print(string);
        super.println();
        this._newLine = true;
    }

    public void println(boolean bl) {
        this.prefixLine();
        super.print(bl);
        super.println();
        this._newLine = true;
    }

    public void println(char[] cArray) {
        this.print(cArray);
        super.println();
        this._newLine = true;
    }

    public Logger setLogTime(boolean bl) {
        this._logTime = bl;
        return this;
    }

    public Logger setPrefix(String string) {
        this._prefix = string != null && string.length() > 0 ? "[" + string + "] " : "";
        return this;
    }

    public static void setSystemLogger(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new NullPointerException("Argument 'system' is null");
        }
        _system = printWriter instanceof Logger ? (Logger)printWriter : new Logger(printWriter).setPrefix(Prefix);
    }

    public static void setSystemLogger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("Argument 'system' is null");
        }
        _system = logger;
    }
}

