/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractNumericValidator;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class DecimalDatatypeValidator
extends AbstractNumericValidator {
    protected int fTotalDigits;
    protected int fFractionDigits;

    public DecimalDatatypeValidator() {
        this(null, null, false, null);
    }

    public DecimalDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl, XMLErrorReporter xMLErrorReporter) {
        super(datatypeValidator, hashtable, bl, xMLErrorReporter);
    }

    public int compare(String string, String string2) {
        try {
            BigDecimal bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
            BigDecimal bigDecimal2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string2));
            return bigDecimal.compareTo(bigDecimal2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected void inheritAdditionalFacets() {
        if ((((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x200) != 0 && (this.fFacetsDefined & 0x200) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
            this.fTotalDigits = ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits;
        }
        if ((((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x400) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
            this.fFractionDigits = ((DecimalDatatypeValidator)this.fBaseValidator).fFractionDigits;
        }
    }

    protected void checkFacetConstraints() throws InvalidDatatypeFacetException {
        if ((this.fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x200) != 0 && this.fFractionDigits > this.fTotalDigits) {
            throw new InvalidDatatypeFacetException("fractionDigits value ='" + this.fFractionDigits + "'must be <= totalDigits value ='" + this.fTotalDigits + "'. ");
        }
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
        if ((this.fFacetsDefined & 0x200) != 0 && (((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x200) != 0) {
            if ((((DecimalDatatypeValidator)this.fBaseValidator).fFlags & 0x200) != 0 && this.fTotalDigits != ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits) {
                throw new InvalidDatatypeFacetException("totalDigits value = '" + this.fTotalDigits + "' must be equal to base.totalDigits value = '" + ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits + "' with attribute {fixed} = true");
            }
            if (this.fTotalDigits > ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits) {
                throw new InvalidDatatypeFacetException("totalDigits value ='" + this.fTotalDigits + "' must be <= base.totalDigits value ='" + ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits + "'.");
            }
        }
        if ((this.fFacetsDefined & 0x400) != 0 && (((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x400) != 0 && (((DecimalDatatypeValidator)this.fBaseValidator).fFlags & 0x400) != 0 && this.fFractionDigits != ((DecimalDatatypeValidator)this.fBaseValidator).fFractionDigits) {
            throw new InvalidDatatypeFacetException("fractionDigits value = '" + this.fFractionDigits + "' must be equal to base.fractionDigits value = '" + ((DecimalDatatypeValidator)this.fBaseValidator).fFractionDigits + "' with attribute {fixed} = true");
        }
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        String string2 = (String)hashtable.get(string);
        String string3 = "decimal datatype, facet " + string + " with value " + string2;
        if (string.equals(SchemaSymbols.ELT_TOTALDIGITS)) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
            try {
                this.fTotalDigits = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                throw new InvalidDatatypeFacetException(string3);
            }
            if (this.fTotalDigits <= 0) {
                throw new InvalidDatatypeFacetException("totalDigits value '" + this.fTotalDigits + "' must be a positiveInteger.");
            }
        } else if (string.equals(SchemaSymbols.ELT_FRACTIONDIGITS)) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
            try {
                this.fFractionDigits = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                throw new InvalidDatatypeFacetException(string3);
            }
            if (this.fFractionDigits < 0) {
                throw new InvalidDatatypeFacetException("fractionDigits value '" + this.fFractionDigits + "' must be a positiveInteger.");
            }
        } else {
            throw new InvalidDatatypeFacetException(string3);
        }
    }

    protected int compareValues(Object object, Object object2) {
        return ((BigDecimal)object).compareTo((BigDecimal)object2);
    }

    protected void setMaxInclusive(String string) {
        this.fMaxInclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
    }

    protected void setMinInclusive(String string) {
        this.fMinInclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
    }

    protected void setMaxExclusive(String string) {
        this.fMaxExclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
    }

    protected void setMinExclusive(String string) {
        this.fMinExclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
    }

    protected void setEnumeration(Vector vector) throws InvalidDatatypeValueException {
        if (vector != null) {
            this.fEnumeration = new BigDecimal[vector.size()];
            Object var2_2 = null;
            try {
                int n = 0;
                while (n < vector.size()) {
                    this.fEnumeration[n] = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent((String)vector.elementAt(n)));
                    ((DecimalDatatypeValidator)this.fBaseValidator).validate((String)vector.elementAt(n), null);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new InvalidDatatypeValueException(exception.getMessage());
            }
        }
    }

    protected String getMaxInclusive(boolean bl) {
        return bl ? ((DecimalDatatypeValidator)this.fBaseValidator).fMaxInclusive.toString() : ((BigDecimal)this.fMaxInclusive).toString();
    }

    protected String getMinInclusive(boolean bl) {
        return bl ? ((DecimalDatatypeValidator)this.fBaseValidator).fMinInclusive.toString() : ((BigDecimal)this.fMinInclusive).toString();
    }

    protected String getMaxExclusive(boolean bl) {
        return bl ? ((DecimalDatatypeValidator)this.fBaseValidator).fMaxExclusive.toString() : ((BigDecimal)this.fMaxExclusive).toString();
    }

    protected String getMinExclusive(boolean bl) {
        return bl ? ((DecimalDatatypeValidator)this.fBaseValidator).fMinExclusive.toString() : ((BigDecimal)this.fMinExclusive).toString();
    }

    protected void checkContent(String string, ValidationContext validationContext, Vector vector, boolean bl) throws InvalidDatatypeValueException {
        Object object;
        int n;
        if (this.fBaseValidator instanceof DecimalDatatypeValidator) {
            ((DecimalDatatypeValidator)this.fBaseValidator).checkContent(string, validationContext, vector, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "' does not match regular expression facet " + this.fRegex.getPattern());
        }
        if (bl) {
            return;
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(string));
        }
        catch (Exception exception) {
            String string2 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.NOT_DECIMAL], new Object[]{"'" + string + "'"});
            throw new InvalidDatatypeValueException(string2);
        }
        if (vector != null) {
            n = vector.size();
            object = new BigDecimal[n];
            int n2 = 0;
            try {
                while (n2 < n) {
                    object[n2] = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent((String)vector.elementAt(n2)));
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.INVALID_ENUM_VALUE], new Object[]{vector.elementAt(n2)});
                throw new InvalidDatatypeValueException(string3);
            }
            this.enumCheck(bigDecimal, (BigDecimal[])object);
        }
        if ((this.fFacetsDefined & 0x400) != 0 && bigDecimal.scale() > this.fFractionDigits) {
            String string4 = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.FRACTION_EXCEEDED], new Object[]{"'" + string + "'" + " with fractionDigits = '" + bigDecimal.scale() + "'", "'" + this.fFractionDigits + "'"});
            throw new InvalidDatatypeValueException(string4);
        }
        if ((this.fFacetsDefined & 0x200) != 0 && (n = bigDecimal.movePointRight(bigDecimal.scale()).toString().length() - (bigDecimal.signum() < 0 ? 1 : 0)) > this.fTotalDigits) {
            object = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.TOTALDIGITS_EXCEEDED], new Object[]{"'" + string + "'" + " with totalDigits = '" + n + "'", "'" + this.fTotalDigits + "'"});
            throw new InvalidDatatypeValueException((String)object);
        }
        this.boundsCheck(bigDecimal);
        if (this.fEnumeration != null) {
            this.enumCheck(bigDecimal, (BigDecimal[])this.fEnumeration);
        }
    }

    private static String stripPlusIfPresent(String string) {
        String string2 = string;
        if (string.length() >= 2 && string.charAt(0) == '+' && string.charAt(1) != '-') {
            string2 = string.substring(1);
        }
        return string2;
    }

    private void enumCheck(BigDecimal bigDecimal, BigDecimal[] bigDecimalArray) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < bigDecimalArray.length) {
            if (bigDecimal.equals(bigDecimalArray[n])) {
                return;
            }
            ++n;
        }
        String string = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.NOT_ENUM_VALUE], new Object[]{bigDecimal});
        throw new InvalidDatatypeValueException(string);
    }
}

