/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs_new;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs_new.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;

public class QNameDV
extends TypeValidator {
    private static final String EMPTY_STRING = "";

    public short getAllowedFacets() {
        return 63;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        String string2;
        String string3;
        int n = string.indexOf(":");
        if (n > 0) {
            string3 = validationContext.getSymbol(string.substring(0, n));
            string2 = string.substring(n + 1);
        } else {
            string3 = validationContext.getSymbol(EMPTY_STRING);
            string2 = string;
        }
        if (string3.length() > 0 && !XMLChar.isValidNCName(string3)) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not a valid QName: '" + string3 + "' is not an NCName");
        }
        if (!XMLChar.isValidNCName(string2)) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not a valid QName: '" + string2 + "' is not an NCName");
        }
        String string4 = validationContext.getURI(string3);
        if (string3.length() > 0 && string4 == null) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not a valid QName: cannot resolve the prefix to a namespace uri");
        }
        return new QName(string3, validationContext.getSymbol(string2), validationContext.getSymbol(string), string4);
    }

    public int getDataLength(Object object) {
        return ((QName)object).rawname.length();
    }
}

