/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs_new;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dv.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSAtomicSimpleType;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSListSimpleType;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.XSUnionSimpleType;
import org.apache.xerces.impl.dv.xs_new.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs_new.AnySimpleDV;
import org.apache.xerces.impl.dv.xs_new.AnyURIDV;
import org.apache.xerces.impl.dv.xs_new.Base64BinaryDV;
import org.apache.xerces.impl.dv.xs_new.BooleanDV;
import org.apache.xerces.impl.dv.xs_new.DateDV;
import org.apache.xerces.impl.dv.xs_new.DateTimeDV;
import org.apache.xerces.impl.dv.xs_new.DayDV;
import org.apache.xerces.impl.dv.xs_new.DecimalDV;
import org.apache.xerces.impl.dv.xs_new.DoubleDV;
import org.apache.xerces.impl.dv.xs_new.DurationDV;
import org.apache.xerces.impl.dv.xs_new.EntityDV;
import org.apache.xerces.impl.dv.xs_new.FloatDV;
import org.apache.xerces.impl.dv.xs_new.HexBinaryDV;
import org.apache.xerces.impl.dv.xs_new.IDDV;
import org.apache.xerces.impl.dv.xs_new.IDREFDV;
import org.apache.xerces.impl.dv.xs_new.ListDV;
import org.apache.xerces.impl.dv.xs_new.MonthDV;
import org.apache.xerces.impl.dv.xs_new.MonthDayDV;
import org.apache.xerces.impl.dv.xs_new.QNameDV;
import org.apache.xerces.impl.dv.xs_new.StringDV;
import org.apache.xerces.impl.dv.xs_new.TimeDV;
import org.apache.xerces.impl.dv.xs_new.TypeValidator;
import org.apache.xerces.impl.dv.xs_new.UnionDV;
import org.apache.xerces.impl.dv.xs_new.YearDV;
import org.apache.xerces.impl.dv.xs_new.YearMonthDV;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.util.XMLChar;

class XSSimpleTypeDecl
implements XSAtomicSimpleType,
XSListSimpleType,
XSUnionSimpleType {
    static final short DV_ANYSIMPLETYPE = 0;
    static final short DV_STRING = 1;
    static final short DV_BOOLEAN = 2;
    static final short DV_DECIMAL = 3;
    static final short DV_FLOAT = 4;
    static final short DV_DOUBLE = 5;
    static final short DV_DURATION = 6;
    static final short DV_DATETIME = 7;
    static final short DV_TIME = 8;
    static final short DV_DATE = 9;
    static final short DV_GYEARMONTH = 10;
    static final short DV_GYEAR = 11;
    static final short DV_GMONTHDAY = 12;
    static final short DV_GDAY = 13;
    static final short DV_GMONTH = 14;
    static final short DV_HEXBINARY = 15;
    static final short DV_BASE64BINARY = 16;
    static final short DV_ANYURI = 17;
    static final short DV_QNAME = 18;
    static final short DV_NOTATION = 19;
    static final short DV_ID = 20;
    static final short DV_IDREF = 21;
    static final short DV_ENTITY = 22;
    static final short DV_LIST = 23;
    static final short DV_UNION = 24;
    static final TypeValidator[] fDVs = new TypeValidator[]{new AnySimpleDV(), new StringDV(), new BooleanDV(), new DecimalDV(), new FloatDV(), new DoubleDV(), new DurationDV(), new DateTimeDV(), new TimeDV(), new DateDV(), new YearMonthDV(), new YearDV(), new MonthDayDV(), new DayDV(), new MonthDV(), new HexBinaryDV(), new Base64BinaryDV(), new AnyURIDV(), new QNameDV(), new QNameDV(), new IDDV(), new IDREFDV(), new EntityDV(), new ListDV(), new UnionDV()};
    static final short SPECIAL_TOKEN_NONE = 0;
    static final short SPECIAL_TOKEN_NMTOKEN = 1;
    static final short SPECIAL_TOKEN_NAME = 2;
    static final short SPECIAL_TOKEN_NCNAME = 3;
    static final String[] SPECIAL_TOKEN_STRING = new String[]{"NONE", "NMTOKEN", "Name", "NCName"};
    static final String[] WS_FACET_STRING = new String[]{"preserve", "collapse", "replace"};
    private XSSimpleTypeDecl fItemType;
    private XSSimpleTypeDecl[] fMemberTypes;
    private String fTypeName;
    private String fTargetNamespace;
    private short fFinalSet = 0;
    private XSSimpleTypeDecl fBase;
    private short fVariety = (short)-1;
    private short fValidationDV = (short)-1;
    private short fFacetsDefined = 0;
    private short fFixedFacet = 0;
    private short fWhiteSpace = 0;
    private int fLength = -1;
    private int fMinLength = -1;
    private int fMaxLength = -1;
    private int fTotalDigits = -1;
    private int fFractionDigits = -1;
    private Vector fPattern;
    private Vector fEnumeration;
    private Object fMaxInclusive;
    private Object fMaxExclusive;
    private Object fMinExclusive;
    private Object fMinInclusive;
    private short fTokenType = 0;
    private short fOrdered;
    private short fCardinality;
    private boolean fBounded;
    private boolean fNumeric;
    private ValidatedInfo fTempInfo = new ValidatedInfo();
    static final XSSimpleTypeDecl fAnySimpleType = new XSSimpleTypeDecl(null, "anySimpleType", 0, 1, false, 1, false);

    protected XSSimpleTypeDecl(XSSimpleTypeDecl xSSimpleTypeDecl, String string, short s, short s2, boolean bl, short s3, boolean bl2) {
        this.fBase = xSSimpleTypeDecl;
        this.fTypeName = string;
        this.fTargetNamespace = "http://www.w3.org/2001/XMLSchema";
        this.fVariety = 1;
        this.fValidationDV = s;
        this.fFacetsDefined = (short)32;
        if (s == 1) {
            this.fWhiteSpace = 0;
        } else {
            this.fWhiteSpace = (short)2;
            this.fFixedFacet = (short)32;
        }
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl xSSimpleTypeDecl, String string, String string2, short s) {
        this.fBase = xSSimpleTypeDecl;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s;
        this.fVariety = this.fBase.fVariety;
        this.fValidationDV = this.fBase.fValidationDV;
        switch (this.fVariety) {
            case 1: {
                break;
            }
            case 2: {
                this.fItemType = this.fBase.fItemType;
                break;
            }
            case 3: {
                this.fMemberTypes = this.fBase.fMemberTypes;
            }
        }
        this.fLength = this.fBase.fLength;
        this.fMinLength = this.fBase.fMinLength;
        this.fMaxLength = this.fBase.fMaxLength;
        this.fPattern = this.fBase.fPattern;
        this.fEnumeration = this.fBase.fEnumeration;
        this.fWhiteSpace = this.fBase.fWhiteSpace;
        this.fMaxExclusive = this.fBase.fMaxExclusive;
        this.fMaxInclusive = this.fBase.fMaxInclusive;
        this.fMinExclusive = this.fBase.fMinExclusive;
        this.fMinInclusive = this.fBase.fMinInclusive;
        this.fTotalDigits = this.fBase.fTotalDigits;
        this.fFractionDigits = this.fBase.fFractionDigits;
        this.fTokenType = this.fBase.fTokenType;
        this.fFixedFacet = this.fBase.fFixedFacet;
        this.fFacetsDefined = this.fBase.fFacetsDefined;
        this.caclFundamentalFacets();
    }

    protected XSSimpleTypeDecl(String string, String string2, short s, XSSimpleTypeDecl xSSimpleTypeDecl) {
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s;
        this.fVariety = (short)2;
        this.fItemType = xSSimpleTypeDecl;
        this.fValidationDV = (short)23;
        this.fFacetsDefined = (short)32;
        this.fFixedFacet = (short)32;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
    }

    protected XSSimpleTypeDecl(String string, String string2, short s, XSSimpleTypeDecl[] xSSimpleTypeDeclArray) {
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s;
        this.fVariety = (short)3;
        this.fMemberTypes = xSSimpleTypeDeclArray;
        this.fValidationDV = (short)24;
        this.fFacetsDefined = (short)32;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
    }

    public short getXSType() {
        return 2;
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public short getFinalSet() {
        return this.fFinalSet;
    }

    public XSTypeDecl getBaseType() {
        return this.fBase;
    }

    public boolean isAnonymous() {
        return this.fTypeName == null;
    }

    public short getVariety() {
        return this.fVariety;
    }

    public short getDefinedFacets() {
        return this.fFacetsDefined;
    }

    public boolean isIDType() {
        return this.fValidationDV == 20;
    }

    public boolean isNOTATIONType() {
        return this.fValidationDV == 19;
    }

    public XSSimpleType getPrimitiveType() {
        if (this.fVariety == 1) {
            return null;
        }
        return null;
    }

    public XSSimpleType getItemType() {
        if (this.fVariety == 2) {
            return this.fItemType;
        }
        return null;
    }

    public XSSimpleType[] getMemberTypes() {
        if (this.fVariety == 3) {
            return this.fMemberTypes;
        }
        return null;
    }

    public void applyFacets(XSFacets xSFacets, short s, short s2, ValidationContext validationContext) throws InvalidDatatypeFacetException {
        this.applyFacets(xSFacets, s, s2, (short)0, validationContext);
    }

    void applyFacets1(XSFacets xSFacets, short s, short s2) {
        try {
            this.applyFacets(xSFacets, s, s2, (short)0, null);
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            throw new RuntimeException("internal error");
        }
    }

    void applyFacets1(XSFacets xSFacets, short s, short s2, short s3) {
        try {
            this.applyFacets(xSFacets, s, s2, s3, null);
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            throw new RuntimeException("internal error");
        }
    }

    void applyFacets(XSFacets xSFacets, short s, short s2, short s3, ValidationContext validationContext) throws InvalidDatatypeFacetException {
        Serializable serializable;
        this.fFacetsDefined = 0;
        this.fFixedFacet = 0;
        int n = 0;
        short s4 = fDVs[this.fValidationDV].getAllowedFacets();
        if ((s & 1) != 0) {
            if ((s4 & 1) == 0) {
                this.reportError("non-supported facet");
            } else {
                this.fLength = xSFacets.length;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                if ((s2 & 1) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 1);
                }
                if (this.fLength < 0) {
                    this.reportError("length value '" + xSFacets.length + "' must be a nonNegativeInteger");
                }
            }
        }
        if ((s & 2) != 0) {
            if ((s4 & 2) == 0) {
                this.reportError("non-supported facet");
            } else {
                this.fMinLength = xSFacets.minLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                if ((s2 & 2) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 2);
                }
                if (this.fMinLength < 0) {
                    this.reportError("minLength value '" + xSFacets.minLength + "' must be a nonNegativeInteger");
                }
            }
        }
        if ((s & 4) != 0) {
            if ((s4 & 4) == 0) {
                this.reportError("non-supported facet");
            } else {
                this.fMaxLength = xSFacets.maxLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                if ((s2 & 4) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 4);
                }
                if (this.fMaxLength < 0) {
                    this.reportError("maxLength value '" + xSFacets.maxLength + "' must be a nonNegativeInteger");
                }
            }
        }
        if ((s & 8) != 0) {
            if ((s4 & 8) == 0) {
                this.reportError("non-supported facet");
            } else {
                serializable = null;
                try {
                    serializable = new RegularExpression(xSFacets.pattern, "X");
                }
                catch (Exception exception) {
                    this.reportError("pattern value '" + xSFacets.pattern + "' is not valid: " + exception.getLocalizedMessage());
                }
                if (serializable != null) {
                    this.fPattern = new Vector();
                    this.fPattern.addElement(serializable);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    if ((s2 & 8) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 8);
                    }
                }
            }
        }
        if ((s & 0x10) != 0) {
            if ((s4 & 0x10) == 0) {
                this.reportError("non-supported facet");
            } else {
                this.fEnumeration = new Vector();
                serializable = xSFacets.enumeration;
                int n2 = 0;
                while (n2 < ((Vector)serializable).size()) {
                    try {
                        this.fEnumeration.addElement(this.fBase.validate((String)((Vector)serializable).elementAt(n2), validationContext, this.fTempInfo));
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportError("Value of enumeration '" + ((Vector)serializable).elementAt(n2) + "' must be from the value space of base");
                    }
                    ++n2;
                }
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                if ((s2 & 0x10) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x10);
                }
            }
        }
        if ((s & 0x20) != 0) {
            if ((s4 & 0x20) == 0) {
                this.reportError("non-supported facet");
            } else {
                this.fWhiteSpace = xSFacets.whiteSpace;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                if ((s2 & 0x20) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x20);
                }
            }
        }
        if ((s & 0x40) != 0) {
            if ((s4 & 0x40) == 0) {
                this.reportError("non-supported facet");
            } else {
                try {
                    this.fMaxInclusive = this.getActualValue(xSFacets.maxInclusive, validationContext, this.fTempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                    if ((s2 & 0x40) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x40);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("maxInclusive value '" + xSFacets.maxInclusive + "' is invalid");
                }
            }
        }
        if ((s & 0x80) != 0) {
            if ((s4 & 0x80) == 0) {
                this.reportError("non-supported facet");
            } else {
                try {
                    this.fMaxExclusive = this.getActualValue(xSFacets.maxExclusive, validationContext, this.fTempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    if ((s2 & 0x80) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x80);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("maxExclusive value '" + xSFacets.maxExclusive + "' is invalid");
                }
            }
        }
        if ((s & 0x100) != 0) {
            if ((s4 & 0x100) == 0) {
                this.reportError("non-supported facet");
            } else {
                try {
                    this.fMinExclusive = this.getActualValue(xSFacets.minExclusive, validationContext, this.fTempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    if ((s2 & 0x100) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x100);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("minExclusive value '" + xSFacets.minExclusive + "' is invalid");
                }
            }
        }
        if ((s & 0x200) != 0) {
            if ((s4 & 0x200) == 0) {
                this.reportError("non-supported facet");
            } else {
                try {
                    this.fMinInclusive = this.getActualValue(xSFacets.minInclusive, validationContext, this.fTempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
                    if ((s2 & 0x200) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x200);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("minInclusive value '" + xSFacets.minInclusive + "' is invalid");
                }
            }
        }
        if ((s & 0x400) != 0) {
            if ((s4 & 0x400) == 0) {
                this.reportError("non-supported facet");
            } else {
                this.fTotalDigits = xSFacets.totalDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
                if ((s2 & 0x400) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x400);
                }
                if (this.fTotalDigits <= 0) {
                    this.reportError("totalDigits value '" + xSFacets.totalDigits + "' must be a positiveInteger");
                }
            }
        }
        if ((s & 0x800) != 0) {
            if ((s4 & 0x800) == 0) {
                this.reportError("non-supported facet");
            } else {
                this.fFractionDigits = xSFacets.fractionDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
                if ((s2 & 0x800) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x800);
                }
                if (this.fFractionDigits < 0) {
                    this.reportError("fractionDigits value '" + xSFacets.fractionDigits + "' must be a positiveInteger");
                }
            }
        }
        if (s3 != 0) {
            this.fTokenType = s3;
        }
        if (this.fFacetsDefined != 0) {
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 2) != 0) {
                    this.reportError("it is an error for both length and min length to be present");
                } else if ((this.fFacetsDefined & 4) != 0) {
                    this.reportError("it is an error for both length and max length to be present");
                }
            }
            if ((this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 && this.fMinLength > this.fMaxLength) {
                this.reportError("value of minLength = " + this.fMinLength + "must  be less than value of maxLength = " + this.fMaxLength);
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x40) != 0) {
                this.reportError("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype");
            }
            if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x200) != 0) {
                this.reportError("It is an error for both minInclusive and minExclusive to be specified for the same datatype");
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x200) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxInclusive)) != -1 && n != 0) {
                this.reportError("minInclusive value ='" + this.getStringValue(this.fMinInclusive) + "'must be <= maxInclusive value ='" + this.getStringValue(this.fMaxInclusive) + "'. ");
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxExclusive)) != -1 && n != 0) {
                this.reportError("minExclusive value ='" + this.getStringValue(this.fMinExclusive) + "' must be <= maxExclusive value ='" + this.getStringValue(this.fMaxExclusive) + "'. ");
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxInclusive) != -1) {
                this.reportError("minExclusive value ='" + this.getStringValue(this.fMinExclusive) + "' must be < maxInclusive value ='" + this.getStringValue(this.fMaxInclusive) + "'. ");
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x200) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxExclusive) != -1) {
                this.reportError("minInclusive value ='" + this.getStringValue(this.fMinInclusive) + "' must be < maxExclusive value ='" + this.getStringValue(this.fMaxExclusive) + "'. ");
            }
            if ((this.fFacetsDefined & 0x800) != 0 && (this.fFacetsDefined & 0x400) != 0 && this.fFractionDigits > this.fTotalDigits) {
                this.reportError("fractionDigits value ='" + this.fFractionDigits + "' must be <= totalDigits value ='" + this.fTotalDigits + "'. ");
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fBase.fFacetsDefined & 4) != 0) {
                    this.reportError("It is an error for both length and maxLength to be members of facets");
                } else if ((this.fBase.fFacetsDefined & 2) != 0) {
                    this.reportError("It is an error for both length and minLength to be members of facets");
                } else if ((this.fBase.fFacetsDefined & 1) != 0 && this.fLength != this.fBase.fLength) {
                    this.reportError("Value of length = '" + this.fLength + "' must be = the value of fBase.length = '" + this.fBase.fLength + "'");
                }
            }
            if ((this.fBase.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    this.reportError("It is an error for both length and maxLength to be members of facets");
                } else if ((this.fFacetsDefined & 2) != 0) {
                    this.reportError("It is an error for both length and minLength to be members of facets");
                }
            }
            if ((this.fFacetsDefined & 2) != 0) {
                if ((this.fBase.fFacetsDefined & 4) != 0) {
                    if (this.fMinLength > this.fBase.fMaxLength) {
                        this.reportError("Value of minLength = '" + this.fMinLength + "' must be <= the value of maxLength = '" + this.fMaxLength + "'");
                    }
                } else if ((this.fBase.fFacetsDefined & 2) != 0) {
                    if ((this.fBase.fFixedFacet & 2) != 0 && this.fMinLength != this.fBase.fMinLength) {
                        this.reportError("minLength value = '" + this.fMinLength + "' must be equal to fBase.minLength value = '" + this.fBase.fMinLength + "' with attribute {fixed} = true");
                    }
                    if (this.fMinLength < this.fBase.fMinLength) {
                        this.reportError("Value of minLength = '" + this.fMinLength + "' must be >= the value of fBase.minLength = '" + this.fBase.fMinLength + "'");
                    }
                }
            }
            if ((this.fFacetsDefined & 4) != 0 && (this.fBase.fFacetsDefined & 2) != 0 && this.fMaxLength < this.fBase.fMinLength) {
                this.reportError("Value of maxLength = '" + this.fMaxLength + "' must be >= the value of fBase.minLength = '" + this.fBase.fMinLength + "'");
            }
            if ((this.fFacetsDefined & 4) != 0 && (this.fBase.fFacetsDefined & 4) != 0) {
                if ((this.fBase.fFixedFacet & 4) != 0 && this.fMaxLength != this.fBase.fMaxLength) {
                    this.reportError("maxLength value = '" + this.fMaxLength + "' must be equal to fBase.maxLength value = '" + this.fBase.fMaxLength + "' with attribute {fixed} = true");
                }
                if (this.fMaxLength > this.fBase.fMaxLength) {
                    this.reportError("Value of maxLength = '" + this.fMaxLength + "' must be <= the value of fBase.maxLength = '" + this.fBase.fMaxLength + "'");
                }
            }
            if ((this.fFacetsDefined & 0x40) != 0) {
                if ((this.fBase.fFacetsDefined & 0x40) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMaxInclusive);
                    if ((this.fBase.fFixedFacet & 0x40) != 0 && n != 0) {
                        this.reportError("maxInclusive value = '" + this.getStringValue(this.fMaxInclusive) + "' must be equal to fBase.maxInclusive value = '" + this.getStringValue(this.fBase.fMaxInclusive) + "' with attribute {fixed} = true");
                    }
                    if (n != -1 && n != 0) {
                        this.reportError("maxInclusive value ='" + this.getStringValue(this.fMaxInclusive) + "' must be <= fBase.maxInclusive value ='" + this.getStringValue(this.fBase.fMaxInclusive) + "'");
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0 && fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMaxExclusive) != -1) {
                    this.reportError("maxInclusive value ='" + this.getStringValue(this.fMaxInclusive) + "' must be < fBase.maxExclusive value ='" + this.getStringValue(this.fBase.fMaxExclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x200) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMinInclusive)) != 1 && n != 0) {
                    this.reportError("maxInclusive value ='" + this.getStringValue(this.fMaxInclusive) + "' must be >= fBase.minInclusive value ='" + this.getStringValue(this.fBase.fMinInclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMinExclusive) != 1) {
                    this.reportError("maxInclusive value ='" + this.getStringValue(this.fMaxInclusive) + "' must be > fBase.minExclusive value ='" + this.getStringValue(this.fBase.fMinExclusive) + "'");
                }
            }
            if ((this.fFacetsDefined & 0x80) != 0) {
                if ((this.fBase.fFacetsDefined & 0x80) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxExclusive);
                    if ((this.fBase.fFixedFacet & 0x80) != 0 && n != 0) {
                        this.reportError("maxExclusive value = '" + this.getStringValue(this.fMaxExclusive) + "' must be equal to fBase.maxExclusive value = '" + this.getStringValue(this.fBase.fMaxExclusive) + "' with attribute {fixed} = true");
                    }
                    if (n != -1 && n != 0) {
                        this.reportError("maxExclusive value ='" + this.getStringValue(this.fMaxExclusive) + "' must be < fBase.maxExclusive value ='" + this.getStringValue(this.fBase.fMaxExclusive) + "'");
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxInclusive)) != -1 && n != 0) {
                    this.reportError("maxExclusive value ='" + this.getStringValue(this.fMaxExclusive) + "' must be <= fBase.maxInclusive value ='" + this.getStringValue(this.fBase.fMaxInclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMinExclusive) != 1) {
                    this.reportError("maxExclusive value ='" + this.getStringValue(this.fMaxExclusive) + "' must be > fBase.minExclusive value ='" + this.getStringValue(this.fBase.fMinExclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x200) != 0 && fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMinInclusive) != 1) {
                    this.reportError("maxExclusive value ='" + this.getStringValue(this.fMaxExclusive) + "' must be > fBase.minInclusive value ='" + this.getStringValue(this.fBase.fMinInclusive) + "'");
                }
            }
            if ((this.fFacetsDefined & 0x100) != 0) {
                if ((this.fBase.fFacetsDefined & 0x100) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinExclusive);
                    if ((this.fBase.fFixedFacet & 0x100) != 0 && n != 0) {
                        this.reportError("minExclusive value = '" + this.getStringValue(this.fMinExclusive) + "' must be equal to fBase.minExclusive value = '" + this.getStringValue(this.fBase.fMinExclusive) + "' with attribute {fixed} = true");
                    }
                    if (n != 1 && n != 0) {
                        this.reportError("minExclusive value ='" + this.getStringValue(this.fMinExclusive) + "' must be >= fBase.minExclusive value ='" + this.getStringValue(this.fBase.fMinExclusive) + "'");
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMaxInclusive)) != -1 && n != 0) {
                    this.reportError("minExclusive value ='" + this.getStringValue(this.fMinExclusive) + "' must be <= fBase.maxInclusive value ='" + this.getStringValue(this.fBase.fMaxInclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x200) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinInclusive)) != 1 && n != 0) {
                    this.reportError("minExclusive value ='" + this.getStringValue(this.fMinExclusive) + "' must be >= fBase.minInclusive value ='" + this.getStringValue(this.fBase.fMinInclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0 && fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMaxExclusive) != -1) {
                    this.reportError("minExclusive value ='" + this.getStringValue(this.fMinExclusive) + "' must be < fBase.maxExclusive value ='" + this.getStringValue(this.fBase.fMaxExclusive) + "'");
                }
            }
            if ((this.fFacetsDefined & 0x200) != 0) {
                if ((this.fBase.fFacetsDefined & 0x200) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMinInclusive);
                    if ((this.fBase.fFixedFacet & 0x200) != 0 && n != 0) {
                        this.reportError("minInclusive value = '" + this.getStringValue(this.fMinInclusive) + "' must be equal to fBase.minInclusive value = '" + this.getStringValue(this.fBase.fMinInclusive) + "' with attribute {fixed} = true");
                    }
                    if (n != 1 && n != 0) {
                        this.reportError("minInclusive value ='" + this.getStringValue(this.fMinInclusive) + "' must be >= fBase.minInclusive value ='" + this.getStringValue(this.fBase.fMinInclusive) + "'");
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMaxInclusive)) != -1 && n != 0) {
                    this.reportError("minInclusive value ='" + this.getStringValue(this.fMinInclusive) + "' must be <= fBase.maxInclusive value ='" + this.getStringValue(this.fBase.fMaxInclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMinExclusive) != 1) {
                    this.reportError("minInclusive value ='" + this.getStringValue(this.fMinInclusive) + "' must be > fBase.minExclusive value ='" + this.getStringValue(this.fBase.fMinExclusive) + "'");
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMaxExclusive) != -1) {
                    this.reportError("minInclusive value ='" + this.getStringValue(this.fMinInclusive) + "' must be < fBase.maxExclusive value ='" + this.getStringValue(this.fBase.fMaxExclusive) + "'");
                }
            }
            if ((this.fFacetsDefined & 0x400) != 0 && (this.fBase.fFacetsDefined & 0x400) != 0) {
                if (this.fTotalDigits > this.fBase.fTotalDigits) {
                    this.reportError("totalDigits value = '" + this.fTotalDigits + "' must be equal to fBase.totalDigits value = '" + this.fBase.fTotalDigits + "' with attribute {fixed} = true");
                }
                if (this.fTotalDigits > this.fBase.fTotalDigits) {
                    this.reportError("totalDigits value ='" + this.fTotalDigits + "' must be <= fBase.totalDigits value ='" + this.fBase.fTotalDigits + "'");
                }
            }
            if ((this.fFacetsDefined & 0x800) != 0 && (this.fBase.fFacetsDefined & 0x800) != 0 && (this.fBase.fFixedFacet & 0x800) != 0 && this.fFractionDigits != this.fBase.fFractionDigits) {
                this.reportError("fractionDigits value = '" + this.fFractionDigits + "' must be equal to fBase.fractionDigits value = '" + this.fBase.fFractionDigits + "' with attribute {fixed} = true");
            }
            if ((this.fFacetsDefined & 0x20) != 0 && (this.fBase.fFacetsDefined & 0x20) != 0) {
                if ((this.fBase.fFixedFacet & 0x20) != 0 && this.fWhiteSpace != this.fBase.fWhiteSpace) {
                    this.reportError("whiteSpace value = '" + this.whiteSpaceValue(this.fWhiteSpace) + "' must be equal to fBase.whiteSpace value = '" + this.whiteSpaceValue(this.fBase.fWhiteSpace) + "' with attribute {fixed} = true");
                }
                if ((this.fWhiteSpace == 0 || this.fWhiteSpace == 1) && this.fBase.fWhiteSpace == 2) {
                    this.reportError("It is an error if whiteSpace = 'preserve' or 'replace' and fBase.whiteSpace = 'collapse'");
                }
                if (this.fWhiteSpace == 0 && this.fBase.fWhiteSpace == 1) {
                    this.reportError("It is an error if whiteSpace = 'preserve' and fBase.whiteSpace = 'replace'");
                }
            }
        }
        if ((this.fFacetsDefined & 1) == 0 && (this.fBase.fFacetsDefined & 1) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
            this.fLength = this.fBase.fLength;
        }
        if ((this.fFacetsDefined & 2) == 0 && (this.fBase.fFacetsDefined & 2) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
            this.fMinLength = this.fBase.fMinLength;
        }
        if ((this.fFacetsDefined & 4) == 0 && (this.fBase.fFacetsDefined & 4) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
            this.fMaxLength = this.fBase.fMaxLength;
        }
        if ((this.fBase.fFacetsDefined & 8) != 0) {
            if ((this.fFacetsDefined & 8) == 0) {
                this.fPattern = new Vector();
                this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
            }
            int n3 = this.fBase.fPattern.size() - 1;
            while (n3 >= 0) {
                this.fPattern.addElement(this.fBase.fPattern.elementAt(n3));
                --n3;
            }
        }
        if ((this.fFacetsDefined & 0x20) == 0 && (this.fBase.fFacetsDefined & 0x20) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
            this.fWhiteSpace = this.fBase.fWhiteSpace;
        }
        if ((this.fFacetsDefined & 0x10) == 0 && (this.fBase.fFacetsDefined & 0x10) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
            this.fEnumeration = this.fBase.fEnumeration;
        }
        if ((this.fBase.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x40) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
            this.fMaxExclusive = this.fBase.fMaxExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x40) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
            this.fMaxInclusive = this.fBase.fMaxInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x200) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
            this.fMinExclusive = this.fBase.fMinExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x200) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x200) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
            this.fMinInclusive = this.fBase.fMinInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x400) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
            this.fTotalDigits = this.fBase.fTotalDigits;
        }
        if ((this.fBase.fFacetsDefined & 0x800) != 0 && (this.fFacetsDefined & 0x800) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
            this.fFractionDigits = this.fBase.fFractionDigits;
        }
        if (this.fTokenType == 0 && this.fBase.fTokenType != 0) {
            this.fTokenType = this.fBase.fTokenType;
        }
        this.fFixedFacet = (short)(this.fFixedFacet | this.fBase.fFixedFacet);
        this.caclFundamentalFacets();
    }

    public Object validate(String string, ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        Object object = this.getActualValue(string, validationContext, this.fTempInfo);
        this.validate(validationContext, this.fTempInfo);
        if (validatedInfo != null) {
            validatedInfo.actualValue = this.fTempInfo.actualValue;
            validatedInfo.normalizedValue = this.fTempInfo.normalizedValue;
            validatedInfo.memberType = this.fTempInfo.memberType;
            validatedInfo.memberTypes = this.fTempInfo.memberTypes;
        }
        return object;
    }

    public void validate(ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (validationContext.needFacetChecking() && this.fFacetsDefined != 0 && this.fFacetsDefined != 32) {
            this.checkFacets(validatedInfo);
        }
        if (validationContext.needExtraChecking()) {
            this.checkExtraRules(validationContext, validatedInfo);
        }
    }

    private void checkFacets(ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        int n;
        int n2;
        int n3;
        Object object = validatedInfo.actualValue;
        String string = validatedInfo.normalizedValue;
        int n4 = fDVs[this.fValidationDV].getDataLength(object);
        if ((this.fFacetsDefined & 4) != 0 && n4 > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n4 + "' exceeds maximum length facet of '" + this.fMaxLength + "'");
        }
        if ((this.fFacetsDefined & 2) != 0 && n4 < this.fMinLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n4 + "' is less than minimum length facet of '" + this.fMinLength + "'");
        }
        if ((this.fFacetsDefined & 1) != 0 && n4 != this.fLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n4 + "' is not equal to length facet '" + this.fLength + "'");
        }
        if ((this.fFacetsDefined & 0x10) != 0) {
            n3 = 0;
            n2 = 0;
            while (n2 < this.fEnumeration.size()) {
                if (this.isEqual(object, this.fEnumeration.elementAt(n2))) {
                    n3 = 1;
                    break;
                }
                ++n2;
            }
            if (n3 == 0) {
                throw new InvalidDatatypeValueException(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.NOT_ENUM_VALUE], new Object[]{string});
            }
        }
        if ((this.fFacetsDefined & 0x800) != 0 && (n3 = fDVs[this.fValidationDV].getFractionDigits(object)) > this.fFractionDigits) {
            throw new InvalidDatatypeValueException(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.FRACTION_EXCEEDED], new Object[]{"'" + string + "'" + " with fractionDigits = '" + n3 + "'", "'" + this.fFractionDigits + "'"});
        }
        if ((this.fFacetsDefined & 0x400) != 0 && (n3 = fDVs[this.fValidationDV].getTotalDigits(object)) > this.fTotalDigits) {
            throw new InvalidDatatypeValueException(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.TOTALDIGITS_EXCEEDED], new Object[]{"'" + string + "'" + " with totalDigits = '" + n3 + "'", "'" + this.fTotalDigits + "'"});
        }
        n3 = 1;
        n2 = 1;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if ((this.fFacetsDefined & 0x40) != 0) {
            n = fDVs[this.fValidationDV].compare(object, this.fMaxInclusive);
            n2 = n == -1 || n == 0 ? 1 : 0;
            string2 = this.fMaxInclusive.toString();
            if (string2 != null) {
                string5 = "<=";
            } else {
                string2 = "";
            }
        }
        if ((this.fFacetsDefined & 0x80) != 0) {
            n = fDVs[this.fValidationDV].compare(object, this.fMaxExclusive);
            n2 = n == -1 ? 1 : 0;
            string2 = this.fMaxExclusive.toString();
            if (string2 != null) {
                string5 = "<";
            } else {
                string2 = "";
            }
        }
        if ((this.fFacetsDefined & 0x200) != 0) {
            n = fDVs[this.fValidationDV].compare(object, this.fMinInclusive);
            n3 = n == 1 || n == 0 ? 1 : 0;
            string3 = this.fMinInclusive.toString();
            if (string3 != null) {
                string4 = "<=";
            } else {
                string3 = "";
            }
        }
        if ((this.fFacetsDefined & 0x100) != 0) {
            n = fDVs[this.fValidationDV].compare(object, this.fMinExclusive);
            n3 = n == 1 ? 1 : 0;
            string3 = this.fMinExclusive.toString();
            if (string3 != null) {
                string4 = "<";
            } else {
                string3 = "";
            }
        }
        if (n3 == 0 || n2 == 0) {
            throw new InvalidDatatypeValueException(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.OUT_OF_BOUNDS], new Object[]{object.toString(), string3, string2, string4, string5});
        }
    }

    private void checkExtraRules(ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        Object object = validatedInfo.actualValue;
        if (this.fVariety == 1) {
            fDVs[this.fValidationDV].checkExtraRules(object, validationContext);
        } else if (this.fVariety == 2) {
            Object[] objectArray = (Object[])object;
            if (this.fItemType.fVariety == 3) {
                XSSimpleTypeDecl[] xSSimpleTypeDeclArray = (XSSimpleTypeDecl[])validatedInfo.memberTypes;
                XSSimpleType xSSimpleType = validatedInfo.memberType;
                int n = objectArray.length - 1;
                while (n >= 0) {
                    validatedInfo.actualValue = objectArray[n];
                    validatedInfo.memberType = xSSimpleTypeDeclArray[n];
                    this.fItemType.checkExtraRules(validationContext, validatedInfo);
                    --n;
                }
                validatedInfo.memberType = xSSimpleType;
            } else {
                int n = objectArray.length - 1;
                while (n >= 0) {
                    validatedInfo.actualValue = objectArray[n];
                    this.fItemType.checkExtraRules(validationContext, validatedInfo);
                    --n;
                }
            }
            validatedInfo.actualValue = objectArray;
        } else {
            ((XSSimpleTypeDecl)validatedInfo.memberType).checkExtraRules(validationContext, validatedInfo);
        }
    }

    private Object getActualValue(String string, ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (this.fVariety == 1) {
            Object object;
            String string2 = XSSimpleTypeDecl.normalize(string, this.fWhiteSpace);
            if (this.fTokenType != 0) {
                boolean bl = false;
                if (this.fTokenType == 1) {
                    bl = !XMLChar.isValidNmtoken(string2);
                } else if (this.fTokenType == 2) {
                    bl = !XMLChar.isValidName(string2);
                } else if (this.fTokenType == 3) {
                    boolean bl2 = bl = !XMLChar.isValidNCName(string2);
                }
                if (bl) {
                    throw new InvalidDatatypeValueException("Value '" + string2 + "' is not a valid " + SPECIAL_TOKEN_STRING[this.fTokenType]);
                }
            }
            if ((this.fFacetsDefined & 8) != 0) {
                int n = this.fPattern.size() - 1;
                while (n >= 0) {
                    RegularExpression regularExpression = (RegularExpression)this.fPattern.elementAt(n);
                    if (!regularExpression.matches(string2)) {
                        throw new InvalidDatatypeValueException("Value '" + string + "' does not match regular expression facet '" + regularExpression + "'");
                    }
                    --n;
                }
            }
            validatedInfo.actualValue = object = fDVs[this.fValidationDV].getActualValue(string2, validationContext);
            validatedInfo.normalizedValue = string2;
            return object;
        }
        if (this.fVariety == 2) {
            String string3 = XSSimpleTypeDecl.normalize(string, this.fWhiteSpace);
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n = stringTokenizer.countTokens();
            Object[] objectArray = new Object[n];
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = new XSSimpleTypeDecl[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = this.fItemType.getActualValue(stringTokenizer.nextToken(), validationContext, validatedInfo);
                if (validationContext.needFacetChecking() && this.fItemType.fFacetsDefined != 0 && this.fItemType.fFacetsDefined != 32) {
                    this.fItemType.checkFacets(validatedInfo);
                }
                xSSimpleTypeDeclArray[n2] = (XSSimpleTypeDecl)validatedInfo.memberType;
                ++n2;
            }
            validatedInfo.actualValue = objectArray;
            validatedInfo.normalizedValue = string3;
            validatedInfo.memberTypes = xSSimpleTypeDeclArray;
            return objectArray;
        }
        int n = 0;
        while (n < this.fMemberTypes.length) {
            try {
                Object object = this.fMemberTypes[n].getActualValue(string, validationContext, validatedInfo);
                if (validationContext.needFacetChecking() && this.fMemberTypes[n].fFacetsDefined != 0 && this.fMemberTypes[n].fFacetsDefined != 32) {
                    this.fMemberTypes[n].checkFacets(validatedInfo);
                }
                validatedInfo.memberType = this.fMemberTypes[n];
                return object;
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                ++n;
            }
        }
        String string4 = " content = " + string + " doesnt't match any of the member types ";
        throw new InvalidDatatypeValueException(string4);
    }

    public boolean isEqual(Object object, Object object2) {
        if (this.fVariety == 1) {
            return fDVs[this.fValidationDV].isEqual(object, object2);
        }
        if (this.fVariety == 2) {
            if (!(object instanceof Object[]) || !(object2 instanceof Object[])) {
                return false;
            }
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])object2;
            if (n != objectArray2.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.fItemType.isEqual(objectArray[n2], objectArray2[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (this.fVariety == 3) {
            int n = this.fMemberTypes.length - 1;
            while (n >= 0) {
                if (this.fMemberTypes[n].isEqual(object, object2)) {
                    return true;
                }
                --n;
            }
            return false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String normalize(String var0, short var1_1) {
        block8: {
            block7: {
                v0 = var2_2 = var0 == null ? 0 : var0.length();
                if (var2_2 == 0 || var1_1 == 0) {
                    return var0;
                }
                var3_3 = new StringBuffer();
                if (var1_1 != 1) break block7;
                var5_4 = 0;
                while (var5_4 < var2_2) {
                    var4_6 = var0.charAt(var5_4);
                    if (var4_6 != '\t' && var4_6 != '\n' && var4_6 != '\r') {
                        var3_3.append(var4_6);
                    } else {
                        var3_3.append(' ');
                    }
                    ++var5_4;
                }
                break block8;
            }
            var6_8 = true;
            var5_5 = 0;
            while (var5_5 < var2_2) {
                block9: {
                    var4_7 = var0.charAt(var5_5);
                    if (var4_7 == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') ** GOTO lbl30
                    var3_3.append(var4_7);
                    var6_8 = false;
                    break block9;
                    while ((var4_7 = var0.charAt(var5_5 + 1)) == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') {
                        ++var5_5;
lbl30:
                        // 2 sources

                        if (var5_5 < var2_2 - 1) continue;
                    }
                    if (var5_5 < var2_2 - 1 && !var6_8) {
                        var3_3.append(' ');
                    }
                }
                ++var5_5;
            }
        }
        return var3_3.toString();
    }

    void reportError(String string) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(string);
    }

    private String whiteSpaceValue(short s) {
        return WS_FACET_STRING[s];
    }

    public String getStringValue(Object object) {
        if (object != null) {
            if (fDVs[this.fValidationDV] instanceof AbstractDateTimeDV) {
                return ((AbstractDateTimeDV)fDVs[this.fValidationDV]).dateToString((int[])object);
            }
            return object.toString();
        }
        return null;
    }

    public short getOrderedFacet() {
        return this.fOrdered;
    }

    public boolean isBounded() {
        return this.fBounded;
    }

    public short getCardinalityFacet() {
        return this.fCardinality;
    }

    public boolean isNumeric() {
        return this.fNumeric;
    }

    private void caclFundamentalFacets() {
        this.setOrdered();
        this.setNumeric();
        this.setBounded();
        this.setCardinality();
    }

    private void setOrdered() {
        if (this.fVariety == 1) {
            this.fOrdered = this.fBase.fOrdered;
        } else if (this.fVariety == 2) {
            this.fOrdered = 1;
        } else if (this.fVariety == 3) {
            int n = this.fMemberTypes.length;
            if (n == 0) {
                this.fOrdered = (short)2;
                return;
            }
            short s = this.getPrimitiveDV(this.fMemberTypes[0].fValidationDV);
            boolean bl = s != 0;
            boolean bl2 = this.fMemberTypes[0].fOrdered == 1;
            int n2 = 1;
            while (n2 < this.fMemberTypes.length && (bl || bl2)) {
                if (bl) {
                    boolean bl3 = bl = s == this.getPrimitiveDV(this.fMemberTypes[n2].fValidationDV);
                }
                if (bl2) {
                    bl2 = this.fMemberTypes[n2].fOrdered == 1;
                }
                ++n2;
            }
            this.fOrdered = bl ? this.fMemberTypes[0].fOrdered : (bl2 ? (short)1 : (short)2);
        }
    }

    private void setNumeric() {
        if (this.fVariety == 1) {
            this.fNumeric = this.fBase.fNumeric;
        } else if (this.fVariety == 2) {
            this.fNumeric = false;
        } else if (this.fVariety == 3) {
            XSSimpleType[] xSSimpleTypeArray = this.getMemberTypes();
            int n = 0;
            while (n < xSSimpleTypeArray.length) {
                if (!xSSimpleTypeArray[n].isNumeric()) {
                    this.fNumeric = false;
                    return;
                }
                ++n;
            }
            this.fNumeric = true;
        }
    }

    private void setBounded() {
        if (this.fVariety == 1) {
            this.fBounded = !((this.fFacetsDefined & 0x200) == 0 && (this.fFacetsDefined & 0x100) == 0 || (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x80) == 0);
        } else if (this.fVariety == 2) {
            this.fBounded = (this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = this.fMemberTypes;
            short s = 0;
            if (xSSimpleTypeDeclArray.length > 0) {
                s = this.getPrimitiveDV(xSSimpleTypeDeclArray[0].fValidationDV);
            }
            int n = 0;
            while (n < xSSimpleTypeDeclArray.length) {
                if (!xSSimpleTypeDeclArray[n].isBounded() || s != this.getPrimitiveDV(xSSimpleTypeDeclArray[n].fValidationDV)) {
                    this.fBounded = false;
                    return;
                }
                ++n;
            }
            this.fBounded = true;
        }
    }

    private boolean specialCardinalityCheck() {
        return this.fBase.fValidationDV == 9 || this.fBase.fValidationDV == 10 || this.fBase.fValidationDV == 11 || this.fBase.fValidationDV == 12 || this.fBase.fValidationDV == 13 || this.fBase.fValidationDV == 14;
    }

    private void setCardinality() {
        if (this.fVariety == 1) {
            this.fCardinality = this.fBase.fCardinality == 1 ? (short)1 : ((this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 4) != 0 || (this.fFacetsDefined & 0x400) != 0 ? (short)1 : (!((this.fFacetsDefined & 0x200) == 0 && (this.fFacetsDefined & 0x100) == 0 || (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x80) == 0) ? ((this.fFacetsDefined & 0x800) != 0 || this.specialCardinalityCheck() ? (short)1 : (short)2) : (short)2));
        } else if (this.fVariety == 2) {
            this.fCardinality = (this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 ? (short)1 : (short)2;
        } else if (this.fVariety == 3) {
            XSSimpleType[] xSSimpleTypeArray = this.getMemberTypes();
            int n = 0;
            while (n < xSSimpleTypeArray.length) {
                if (xSSimpleTypeArray[n].getCardinalityFacet() != 1) {
                    this.fCardinality = (short)2;
                    return;
                }
                ++n;
            }
            this.fCardinality = 1;
        }
    }

    private short getPrimitiveDV(short s) {
        if (s == 20 || s == 21 || s == 22) {
            return 1;
        }
        return s;
    }
}

