/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.Grammar;
import org.apache.xerces.impl.validation.GrammarPool;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.AttributePSVImpl;
import org.apache.xerces.impl.xs.ElementPSVImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarResolver;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IDValue;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLEntityResolver;

public class XMLSchemaValidator
implements XMLComponent,
XMLDocumentFilter,
FieldActivator {
    private static final boolean DEBUG = false;
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/namespaces", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema-full-checking"};
    protected static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation"};
    protected boolean fSeenRoot = false;
    protected boolean fNamespaces = false;
    protected final ElementPSVImpl fElemPSVI = new ElementPSVImpl();
    protected ElementPSVImpl fCurrentPSVI = null;
    protected static final String ELEM_PSVI = "ELEM_PSVI";
    protected static final String ATTR_PSVI = "ATTR_PSVI";
    protected boolean fValidation = false;
    protected boolean fDynamicValidation = false;
    protected boolean fDoValidation = false;
    protected boolean fFullChecking = false;
    protected SymbolTable fSymbolTable;
    protected XSIErrorReporter fXSIErrorReporter = new XSIErrorReporter();
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager = null;
    protected ValidationState fValidationState = null;
    protected GrammarPool fGrammarPool;
    protected String fExternalSchemas = null;
    protected String fExternalNoNamespaceSchema = null;
    protected XMLDocumentHandler fDocumentHandler;
    static final int INITIAL_STACK_SIZE = 8;
    static final int INC_STACK_SIZE = 8;
    String XMLNS;
    String URI_XSI;
    String XSI_SCHEMALOCATION;
    String XSI_NONAMESPACESCHEMALOCATION;
    String XSI_TYPE;
    String XSI_NIL;
    String URI_SCHEMAFORSCHEMA;
    final XSGrammarResolver fGrammarResolver;
    final SubstitutionGroupHandler fSubGroupHandler;
    final XSDHandler fSchemaHandler;
    final NamespaceSupport fNamespaceSupport = new NamespaceSupport();
    boolean fPushForNextBinding;
    final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    final CMBuilder fCMBuilder = new CMBuilder(new XSDeclarationPool());
    String fValidationRoot;
    int fValidationRootDepth;
    int fSkipValidationDepth;
    int fPartialValidationDepth;
    int fElementDepth;
    int fChildCount;
    int[] fChildCountStack = new int[8];
    XSElementDecl fCurrentElemDecl;
    XSElementDecl[] fElemDeclStack = new XSElementDecl[8];
    boolean fNil;
    boolean[] fNilStack = new boolean[8];
    XSTypeDecl fCurrentType;
    XSTypeDecl[] fTypeStack = new XSTypeDecl[8];
    XSCMValidator fCurrentCM;
    XSCMValidator[] fCMStack = new XSCMValidator[8];
    int[] fCurrCMState;
    int[][] fCMStateStack = new int[8][];
    final StringBuffer fBuffer = new StringBuffer();
    boolean fSawCharacters = false;
    boolean[] fStringContent = new boolean[8];
    final QName fTempQName = new QName();
    ValidatedInfo fValidatedInfo = new ValidatedInfo();
    private ValidationState fState4XsiType = new ValidationState();
    private ValidationState fState4ApplyDefault = new ValidationState();
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.handleStartDocument(xMLLocator, string);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(xMLLocator, string, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
        this.handleStartPrefix(string, string2);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startPrefixMapping(string, string2, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes, augmentations);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes, augmentations);
        XMLString xMLString = this.handleEndElement(qName, augmentations);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.handleCharacters(xMLString);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(xMLString, augmentations);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.handleIgnorableWhitespace(xMLString);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        XMLString xMLString = this.handleEndElement(qName, augmentations);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(qName, augmentations);
        }
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endPrefixMapping(string, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        this.handleEndDocument();
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void startEntity(String string, String string2, String string3, String string4, String string5, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startEntity(string, string2, string3, string4, string5, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void endEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endEntity(string, augmentations);
        }
    }

    public XMLSchemaValidator() {
        this.fGrammarResolver = new XSGrammarResolver();
        this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarResolver);
        this.fSchemaHandler = new XSDHandler(this.fGrammarResolver);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fXSIErrorReporter.reset((XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER));
        SymbolTable symbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        if (symbolTable != this.fSymbolTable) {
            this.XMLNS = symbolTable.addSymbol("xmlns");
            this.URI_XSI = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
            this.XSI_SCHEMALOCATION = symbolTable.addSymbol("schemaLocation");
            this.XSI_NONAMESPACESCHEMALOCATION = symbolTable.addSymbol("noNamespaceSchemaLocation");
            this.XSI_TYPE = symbolTable.addSymbol("type");
            this.XSI_NIL = symbolTable.addSymbol("nil");
            this.URI_SCHEMAFORSCHEMA = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
        }
        this.fSymbolTable = symbolTable;
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fValidation = this.fValidation && xMLComponentManager.getFeature(SCHEMA_VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fFullChecking = xMLComponentManager.getFeature(SCHEMA_FULL_CHECKING);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fFullChecking = false;
        }
        try {
            this.fDynamicValidation = xMLComponentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDynamicValidation = false;
        }
        this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_MANAGER);
        this.fNamespaceSupport.reset(this.fSymbolTable);
        this.fPushForNextBinding = true;
        this.fValidationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        this.fValidationManager.reset();
        this.fExternalSchemas = (String)xMLComponentManager.getProperty(SCHEMA_LOCATION);
        this.fExternalNoNamespaceSchema = (String)xMLComponentManager.getProperty(SCHEMA_NONS_LOCATION);
        this.fGrammarResolver.reset();
        this.fGrammarResolver.putGrammar(this.URI_SCHEMAFORSCHEMA, SchemaGrammar.SG_SchemaNS);
        this.fGrammarPool = (GrammarPool)xMLComponentManager.getProperty(GRAMMAR_POOL);
        Grammar[] grammarArray = this.fGrammarPool.getGrammarsNS();
        int n = 0;
        while (n < grammarArray.length) {
            this.fGrammarResolver.putGrammar((SchemaGrammar)grammarArray[n]);
            ++n;
        }
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fXSIErrorReporter.fErrorReporter, this.fEntityResolver, this.fSymbolTable, this.fExternalSchemas, this.fExternalNoNamespaceSchema);
        this.fCurrentElemDecl = null;
        this.fNil = false;
        this.fCurrentPSVI = null;
        this.fCurrentType = null;
        this.fCurrentCM = null;
        this.fCurrCMState = null;
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        this.fValidationRootDepth = -1;
        this.fValidationRoot = null;
        this.fSkipValidationDepth = -1;
        this.fPartialValidationDepth = -1;
        this.fElementDepth = -1;
        this.fChildCount = 0;
        this.fMatcherStack.clear();
        this.fValueStoreCache = new ValueStoreCache();
        this.fState4XsiType.setExtraChecking(false);
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4XsiType.setNamespaceSupport(this.fNamespaceSupport);
        this.fState4ApplyDefault.setFacetChecking(false);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setNamespaceSupport(this.fNamespaceSupport);
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        int n = 0;
        while (n < identityConstraint.getFieldCount()) {
            Field field = identityConstraint.getFieldAt(n);
            ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(field);
            valueStoreBase.startValueScope();
            ++n;
        }
    }

    public XPathMatcher activateField(Field field) throws XNIException {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(field);
        field.setMayMatch(true);
        XPathMatcher xPathMatcher = field.createMatcher(valueStoreBase);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fSymbolTable);
        return xPathMatcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint);
        valueStoreBase.endValueScope();
    }

    private void activateSelectorFor(IdentityConstraint identityConstraint) throws XNIException {
        Selector selector = identityConstraint.getSelector();
        XMLSchemaValidator xMLSchemaValidator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher xPathMatcher = selector.createMatcher(xMLSchemaValidator);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fSymbolTable);
    }

    void ensureStackCapacity() {
        if (this.fElementDepth == this.fElemDeclStack.length) {
            int n = this.fElementDepth + 8;
            int[] nArray = new int[n];
            System.arraycopy(this.fChildCountStack, 0, nArray, 0, this.fElementDepth);
            this.fChildCountStack = nArray;
            XSElementDecl[] xSElementDeclArray = new XSElementDecl[n];
            System.arraycopy(this.fElemDeclStack, 0, xSElementDeclArray, 0, this.fElementDepth);
            this.fElemDeclStack = xSElementDeclArray;
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.fNilStack, 0, blArray, 0, this.fElementDepth);
            this.fNilStack = blArray;
            XSTypeDecl[] xSTypeDeclArray = new XSTypeDecl[n];
            System.arraycopy(this.fTypeStack, 0, xSTypeDeclArray, 0, this.fElementDepth);
            this.fTypeStack = xSTypeDeclArray;
            XSCMValidator[] xSCMValidatorArray = new XSCMValidator[n];
            System.arraycopy(this.fCMStack, 0, xSCMValidatorArray, 0, this.fElementDepth);
            this.fCMStack = xSCMValidatorArray;
            boolean[] blArray2 = new boolean[n];
            System.arraycopy(this.fStringContent, 0, blArray2, 0, this.fElementDepth);
            this.fStringContent = blArray2;
            int[][] nArrayArray = new int[n][];
            System.arraycopy(this.fCMStateStack, 0, nArrayArray, 0, this.fElementDepth);
            this.fCMStateStack = nArrayArray;
        }
    }

    void handleStartDocument(XMLLocator xMLLocator, String string) {
        if (this.fValidation) {
            this.fValueStoreCache.startDocument();
        }
    }

    void handleEndDocument() {
        if (this.fValidation) {
            this.fValueStoreCache.endDocument();
        }
    }

    void handleCharacters(XMLString xMLString) {
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        boolean bl = true;
        int n = xMLString.offset;
        while (n < xMLString.offset + xMLString.length) {
            if (!XMLChar.isSpace(xMLString.ch[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        this.fBuffer.append(xMLString.toString());
        if (!bl) {
            this.fSawCharacters = true;
        }
        int n2 = this.fMatcherStack.getMatcherCount();
        int n3 = 0;
        while (n3 < n2) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n3);
            xPathMatcher.characters(xMLString);
            ++n3;
        }
    }

    void handleIgnorableWhitespace(XMLString xMLString) {
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        int n = this.fMatcherStack.getMatcherCount();
        int n2 = 0;
        while (n2 < n) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n2);
            xPathMatcher.characters(xMLString);
            ++n2;
        }
    }

    void handleStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
        Object object;
        Object object2;
        this.fXSIErrorReporter.pushContext();
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
        } else {
            this.fPushForNextBinding = true;
        }
        if (this.fElementDepth == -1) {
            this.fDoValidation = this.fValidation && !this.fValidationManager.isGrammarFound() && !this.fDynamicValidation;
            this.fValidationState = this.fValidationManager.getValidationState();
            this.fValidationState.setNamespaceSupport(this.fNamespaceSupport);
            this.fValidationState.setSymbolTable(this.fSymbolTable);
            this.parseSchemas(this.fExternalSchemas, this.fExternalNoNamespaceSchema);
        }
        this.fCurrentPSVI = (ElementPSVImpl)augmentations.getItem(ELEM_PSVI);
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augmentations.putItem(ELEM_PSVI, this.fCurrentPSVI);
        }
        this.fCurrentPSVI.reset();
        String string = xMLAttributes.getValue(this.URI_XSI, this.XSI_SCHEMALOCATION);
        String string2 = xMLAttributes.getValue(this.URI_XSI, this.XSI_NONAMESPACESCHEMALOCATION);
        this.parseSchemas(string, string2);
        if (string != null || string2 != null) {
            this.fDoValidation = this.fValidation;
        }
        if (this.fSkipValidationDepth >= 0) {
            ++this.fElementDepth;
            return;
        }
        if (this.fElementDepth != -1) {
            this.ensureStackCapacity();
            this.fChildCountStack[this.fElementDepth] = this.fChildCount + 1;
            this.fChildCount = 0;
            this.fElemDeclStack[this.fElementDepth] = this.fCurrentElemDecl;
            this.fNilStack[this.fElementDepth] = this.fNil;
            this.fTypeStack[this.fElementDepth] = this.fCurrentType;
            this.fCMStack[this.fElementDepth] = this.fCurrentCM;
            this.fStringContent[this.fElementDepth] = this.fSawCharacters;
        }
        this.fCurrentElemDecl = null;
        this.fNil = false;
        XSWildcardDecl xSWildcardDecl = null;
        if (this.fCurrentCM != null) {
            object2 = this.fCurrentCM.oneTransition(qName, this.fCurrCMState, this.fSubGroupHandler);
            if (this.fCurrCMState[0] == -1 && this.fDoValidation) {
                object = (XSComplexTypeDecl)this.fCurrentType;
                if (((XSComplexTypeDecl)object).fParticle != null) {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{qName.rawname, ((XSComplexTypeDecl)object).fParticle.toString()});
                } else {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{qName.rawname, "mixed with no element content"});
                }
            }
            if (object2 != null) {
                if (object2 instanceof XSElementDecl) {
                    this.fCurrentElemDecl = (XSElementDecl)object2;
                } else {
                    xSWildcardDecl = (XSWildcardDecl)object2;
                }
            }
        }
        if (this.fElementDepth != -1) {
            this.fCMStateStack[this.fElementDepth] = this.fCurrCMState;
        }
        ++this.fElementDepth;
        if (xSWildcardDecl != null && xSWildcardDecl.fProcessContents == 2) {
            this.fSkipValidationDepth = this.fElementDepth;
            return;
        }
        if (this.fCurrentElemDecl == null && (object2 = this.fGrammarResolver.getGrammar(qName.uri)) != null) {
            this.fCurrentElemDecl = ((SchemaGrammar)object2).getGlobalElementDecl(qName.localpart);
        }
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.isAbstract()) {
            this.reportSchemaError("cvc-elt.2", new Object[]{qName.rawname});
        }
        this.fCurrentType = null;
        if (this.fCurrentElemDecl != null) {
            this.fCurrentType = this.fCurrentElemDecl.fType;
        }
        if ((object2 = xMLAttributes.getValue(this.URI_XSI, this.XSI_TYPE)) != null) {
            this.getAndCheckXsiType(qName, (String)object2);
        }
        if (this.fCurrentType == null) {
            if (this.fDoValidation) {
                if (this.fValidationRootDepth == -1) {
                    this.reportSchemaError("cvc-elt.1", new Object[]{qName.rawname});
                } else if (xSWildcardDecl != null && xSWildcardDecl.fProcessContents == 0) {
                    this.reportSchemaError("cvc-complex-type.2.4.c", new Object[]{qName.rawname});
                }
            }
            if (this.fValidationRootDepth >= 0) {
                this.fSkipValidationDepth = this.fElementDepth;
            }
            return;
        }
        if (this.fValidationRootDepth == -1) {
            this.fValidationRootDepth = this.fElementDepth;
            this.fValidationRoot = qName.rawname;
        }
        this.fCurrentPSVI.fValidationContext = this.fValidationRoot;
        this.fCurrentPSVI.fDeclaration = this.fCurrentElemDecl;
        this.fCurrentPSVI.fTypeDecl = this.fCurrentType;
        if (this.fCurrentType.getXSType() == 1 && ((XSComplexTypeDecl)(object = (XSComplexTypeDecl)this.fCurrentType)).isAbstractType()) {
            this.reportSchemaError("cvc-type.2", new Object[]{"Element " + qName.rawname + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type"});
        }
        this.fCurrentCM = null;
        if (this.fCurrentType.getXSType() == 1) {
            this.fCurrentCM = ((XSComplexTypeDecl)this.fCurrentType).getContentModel(this.fCMBuilder);
        }
        this.fCurrCMState = null;
        if (this.fCurrentCM != null) {
            this.fCurrCMState = this.fCurrentCM.startContentModel();
        }
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        object = xMLAttributes.getValue(this.URI_XSI, this.XSI_NIL);
        if (object != null && this.fCurrentElemDecl != null) {
            this.getXsiNil(qName, (String)object);
        }
        XSAttributeGroupDecl xSAttributeGroupDecl = null;
        if (this.fCurrentType.getXSType() == 1) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
            xSAttributeGroupDecl = xSComplexTypeDecl.fAttrGrp;
        }
        this.processAttributes(qName, xMLAttributes, xSAttributeGroupDecl);
        if (this.fDoValidation) {
            int n;
            this.fValueStoreCache.startElement();
            this.fMatcherStack.pushContext();
            if (this.fCurrentElemDecl != null) {
                this.fValueStoreCache.initValueStoresFor(this.fCurrentElemDecl);
                int n2 = this.fCurrentElemDecl.fIDCPos;
                n = 0;
                while (n < n2) {
                    if (this.fCurrentElemDecl.fIDConstraints[n].getType() == 2) break;
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[n]);
                    ++n;
                }
                int n3 = n;
                while (n3 < n2) {
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[n3]);
                    ++n3;
                }
            }
            int n4 = this.fMatcherStack.getMatcherCount();
            n = 0;
            while (n < n4) {
                XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n);
                xPathMatcher.startElement(qName, xMLAttributes, this.fCurrentElemDecl);
                ++n;
            }
        }
    }

    XMLString handleEndElement(QName qName, Augmentations augmentations) {
        Object object;
        this.fCurrentPSVI = (ElementPSVImpl)augmentations.getItem(ELEM_PSVI);
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augmentations.putItem(ELEM_PSVI, this.fCurrentPSVI);
        }
        this.fCurrentPSVI.reset();
        if (this.fSkipValidationDepth >= 0 || this.fValidationRootDepth == -1) {
            if (this.fSkipValidationDepth == this.fElementDepth && this.fSkipValidationDepth > 0) {
                this.fPartialValidationDepth = this.fSkipValidationDepth - 1;
                this.fSkipValidationDepth = -1;
                --this.fElementDepth;
                this.fChildCount = this.fChildCountStack[this.fElementDepth];
                this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
                this.fNil = this.fNilStack[this.fElementDepth];
                this.fCurrentType = this.fTypeStack[this.fElementDepth];
                this.fCurrentCM = this.fCMStack[this.fElementDepth];
                this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
                this.fSawCharacters = this.fStringContent[this.fElementDepth];
            } else {
                --this.fElementDepth;
            }
            this.fNamespaceSupport.popContext();
            String[] stringArray = this.fXSIErrorReporter.popContext();
            if (this.fElementDepth == -1 && this.fDoValidation && this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarResolver, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
            return null;
        }
        XMLString xMLString = this.processElementContent(qName);
        int n = this.fMatcherStack.getMatcherCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n2);
            xPathMatcher.endElement(qName, this.fCurrentElemDecl);
            --n2;
        }
        if (this.fMatcherStack.size() > 0) {
            this.fMatcherStack.popContext();
        }
        int n3 = this.fMatcherStack.getMatcherCount();
        int n4 = n - 1;
        while (n4 >= n3) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n4);
            object = xPathMatcher.getIDConstraint();
            if (object != null && object.getType() != 2) {
                xPathMatcher.endDocumentFragment();
                this.fValueStoreCache.transplant((IdentityConstraint)object);
            } else if (object == null) {
                xPathMatcher.endDocumentFragment();
            }
            --n4;
        }
        int n5 = n - 1;
        while (n5 >= n3) {
            object = this.fMatcherStack.getMatcherAt(n5);
            IdentityConstraint identityConstraint = object.getIDConstraint();
            if (identityConstraint != null && identityConstraint.getType() == 2) {
                ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint);
                if (valueStoreBase != null) {
                    valueStoreBase.endDocumentFragment();
                }
                object.endDocumentFragment();
            }
            --n5;
        }
        this.fValueStoreCache.endElement();
        if (this.fValidationRootDepth == this.fElementDepth) {
            this.fValidationRootDepth = -1;
            this.fValidationRoot = null;
            if (this.fDoValidation && !this.fValidationState.checkIDRefID()) {
                this.reportSchemaError("ValidationRoot", null);
            }
            this.fValidationState.resetIDTables();
        }
        if (this.fElementDepth <= this.fPartialValidationDepth) {
            this.fCurrentPSVI.fValidationAttempted = (short)2;
            if (this.fElementDepth == this.fPartialValidationDepth) {
                --this.fPartialValidationDepth;
            }
        } else {
            this.fCurrentPSVI.fValidationAttempted = (short)3;
        }
        --this.fElementDepth;
        if (this.fElementDepth == -1) {
            if (this.fDoValidation && this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarResolver, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
        } else {
            this.fChildCount = this.fChildCountStack[this.fElementDepth];
            this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
            this.fNil = this.fNilStack[this.fElementDepth];
            this.fCurrentType = this.fTypeStack[this.fElementDepth];
            this.fCurrentCM = this.fCMStack[this.fElementDepth];
            this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
            this.fSawCharacters = this.fStringContent[this.fElementDepth];
        }
        this.fNamespaceSupport.popContext();
        object = this.fXSIErrorReporter.popContext();
        this.fCurrentPSVI.fErrorCodes = object;
        this.fCurrentPSVI.fValidity = (short)(object == null ? 2 : 1);
        return xMLString;
    }

    void handleStartPrefix(String string, String string2) {
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
            this.fPushForNextBinding = false;
        }
        this.fNamespaceSupport.declarePrefix(string, string2.length() != 0 ? string2 : null);
    }

    void parseSchemas(String string, String string2) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "General", new Object[]{"No matching location hint for namespace '" + string3 + "' in attribute schemaLocation"}, (short)0);
                    break;
                }
                String string4 = stringTokenizer.nextToken();
                if (this.fGrammarResolver.getGrammar(string3) != null) continue;
                this.fSchemaHandler.parseSchema(string3, string4);
            }
        }
        if (string2 != null && this.fGrammarResolver.getGrammar(null) == null) {
            this.fSchemaHandler.parseSchema(null, string2);
        }
    }

    void getAndCheckXsiType(QName qName, String string) {
        QName qName2 = null;
        try {
            qName2 = (QName)this.fQNameDV.validate(string, this.fValidationState, null);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            this.reportSchemaError("cvc-elt.4.1", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_TYPE, string});
            return;
        }
        XSTypeDecl xSTypeDecl = null;
        SchemaGrammar schemaGrammar = this.fGrammarResolver.getGrammar(qName2.uri);
        if (schemaGrammar != null) {
            xSTypeDecl = schemaGrammar.getGlobalTypeDecl(qName2.localpart);
        }
        if (xSTypeDecl == null) {
            this.reportSchemaError("cvc-elt.4.2", new Object[]{qName.rawname, string});
            return;
        }
        if (this.fCurrentType != null) {
            short s = this.fCurrentElemDecl.fBlock;
            if (this.fCurrentType.getXSType() == 1) {
                s = (short)(s | ((XSComplexTypeDecl)this.fCurrentType).fBlock);
            }
            if (!XSConstraints.checkTypeDerivationOk(xSTypeDecl, this.fCurrentType, s)) {
                this.reportSchemaError("cvc-elt.4.3", new Object[]{qName.rawname, string});
            }
        }
        this.fCurrentType = xSTypeDecl;
    }

    void getXsiNil(QName qName, String string) {
        if (this.fCurrentElemDecl != null && !this.fCurrentElemDecl.isNillable()) {
            this.reportSchemaError("cvc-elt.3.1", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_NIL});
        } else {
            String string2 = string.trim();
            if (string2.equals("true") || string2.equals("1")) {
                this.fNil = true;
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                    this.reportSchemaError("cvc-elt.3.2.2", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_NIL});
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void processAttributes(QName var1_1, XMLAttributes var2_2, XSAttributeGroupDecl var3_3) {
        var4_4 = null;
        var5_5 = null;
        var6_6 = 0;
        while (var6_6 < var2_2.getLength()) {
            var4_4 = var2_2.getAugmentations(var6_6);
            var5_5 = (AttributePSVImpl)var4_4.getItem("ATTR_PSVI");
            if (var5_5 != null) {
                var5_5.reset();
            } else {
                var5_5 = new AttributePSVImpl();
                var4_4.putItem("ATTR_PSVI", var5_5);
            }
            var5_5.fValidationContext = var1_1.rawname;
            ++var6_6;
        }
        if (var3_3 != null) {
            this.addDefaultAttributes(var1_1, var2_2, var3_3);
        }
        if (!this.fDoValidation) {
            return;
        }
        if (this.fCurrentType == null || this.fCurrentType.getXSType() == 2) {
            var7_7 = var2_2.getLength();
            var8_9 = 0;
            while (var8_9 < var7_7) {
                var2_2.getName(var8_9, this.fTempQName);
                var5_5 = (AttributePSVImpl)var2_2.getAugmentations(var8_9).getItem("ATTR_PSVI");
                var5_5.fValidationAttempted = (short)3;
                var5_5.fValidity = (short)2;
                var5_5.fNormalizedValue = var2_2.getValue(var8_9);
                if (this.fTempQName.uri == this.URI_XSI) {
                    if (this.fTempQName.localpart != this.XSI_SCHEMALOCATION && this.fTempQName.localpart != this.XSI_NONAMESPACESCHEMALOCATION && this.fTempQName.localpart != this.XSI_NIL && this.fTempQName.localpart != this.XSI_TYPE) {
                        var5_5.fValidity = 1;
                        var5_5.addErrorCode("cvc-type.3.1.1");
                        this.reportSchemaError("cvc-type.3.1.1", new Object[]{var1_1.rawname});
                    }
                } else if (this.fTempQName.rawname != this.XMLNS && !this.fTempQName.rawname.startsWith("xmlns:")) {
                    var5_5.fValidity = 1;
                    var5_5.addErrorCode("cvc-type.3.1.1");
                    this.reportSchemaError("cvc-type.3.1.1", new Object[]{var1_1.rawname});
                }
                ++var8_9;
            }
            return;
        }
        var7_8 = var3_3.getAttributeUses();
        var8_10 = var7_8.length;
        var9_11 = var3_3.fAttributeWC;
        var10_12 = null;
        var11_13 = var2_2.getLength();
        var12_14 = 0;
        while (var12_14 < var11_13) {
            block31: {
                block33: {
                    block32: {
                        var5_5 = (AttributePSVImpl)var2_2.getAugmentations(var12_14).getItem("ATTR_PSVI");
                        var5_5.fValidationAttempted = (short)3;
                        var5_5.fValidity = (short)2;
                        var5_5.fNormalizedValue = var2_2.getValue(var12_14);
                        var2_2.getName(var12_14, this.fTempQName);
                        if (this.fTempQName.uri == this.URI_XSI ? this.fTempQName.localpart == this.XSI_SCHEMALOCATION || this.fTempQName.localpart == this.XSI_NONAMESPACESCHEMALOCATION || this.fTempQName.localpart == this.XSI_NIL || this.fTempQName.localpart == this.XSI_TYPE : this.fTempQName.rawname == this.XMLNS || this.fTempQName.rawname.startsWith("xmlns:") != false) break block31;
                        var13_15 = null;
                        var14_16 = 0;
                        while (var14_16 < var8_10) {
                            if (var7_8[var14_16].fAttrDecl.fName == this.fTempQName.localpart && var7_8[var14_16].fAttrDecl.fTargetNamespace == this.fTempQName.uri) {
                                var13_15 = var7_8[var14_16];
                                break;
                            }
                            ++var14_16;
                        }
                        if (var13_15 != null || var9_11 != null && var9_11.allowNamespace(this.fTempQName.uri)) break block32;
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{var1_1.rawname, this.fTempQName.rawname});
                        var5_5.fValidity = 1;
                        var5_5.addErrorCode("cvc-complex-type.3.2.2");
                        break block31;
                    }
                    var15_17 = null;
                    if (var13_15 == null) break block33;
                    var15_17 = var13_15.fAttrDecl;
                    ** GOTO lbl91
                }
                if (var9_11.fProcessContents == 2) break block31;
                var16_18 = this.fGrammarResolver.getGrammar(this.fTempQName.uri);
                if (var16_18 != null) {
                    var15_17 = var16_18.getGlobalAttributeDecl(this.fTempQName.localpart);
                }
                if (var15_17 == null) {
                    if (var9_11.fProcessContents == 0) {
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{var1_1.rawname, this.fTempQName.rawname});
                        var5_5.fValidity = 1;
                        var5_5.addErrorCode("cvc-complex-type.3.2.2");
                    }
                } else {
                    if (var15_17.fType.getXSType() == 2 && var15_17.fType.isIDType()) {
                        if (var10_12 != null) {
                            this.reportSchemaError("cvc-complex-type.5.1", new Object[]{var1_1.rawname, var15_17.fName, var10_12});
                            var5_5.fValidity = 1;
                            var5_5.addErrorCode("cvc-complex-type.5.1");
                        } else {
                            var10_12 = var15_17.fName;
                        }
                    }
lbl91:
                    // 5 sources

                    var16_18 = var15_17.fType;
                    var5_5.fDeclaration = var15_17;
                    var5_5.fTypeDecl = var16_18;
                    var5_5.fValidationAttempted = (short)3;
                    if (var2_2.getType(var12_14).equals("CDATA")) {
                        var17_19 = var15_17.fType.isIDType() != false ? "ID" : "CDATA";
                        var2_2.setType(var12_14, var17_19);
                    }
                    var17_19 = var2_2.getValue(var12_14);
                    var18_20 = null;
                    try {
                        var18_20 = var16_18.validate(var17_19, this.fValidationState, this.fValidatedInfo);
                        var5_5.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                        var5_5.fMemberType = this.fValidatedInfo.memberType;
                        if (var16_18.isNOTATIONType()) {
                            var19_21 = (QName)var18_20;
                            var20_23 = this.fGrammarResolver.getGrammar(var19_21.uri);
                            if (var20_23 != null) {
                                this.fCurrentPSVI.fNotation = var20_23.getNotationDecl(var19_21.localpart);
                            }
                        }
                    }
                    catch (InvalidDatatypeValueException var19_22) {
                        var5_5.fValidity = 1;
                        var5_5.addErrorCode("cvc-attribute.3");
                        this.reportSchemaError("cvc-attribute.3", new Object[]{var1_1.rawname, this.fTempQName.rawname, var17_19});
                    }
                    if (var18_20 != null && var15_17.getConstraintType() == 2 && !var16_18.isEqual(var18_20, var15_17.fDefault.actualValue)) {
                        var5_5.fValidity = 1;
                        var5_5.addErrorCode("cvc-attribute.4");
                        this.reportSchemaError("cvc-attribute.4", new Object[]{var1_1.rawname, this.fTempQName.rawname, var17_19});
                    }
                    if (var18_20 != null && var13_15 != null && var13_15.fConstraintType == 2 && !var16_18.isEqual(var18_20, var13_15.fDefault.actualValue)) {
                        var5_5.fValidity = 1;
                        var5_5.addErrorCode("cvc-complex-type.3.1");
                        this.reportSchemaError("cvc-complex-type.3.1", new Object[]{var1_1.rawname, this.fTempQName.rawname, var17_19});
                    }
                }
            }
            ++var12_14;
        }
        if (var3_3.fIDAttrName != null && var10_12 != null) {
            var5_5.fValidity = 1;
            var5_5.addErrorCode("cvc-complex-type.3.1");
            this.reportSchemaError("cvc-complex-type.5.2", new Object[]{var1_1.rawname, var10_12, var3_3.fIDAttrName});
        }
    }

    void addDefaultAttributes(QName qName, XMLAttributes xMLAttributes, XSAttributeGroupDecl xSAttributeGroupDecl) {
        XSAttributeUse[] xSAttributeUseArray = xSAttributeGroupDecl.getAttributeUses();
        int n = xSAttributeUseArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            XSAttributeUse xSAttributeUse = xSAttributeUseArray[n2];
            XSAttributeDecl xSAttributeDecl = xSAttributeUse.fAttrDecl;
            short s = xSAttributeUse.fConstraintType;
            ValidatedInfo validatedInfo = xSAttributeUse.fDefault;
            if (s == 0) {
                s = xSAttributeDecl.getConstraintType();
                validatedInfo = xSAttributeDecl.fDefault;
            }
            boolean bl2 = bl = xMLAttributes.getValue(xSAttributeDecl.fTargetNamespace, xSAttributeDecl.fName) != null;
            if (xSAttributeUse.fUse == 1 && !bl) {
                this.reportSchemaError("cvc-complex-type.4", new Object[]{qName.rawname, xSAttributeDecl.fName});
            }
            if (!bl && s != 0) {
                QName qName2 = new QName(null, xSAttributeDecl.fName, xSAttributeDecl.fName, xSAttributeDecl.fTargetNamespace);
                String string = xSAttributeDecl.fType.isIDType() ? "ID" : "CDATA";
                int n3 = xMLAttributes.addAttribute(qName2, string, validatedInfo != null ? validatedInfo.normalizedValue : "");
                Augmentations augmentations = xMLAttributes.getAugmentations(n3);
                AttributePSVImpl attributePSVImpl = (AttributePSVImpl)augmentations.getItem(ATTR_PSVI);
                if (attributePSVImpl != null) {
                    attributePSVImpl.reset();
                } else {
                    attributePSVImpl = new AttributePSVImpl();
                    augmentations.putItem(ATTR_PSVI, attributePSVImpl);
                }
                attributePSVImpl.fSpecified = false;
                attributePSVImpl.fValidationContext = qName.rawname;
            }
            ++n2;
        }
    }

    XMLString processElementContent(QName qName) {
        Object object;
        XMLString xMLString = null;
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.fDefault != null && this.fBuffer.toString().length() == 0 && this.fChildCount == 0 && !this.fNil) {
            this.fCurrentPSVI.fSpecified = false;
            int n = this.fCurrentElemDecl.fDefault.normalizedValue.length();
            object = new char[n];
            this.fCurrentElemDecl.fDefault.normalizedValue.getChars(0, n, (char[])object, 0);
            xMLString = new XMLString((char[])object, 0, n);
            int n2 = this.fMatcherStack.getMatcherCount();
            int n3 = 0;
            while (n3 < n2) {
                XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n3);
                xPathMatcher.characters(xMLString);
                ++n3;
            }
        }
        if (this.fCurrentElemDecl == null || this.fCurrentElemDecl.getConstraintType() == 1) {
            // empty if block
        }
        if (this.fDoValidation) {
            String string = this.fBuffer.toString();
            if (this.fNil) {
                if (this.fChildCount != 0 || string.length() != 0) {
                    this.reportSchemaError("cvc-elt.3.2.1", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_NIL});
                    this.fCurrentPSVI.fNil = false;
                } else {
                    this.fCurrentPSVI.fNil = true;
                }
            }
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() != 0 && this.fChildCount == 0 && string.length() == 0 && !this.fNil) {
                if (this.fCurrentType != this.fCurrentElemDecl.fType && XSConstraints.ElementDefaultValidImmediate(this.fCurrentType, this.fCurrentElemDecl.fDefault, this.fState4XsiType, null) == null) {
                    this.reportSchemaError("cvc-elt.5.1.1", new Object[]{qName.rawname, this.fCurrentType.getTypeName(), this.fCurrentElemDecl.fDefault.normalizedValue});
                }
                this.elementLocallyValidType(qName, this.fCurrentElemDecl.fDefault.normalizedValue);
            } else {
                object = this.elementLocallyValidType(qName, string);
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2 && !this.fNil) {
                    XSSimpleType xSSimpleType;
                    if (this.fChildCount != 0) {
                        this.reportSchemaError("cvc-elt.5.2.2.1", new Object[]{qName.rawname});
                    }
                    if (this.fCurrentType.getXSType() == 1) {
                        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
                        if (xSComplexTypeDecl.fContentType == 2) {
                            if (!this.fCurrentElemDecl.fDefault.normalizedValue.equals(string)) {
                                this.reportSchemaError("cvc-elt.5.2.2.2.1", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.normalizedValue});
                            }
                        } else if (xSComplexTypeDecl.fContentType == 1 && object != null && !xSComplexTypeDecl.fXSSimpleType.isEqual(object, this.fCurrentElemDecl.fDefault.actualValue)) {
                            this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.normalizedValue});
                        }
                    } else if (this.fCurrentType.getXSType() == 2 && !(xSSimpleType = (XSSimpleType)this.fCurrentType).isEqual(object, this.fCurrentElemDecl.fDefault.actualValue)) {
                        this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.normalizedValue});
                    }
                }
            }
        }
        return xMLString;
    }

    Object elementLocallyValidType(QName qName, String string) {
        if (this.fCurrentType == null) {
            return null;
        }
        Object object = null;
        if (this.fCurrentType.getXSType() == 2) {
            if (this.fChildCount != 0) {
                this.reportSchemaError("cvc-type.3.1.2", new Object[]{qName.rawname});
            }
            if (!this.fNil) {
                XSSimpleType xSSimpleType = (XSSimpleType)this.fCurrentType;
                try {
                    object = xSSimpleType.validate(string, this.fValidationState, this.fValidatedInfo);
                    this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                    this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError("cvc-type.3.1.3", new Object[]{qName.rawname, string});
                }
            }
        } else {
            object = this.elementLocallyValidComplexType(qName, string);
        }
        return object;
    }

    Object elementLocallyValidComplexType(QName qName, String string) {
        Object object = null;
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
        if (!this.fNil) {
            if (xSComplexTypeDecl.fContentType == 0 && (this.fChildCount != 0 || string.length() != 0)) {
                this.reportSchemaError("cvc-complex-type.2.1", new Object[]{qName.rawname});
            } else if (xSComplexTypeDecl.fContentType == 1) {
                if (this.fChildCount != 0) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{qName.rawname});
                }
                XSSimpleType xSSimpleType = xSComplexTypeDecl.fXSSimpleType;
                try {
                    object = xSSimpleType.validate(string, this.fValidationState, this.fValidatedInfo);
                    this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                    this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{qName.rawname});
                }
            } else if (xSComplexTypeDecl.fContentType == 3 && this.fSawCharacters) {
                this.reportSchemaError("cvc-complex-type.2.3", new Object[]{qName.rawname});
            }
            if (!(xSComplexTypeDecl.fContentType != 3 && xSComplexTypeDecl.fContentType != 2 || this.fCurrCMState[0] < 0 || this.fCurrentCM.endContentModel(this.fCurrCMState))) {
                this.reportSchemaError("cvc-complex-type.2.4.b", new Object[]{qName.rawname, xSComplexTypeDecl.fParticle.toString()});
            }
        }
        return object;
    }

    void reportSchemaError(String string, Object[] objectArray) {
        if (this.fDoValidation) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field field, IDValue iDValue) {
            int n = this.indexOf(field);
            if (n == -1) {
                this.ensureCapacity(this.fSize);
                n = this.fSize++;
                this.fEntries[n].key = field;
            }
            this.fEntries[n].value = iDValue;
        }

        public IDValue get(Field field) {
            return this.fEntries[this.indexOf((Field)field)].value;
        }

        public int indexOf(Field field) {
            int n = 0;
            while (n < this.fSize) {
                if (this.fEntries[n].key == field) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public Field keyAt(int n) {
            return this.fEntries[n].key;
        }

        public IDValue valueAt(int n) {
            return this.fEntries[n].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int n) {
            int n2 = -1;
            int n3 = -1;
            if (this.fEntries == null) {
                n2 = 0;
                n3 = 2;
                this.fEntries = new Entry[n3];
            } else if (this.fEntries.length <= n) {
                n2 = this.fEntries.length;
                n3 = 2 * n2;
                Entry[] entryArray = new Entry[n3];
                System.arraycopy(this.fEntries, 0, entryArray, 0, n2);
                this.fEntries = entryArray;
            }
            int n4 = n2;
            while (n4 < n3) {
                this.fEntries[n4] = new Entry();
                ++n4;
            }
        }

        public Object clone() {
            OrderedHashtable orderedHashtable = new OrderedHashtable();
            int n = 0;
            while (n < this.fSize) {
                orderedHashtable.put(this.fEntries[n].key, this.fEntries[n].value);
                ++n;
            }
            return orderedHashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            int n = 0;
            while (n < this.fSize) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('{');
                stringBuffer.append(this.fEntries[n].key);
                stringBuffer.append(',');
                stringBuffer.append(this.fEntries[n].value);
                stringBuffer.append('}');
                ++n;
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws XNIException {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable hashtable = (Hashtable)this.fGlobalMapStack.pop();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                IdentityConstraint identityConstraint = (IdentityConstraint)enumeration.nextElement();
                ValueStoreBase valueStoreBase = (ValueStoreBase)hashtable.get(identityConstraint);
                if (valueStoreBase == null) continue;
                ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
                if (valueStoreBase2 == null) {
                    this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
                    continue;
                }
                valueStoreBase2.append(valueStoreBase);
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase2);
            }
        }

        public void initValueStoresFor(XSElementDecl xSElementDecl) throws XNIException {
            IdentityConstraint[] identityConstraintArray = xSElementDecl.fIDConstraints;
            int n = xSElementDecl.fIDCPos;
            int n2 = 0;
            while (n2 < n) {
                switch (identityConstraintArray[n2].getType()) {
                    case 0: {
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)identityConstraintArray[n2];
                        UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(uniqueOrKey);
                        if (uniqueValueStore != null) break;
                        uniqueValueStore = new UniqueValueStore(uniqueOrKey);
                        this.fValueStores.addElement(uniqueValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(uniqueOrKey, uniqueValueStore);
                        break;
                    }
                    case 1: {
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)identityConstraintArray[n2];
                        KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(uniqueOrKey);
                        if (keyValueStore != null) break;
                        keyValueStore = new KeyValueStore(uniqueOrKey);
                        this.fValueStores.addElement(keyValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(uniqueOrKey, keyValueStore);
                        break;
                    }
                    case 2: {
                        KeyRef keyRef = (KeyRef)identityConstraintArray[n2];
                        KeyRefValueStore keyRefValueStore = (KeyRefValueStore)this.fIdentityConstraint2ValueStoreMap.get(keyRef);
                        if (keyRefValueStore != null) break;
                        keyRefValueStore = new KeyRefValueStore(keyRef, null);
                        this.fValueStores.addElement(keyRefValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(keyRef, keyRefValueStore);
                    }
                }
                ++n2;
            }
        }

        public ValueStoreBase getValueStoreFor(Field field) {
            IdentityConstraint identityConstraint = field.getIdentityConstraint();
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint identityConstraint) {
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint identityConstraint) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
        }

        public void transplant(IdentityConstraint identityConstraint) {
            if (identityConstraint.getType() == 2) {
                return;
            }
            ValueStoreBase valueStoreBase = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
            this.fIdentityConstraint2ValueStoreMap.remove(identityConstraint);
            ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
            if (valueStoreBase2 != null) {
                valueStoreBase2.append(valueStoreBase);
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase2);
            } else {
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
            }
        }

        public void endDocument() throws XNIException {
            int n = this.fValueStores.size();
            int n2 = 0;
            while (n2 < n) {
                ValueStoreBase valueStoreBase = (ValueStoreBase)this.fValueStores.elementAt(n2);
                valueStoreBase.endDocument();
                ++n2;
            }
        }

        public String toString() {
            String string = super.toString();
            int n = string.lastIndexOf(36);
            if (n != -1) {
                return string.substring(n + 1);
            }
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                return string.substring(n2 + 1);
            }
            return string;
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws XNIException {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLSchemaValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                String string = "KeyRefOutOfScope";
                String string2 = this.fIdentityConstraint.toString();
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2});
                return;
            }
            int n = this.fValueTuples.size();
            int n2 = 0;
            while (n2 < n) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValueTuples.elementAt(n2);
                if (!this.fKeyValueStore.contains(orderedHashtable)) {
                    String string = "KeyNotFound";
                    String string3 = this.toString(orderedHashtable);
                    String string4 = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string3, string4});
                }
                ++n2;
            }
        }

        public void endDocument() throws XNIException {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(UniqueOrKey uniqueOrKey) {
            super(uniqueOrKey);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
            String string = "DuplicateKey";
            String string2 = this.toString(orderedHashtable);
            String string3 = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2, string3});
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(UniqueOrKey uniqueOrKey) {
            super(uniqueOrKey);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
            String string = "DuplicateUnique";
            String string2 = this.toString(orderedHashtable);
            String string3 = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2, string3});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void destroy() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase valueStoreBase) {
            int n = 0;
            while (n < valueStoreBase.fValueTuples.size()) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)valueStoreBase.fValueTuples.elementAt(n);
                if (!this.contains(orderedHashtable)) {
                    this.fValueTuples.addElement(orderedHashtable);
                }
                ++n;
            }
        }

        public void startValueScope() throws XNIException {
            this.fValuesCount = 0;
            int n = this.fIdentityConstraint.getFieldCount();
            int n2 = 0;
            while (n2 < n) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(n2), this.NOT_AN_IDVALUE);
                ++n2;
            }
        }

        public void endValueScope() throws XNIException {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getType() == 1) {
                    String string = "AbsentKeyValue";
                    String string2 = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getType()) {
                    case 0: {
                        String string = "UniqueNotEnoughValues";
                        String string3 = this.fIdentityConstraint.getElementName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string3});
                        break;
                    }
                    case 1: {
                        String string = "KeyNotEnoughValues";
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)this.fIdentityConstraint;
                        String string4 = this.fIdentityConstraint.getElementName();
                        String string5 = uniqueOrKey.getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string4, string5});
                        break;
                    }
                    case 2: {
                        String string = "KeyRefNotEnoughValues";
                        KeyRef keyRef = (KeyRef)this.fIdentityConstraint;
                        String string6 = this.fIdentityConstraint.getElementName();
                        String string7 = keyRef.getKey().getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string6, string7});
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws XNIException {
        }

        public void endDocument() throws XNIException {
        }

        public void reportNilError(IdentityConstraint identityConstraint) {
            if (identityConstraint.getType() == 1) {
                String string = "KeyMatchesNillable";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{identityConstraint.getElementName()});
            }
        }

        public void addValue(Field field, IDValue iDValue) {
            int n;
            if (!field.mayMatch()) {
                String string = "FieldMultipleMatch";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{field.toString()});
            }
            if ((n = this.fValues.indexOf(field)) == -1) {
                String string = "UnknownField";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{field.toString()});
                return;
            }
            IDValue iDValue2 = this.fValues.valueAt(n);
            if (iDValue2.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, iDValue);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(orderedHashtable);
            }
        }

        public boolean contains(OrderedHashtable orderedHashtable) {
            int n = orderedHashtable.size();
            int n2 = this.fValueTuples.size();
            int n3 = 0;
            while (n3 < n2) {
                block3: {
                    OrderedHashtable orderedHashtable2 = (OrderedHashtable)this.fValueTuples.elementAt(n3);
                    int n4 = 0;
                    while (n4 < n) {
                        IDValue iDValue;
                        IDValue iDValue2 = orderedHashtable2.valueAt(n4);
                        if (iDValue2.isDuplicateOf(iDValue = orderedHashtable.valueAt(n4))) {
                            ++n4;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++n3;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
        }

        protected String toString(OrderedHashtable orderedHashtable) {
            int n = orderedHashtable.size();
            if (n == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(orderedHashtable.valueAt(n2));
                ++n2;
            }
            return stringBuffer.toString();
        }

        public String toString() {
            int n;
            String string = super.toString();
            int n2 = string.lastIndexOf(36);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if ((n = string.lastIndexOf(46)) != -1) {
                string = string.substring(n + 1);
            }
            return string + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int n = 0;
            while (n < this.fMatchersCount) {
                this.fMatchers[n] = null;
                ++n;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher xPathMatcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = xPathMatcher;
        }

        public XPathMatcher getMatcherAt(int n) {
            return this.fMatchers[n];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] xPathMatcherArray = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, xPathMatcherArray, 0, this.fMatchers.length);
                this.fMatchers = xPathMatcherArray;
            }
        }
    }

    class XSIErrorReporter {
        XMLErrorReporter fErrorReporter;
        Vector fErrors = new Vector(8, 8);
        int[] fContext = new int[8];
        int fContextCount;

        XSIErrorReporter() {
        }

        public void reset(XMLErrorReporter xMLErrorReporter) {
            this.fErrorReporter = xMLErrorReporter;
            this.fErrors.removeAllElements();
            this.fContextCount = 0;
        }

        public void pushContext() {
            if (this.fContextCount == this.fContext.length) {
                int n = this.fContextCount + 8;
                int[] nArray = new int[n];
                System.arraycopy(this.fContext, 0, nArray, 0, this.fContextCount);
                this.fContext = nArray;
            }
            this.fContext[this.fContextCount++] = this.fErrors.size();
        }

        public String[] popContext() {
            int n = this.fContext[--this.fContextCount];
            int n2 = this.fErrors.size() - n;
            if (n2 == 0) {
                return null;
            }
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = (String)this.fErrors.elementAt(n + n3);
                ++n3;
            }
            this.fErrors.setSize(n);
            return stringArray;
        }

        public void reportError(String string, String string2, Object[] objectArray, short s) throws XNIException {
            this.fErrorReporter.reportError(string, string2, objectArray, s);
            this.fErrors.addElement(string2);
        }

        public void reportError(XMLLocator xMLLocator, String string, String string2, Object[] objectArray, short s) throws XNIException {
            this.fErrorReporter.reportError(xMLLocator, string, string2, objectArray, s);
            this.fErrors.addElement(string2);
        }
    }
}

