/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private DOMParser domParser = new DOMParser();
    private boolean namespaceAware = false;
    private boolean validating = false;

    DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.validating = documentBuilderFactory.isValidating();
        if (this.validating) {
            this.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.namespaceAware = documentBuilderFactory.isNamespaceAware();
        this.domParser.setFeature("http://xml.org/sax/features/namespaces", this.namespaceAware);
        try {
            this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", !documentBuilderFactory.isIgnoringElementContentWhitespace());
            this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", !documentBuilderFactory.isExpandEntityReferences());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDocumentBuilderFactoryAttributes(hashtable);
    }

    private void setDocumentBuilderFactoryAttributes(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Boolean) {
                this.domParser.setFeature(string, (Boolean)v);
                continue;
            }
            if (JAXP_SCHEMA_LANGUAGE.equals(string)) {
                if ("DTD".equals(v)) {
                    this.domParser.setFeature("http://xml.org/sax/features/validation", this.validating);
                    this.domParser.setFeature("http://apache.org/xml/features/validation/schema", false);
                    continue;
                }
                if (W3C_XML_SCHEMA.equals(v)) {
                    this.domParser.setFeature("http://xml.org/sax/features/validation", false);
                    this.domParser.setFeature("http://apache.org/xml/features/validation/schema", this.validating);
                    continue;
                }
                this.domParser.setProperty(string, v);
                continue;
            }
            this.domParser.setProperty(string, v);
        }
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        if (this.er != null) {
            this.domParser.setEntityResolver(this.er);
        }
        if (this.eh != null) {
            this.domParser.setErrorHandler(this.eh);
        }
        this.domParser.parse(inputSource);
        return this.domParser.getDocument();
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler == null ? new DefaultHandler() : errorHandler;
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }
}

