/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends javax.xml.parsers.SAXParser {
    private XMLReader xmlReader = new SAXParser();
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;
    private String schemaLanguage = "DTD";

    SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable) throws SAXException {
        this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
        this.validating = sAXParserFactory.isValidating();
        if (this.validating) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.validating);
        this.namespaceAware = sAXParserFactory.isNamespaceAware();
        String string = "http://xml.org/sax/features/namespaces";
        this.xmlReader.setFeature(string, this.namespaceAware);
        if (!this.namespaceAware) {
            String string2 = "http://xml.org/sax/features/namespace-prefixes";
            this.xmlReader.setFeature(string2, true);
        }
        this.setFeatures(hashtable);
    }

    private void setFeatures(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string);
                this.xmlReader.setFeature(string, bl);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
            if ("http://www.w3.org/2001/XMLSchema".equals(object)) {
                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", this.validating);
                return;
            } else {
                if (!"DTD".equals(object)) throw new SAXNotSupportedException("Unsupported schema language");
                this.schemaLanguage = "DTD";
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.validating);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            }
            return;
        } else {
            this.xmlReader.setProperty(string, object);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
            return this.schemaLanguage;
        }
        return this.xmlReader.getProperty(string);
    }
}

