/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.util.Vector;
import org.apache.xerces.dom.ASModelImpl;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.dom3.as.DOMASBuilder;
import org.apache.xerces.dom3.as.DOMASException;
import org.apache.xerces.dom3.ls.DOMInputSource;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.validation.GrammarPool;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarResolver;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.parsers.DTDXSParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public class DOMASBuilderImpl
extends DOMBuilderImpl
implements DOMASBuilder {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected XSGrammarResolver fGrammarResolver;
    protected SubstitutionGroupHandler fSubGroupHandler;
    protected CMBuilder fCMBuilder;
    protected XSDHandler fSchemaHandler;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected SymbolTable fSymbolTable;
    protected GrammarPool fGrammarPool = null;
    protected ASModelImpl fAbstractSchema;
    String XMLNS;
    String URI_XSI;
    String XSI_SCHEMALOCATION;
    String XSI_NONAMESPACESCHEMALOCATION;
    String XSI_TYPE;
    String XSI_NIL;
    String URI_SCHEMAFORSCHEMA;

    public DOMASBuilderImpl() {
        super(new DTDXSParserConfiguration());
    }

    public DOMASBuilderImpl(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
    }

    public DOMASBuilderImpl(SymbolTable symbolTable) {
        super(new DTDXSParserConfiguration(symbolTable));
    }

    public DOMASBuilderImpl(SymbolTable symbolTable, GrammarPool grammarPool) {
        super(new DTDXSParserConfiguration(symbolTable, grammarPool));
        this.fGrammarPool = grammarPool;
    }

    public ASModel getAbstractSchema() {
        return this.fAbstractSchema;
    }

    public void setAbstractSchema(ASModel aSModel) {
        this.fAbstractSchema = (ASModelImpl)aSModel;
        if (this.fGrammarPool == null) {
            this.fGrammarPool = (GrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        }
        this.initGrammarPool(this.fAbstractSchema);
    }

    public ASModel parseASURI(String string) throws DOMASException, Exception {
        if (this.fSchemaHandler == null) {
            this.fGrammarResolver = new XSGrammarResolver();
            this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarResolver);
            this.fSchemaHandler = new XSDHandler(this.fGrammarResolver);
            this.fCMBuilder = new CMBuilder(new XSDeclarationPool());
        }
        this.fErrorReporter = (XMLErrorReporter)this.fConfiguration.getProperty(ERROR_REPORTER);
        this.fEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
        if (this.fEntityResolver == null) {
            this.fEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty(ENTITY_MANAGER);
        }
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty(SYMBOL_TABLE);
        String string2 = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-schemaLocation");
        String string3 = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
        this.XMLNS = this.fSymbolTable.addSymbol("xmlns");
        this.URI_XSI = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.XSI_SCHEMALOCATION = this.fSymbolTable.addSymbol("schemaLocation");
        this.XSI_NONAMESPACESCHEMALOCATION = this.fSymbolTable.addSymbol("noNamespaceSchemaLocation");
        this.XSI_TYPE = this.fSymbolTable.addSymbol("type");
        this.XSI_NIL = this.fSymbolTable.addSymbol("nil");
        this.URI_SCHEMAFORSCHEMA = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
        this.initGrammarResolver();
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, string2, string3);
        SchemaGrammar schemaGrammar = this.fSchemaHandler.parseSchema(null, string);
        if (this.getFeature(SCHEMA_FULL_CHECKING)) {
            XSConstraints.fullSchemaChecking(this.fGrammarResolver, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        ASModelImpl aSModelImpl = new ASModelImpl();
        this.addGrammars(aSModelImpl, this.fGrammarResolver);
        return aSModelImpl;
    }

    public ASModel parseASInputSource(DOMInputSource dOMInputSource) throws DOMASException, Exception {
        if (this.fSchemaHandler == null) {
            this.fGrammarResolver = new XSGrammarResolver();
            this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarResolver);
            this.fSchemaHandler = new XSDHandler(this.fGrammarResolver);
            this.fCMBuilder = new CMBuilder(new XSDeclarationPool());
        }
        this.fErrorReporter = (XMLErrorReporter)this.fConfiguration.getProperty(ERROR_REPORTER);
        this.fEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty(SYMBOL_TABLE);
        String string = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-schemaLocation");
        String string2 = (String)this.fConfiguration.getProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
        this.XMLNS = this.fSymbolTable.addSymbol("xmlns");
        this.URI_XSI = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.XSI_SCHEMALOCATION = this.fSymbolTable.addSymbol("schemaLocation");
        this.XSI_NONAMESPACESCHEMALOCATION = this.fSymbolTable.addSymbol("noNamespaceSchemaLocation");
        this.XSI_TYPE = this.fSymbolTable.addSymbol("type");
        this.XSI_NIL = this.fSymbolTable.addSymbol("nil");
        this.URI_SCHEMAFORSCHEMA = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
        this.initGrammarResolver();
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, string, string2);
        SchemaGrammar schemaGrammar = this.fSchemaHandler.parseSchema(dOMInputSource.getBaseURI(), dOMInputSource.getSystemId());
        if (this.getFeature(SCHEMA_FULL_CHECKING)) {
            XSConstraints.fullSchemaChecking(this.fGrammarResolver, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        ASModelImpl aSModelImpl = new ASModelImpl();
        this.addGrammars(aSModelImpl, this.fGrammarResolver);
        return aSModelImpl;
    }

    private void initGrammarResolver() {
        this.fGrammarResolver.reset();
        this.fGrammarResolver.putGrammar(this.URI_SCHEMAFORSCHEMA, SchemaGrammar.SG_SchemaNS);
        if (this.fAbstractSchema != null) {
            this.initGrammarResolverRecurse(this.fAbstractSchema);
        }
    }

    private void initGrammarResolverRecurse(ASModelImpl aSModelImpl) {
        if (aSModelImpl.getGrammar() != null) {
            this.fGrammarResolver.putGrammar(aSModelImpl.getGrammar());
        }
        int n = 0;
        while (n < aSModelImpl.getInternalASModels().size()) {
            ASModelImpl aSModelImpl2 = (ASModelImpl)aSModelImpl.getInternalASModels().elementAt(n);
            this.initGrammarResolverRecurse(aSModelImpl2);
            ++n;
        }
    }

    private void addGrammars(ASModelImpl aSModelImpl, XSGrammarResolver xSGrammarResolver) {
        SchemaGrammar[] schemaGrammarArray = xSGrammarResolver.getGrammars();
        int n = 0;
        while (n < schemaGrammarArray.length) {
            ASModelImpl aSModelImpl2 = new ASModelImpl();
            aSModelImpl2.setGrammar(schemaGrammarArray[n]);
            aSModelImpl.addASModel((ASModel)aSModelImpl2);
            ++n;
        }
    }

    private void initGrammarPool(ASModelImpl aSModelImpl) {
        Object object;
        SchemaGrammar schemaGrammar = null;
        schemaGrammar = aSModelImpl.getGrammar();
        if (schemaGrammar != null) {
            object = schemaGrammar.getTargetNamespace();
            this.fGrammarPool.putGrammarNS((String)object, schemaGrammar);
        }
        object = aSModelImpl.getInternalASModels();
        int n = 0;
        while (n < ((Vector)object).size()) {
            this.initGrammarPool((ASModelImpl)((Vector)object).elementAt(n));
            ++n;
        }
    }
}

