/*
 * Decompiled with CFR 0.152.
 */
package com.sun.resolver.readers;

import com.sun.resolver.Catalog;
import com.sun.resolver.CatalogEntry;
import com.sun.resolver.CatalogException;
import com.sun.resolver.helpers.Debug;
import com.sun.resolver.helpers.PublicId;
import com.sun.resolver.readers.SAXCatalogParser;
import com.sun.resolver.readers.SAXCatalogReader;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XCatalogReader
extends SAXCatalogReader
implements SAXCatalogParser {
    protected Catalog catalog = null;

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public XCatalogReader(SAXParserFactory parserFactory) {
        super(parserFactory);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block15: {
            int entryType = -1;
            Vector<String> entryArgs = new Vector<String>();
            if (localName.equals("Base")) {
                entryType = Catalog.BASE;
                entryArgs.add(atts.getValue("HRef"));
                Debug.message(4, "Base", atts.getValue("HRef"));
            } else if (localName.equals("Delegate")) {
                entryType = Catalog.DELEGATE_PUBLIC;
                entryArgs.add(atts.getValue("PublicId"));
                entryArgs.add(atts.getValue("HRef"));
                Debug.message(4, "Delegate", PublicId.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
            } else if (localName.equals("Extend")) {
                entryType = Catalog.CATALOG;
                entryArgs.add(atts.getValue("HRef"));
                Debug.message(4, "Extend", atts.getValue("HRef"));
            } else if (localName.equals("Map")) {
                entryType = Catalog.PUBLIC;
                entryArgs.add(atts.getValue("PublicId"));
                entryArgs.add(atts.getValue("HRef"));
                Debug.message(4, "Map", PublicId.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
            } else if (localName.equals("Remap")) {
                entryType = Catalog.SYSTEM;
                entryArgs.add(atts.getValue("SystemId"));
                entryArgs.add(atts.getValue("HRef"));
                Debug.message(4, "Remap", atts.getValue("SystemId"), atts.getValue("HRef"));
            } else if (!localName.equals("XMLCatalog")) {
                Debug.message(1, "Invalid catalog entry type", localName);
            }
            if (entryType >= 0) {
                try {
                    CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
                    this.catalog.addEntry(ce);
                }
                catch (CatalogException cex) {
                    if (cex.getExceptionType() == 3) {
                        Debug.message(1, "Invalid catalog entry type", localName);
                    }
                    if (cex.getExceptionType() != 2) break block15;
                    Debug.message(1, "Invalid catalog entry", localName);
                }
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }
}

