/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public class DateTool {
    private static final Locale LOCALE_US = Locale.US;
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    public static final String asctimePattern = "EEE MMM d HH:mm:ss yyyy";
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final DateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", LOCALE_US);
    private static final DateFormat oldCookieFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", LOCALE_US);
    private static final DateFormat rfc1036Format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", LOCALE_US);
    private static final DateFormat asctimeFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", LOCALE_US);
    private static String rfc1123DS;
    private static long rfc1123Sec;
    private static StringManager sm;

    static {
        rfc1123Format.setTimeZone(GMT_ZONE);
        oldCookieFormat.setTimeZone(GMT_ZONE);
        rfc1036Format.setTimeZone(GMT_ZONE);
        asctimeFormat.setTimeZone(GMT_ZONE);
        sm = StringManager.getManager("org.apache.tomcat.util.buf.res");
    }

    public static String format1123(Date d) {
        long dt = d.getTime() / 1000L;
        if (rfc1123DS != null && dt == rfc1123Sec) {
            return rfc1123DS;
        }
        rfc1123DS = rfc1123Format.format(d);
        rfc1123Sec = dt;
        return rfc1123DS;
    }

    public static String format1123(Date d, DateFormat df) {
        long dt = d.getTime() / 1000L;
        if (rfc1123DS != null && dt == rfc1123Sec) {
            return rfc1123DS;
        }
        rfc1123DS = df.format(d);
        rfc1123Sec = dt;
        return rfc1123DS;
    }

    public static String formatOldCookie(Date d) {
        String ocf = null;
        DateFormat dateFormat = oldCookieFormat;
        synchronized (dateFormat) {
            ocf = oldCookieFormat.format(d);
        }
        return ocf;
    }

    public static void formatOldCookie(Date d, StringBuffer sb, FieldPosition fp) {
        DateFormat dateFormat = oldCookieFormat;
        synchronized (dateFormat) {
            oldCookieFormat.format(d, sb, fp);
        }
    }

    public static long parseDate(String dateString) {
        DateFormat[] format = new DateFormat[]{rfc1123Format, rfc1036Format, asctimeFormat};
        return DateTool.parseDate(dateString, format);
    }

    public static long parseDate(String dateString, DateFormat[] format) {
        Date date = null;
        int i = 0;
        while (i < format.length) {
            try {
                date = format[i].parse(dateString);
                return date.getTime();
            }
            catch (ParseException parseException) {
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            ++i;
        }
        String msg = sm.getString("httpDate.pe", dateString);
        throw new IllegalArgumentException(msg);
    }

    static long parseDate(MessageBytes value) {
        return DateTool.parseDate(value.toString());
    }
}

