/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.log.LogHandler;

public class CommonLogHandler
extends LogHandler {
    private Hashtable loggers = new Hashtable();

    public synchronized void close() {
    }

    public void flush() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void log(String prefix, String msg, Throwable t, int verbosityLevel) {
        Log l;
        if (prefix == null) {
            prefix = "tomcat";
        }
        if ((l = (Log)this.loggers.get(prefix)) == null) {
            l = LogFactory.getLog(prefix);
            this.loggers.put(prefix, l);
        }
        if (verbosityLevel > this.level) {
            return;
        }
        if (t == null) {
            switch (verbosityLevel) {
                case -2147483648: {
                    l.fatal(msg);
                    return;
                }
                case 1: {
                    l.error(msg);
                    return;
                }
                case 2: {
                    l.warn(msg);
                    return;
                }
                case 3: {
                    l.info(msg);
                    return;
                }
                case 4: {
                    l.debug(msg);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (verbosityLevel) {
            case -2147483648: {
                l.fatal(msg, t);
                break;
            }
            case 1: {
                l.error(msg, t);
                break;
            }
            case 2: {
                l.warn(msg, t);
                break;
            }
            case 3: {
                l.info(msg, t);
                break;
            }
            case 4: {
                l.debug(msg, t);
            }
        }
    }
}

