/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class LogHandler {
    protected PrintWriter sink = defaultSink;
    protected int level = 3;
    protected static PrintWriter defaultSink = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);

    public synchronized void close() {
        this.sink = null;
    }

    public void flush() {
        if (this.sink != null) {
            this.sink.flush();
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void log(String prefix, String msg, Throwable t, int verbosityLevel) {
        if (this.sink == null) {
            return;
        }
        if (verbosityLevel > this.level) {
            return;
        }
        if (prefix != null) {
            this.sink.println(String.valueOf(prefix) + ": " + msg);
        } else {
            this.sink.println(msg);
        }
        if (t != null) {
            t.printStackTrace(this.sink);
        }
    }

    public static void setDefaultSink(Writer w) {
        defaultSink = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

