/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.util.net.SSLSupport;

class JSSESupport
implements SSLSupport {
    private SSLSocket ssl;

    JSSESupport(SSLSocket sock) {
        this.ssl = sock;
    }

    public String getCipherSuite() throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        return session.getCipherSuite();
    }

    public Integer getKeySize() throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        Integer keySize = (Integer)session.getValue("javax.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = session.getCipherSuite();
            int i = 0;
            while (i < SSLSupport.ciphers.length) {
                if (cipherSuite.indexOf(SSLSupport.ciphers[i].phrase) >= 0) {
                    size = SSLSupport.ciphers[i].keySize;
                    break;
                }
                ++i;
            }
            keySize = new Integer(size);
            session.putValue("javax.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    public Object[] getPeerCertificateChain() throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] jsseCerts = null;
        Object[] x509Certs = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
            if (jsseCerts == null) {
                jsseCerts = new javax.security.cert.X509Certificate[]{};
            }
            x509Certs = new X509Certificate[jsseCerts.length];
            int i = 0;
            while (i < x509Certs.length) {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                ++i;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        if (x509Certs == null || x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    public String getSessionId() throws IOException {
        SSLSession session = this.ssl.getSession();
        if (session == null) {
            return null;
        }
        byte[] ssl_session = session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        int x = 0;
        while (x < ssl_session.length) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
            ++x;
        }
        return buf.toString();
    }
}

