/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.util.log.Log;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.TcpConnectionHandler;
import org.apache.tomcat.util.net.TcpWorkerThread;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class PoolTcpEndpoint {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    private static final int BACKLOG = 100;
    private static final int TIMEOUT = 1000;
    private boolean isPool = true;
    private int backlog = 100;
    private int serverTimeout = 1000;
    TcpConnectionHandler handler;
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    ThreadPoolRunnable listener;
    private boolean running = false;
    private boolean initialized = false;
    static final int debug = 0;
    ThreadPool tp;
    protected Log _log = Log.getLog("tc/PoolTcpEndpoint", "PoolTcpEndpoint");
    protected boolean tcpNoDelay = false;
    protected int linger = 100;
    protected int socketTimeout = -1;

    public PoolTcpEndpoint() {
        this.tp = new ThreadPool();
    }

    Socket acceptSocket() {
        Socket accepted = null;
        try {
            if (this.running && this.serverSocket != null) {
                accepted = this.factory == null ? this.serverSocket.accept() : this.factory.acceptSocket(this.serverSocket);
                if (!this.running && accepted != null) {
                    accepted.close();
                    accepted = null;
                }
                if (this.factory != null && accepted != null) {
                    this.factory.initSocket(accepted);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (SocketException e) {
            if (this.running) {
                String msg = this.sm.getString("endpoint.err.nonfatal", this.serverSocket, e);
                this.log(msg, e, 3);
            }
        }
        catch (Throwable e) {
            if (e.getClass().getName().equals("java.security.AccessControlException")) {
                String msg = "Socket: " + this.serverSocket + " AccessControlException: " + e.toString();
                this.log(msg, 1);
            }
            String msg = this.sm.getString("endpoint.err.fatal", this.serverSocket, e);
            this.log(msg, e, 1);
            this.stopEndpoint();
        }
        return accepted;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public TcpConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public int getMaxSpareThreads() {
        return this.tp.getMaxSpareThreads();
    }

    public int getMaxThreads() {
        return this.tp.getMaxThreads();
    }

    public int getMinSpareThreads() {
        return this.tp.getMinSpareThreads();
    }

    public int getPort() {
        return this.port;
    }

    ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    public void initEndpoint() throws IOException, InstantiationException {
        try {
            if (this.factory == null) {
                this.factory = ServerSocketFactory.getDefault();
            }
            if (this.serverSocket == null) {
                try {
                    this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
                }
                catch (BindException be) {
                    throw new BindException(String.valueOf(be.getMessage()) + ":" + this.port);
                }
            }
            if (this.serverTimeout >= 0) {
                this.serverSocket.setSoTimeout(this.serverTimeout);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (InstantiationException ex1) {
            throw ex1;
        }
        this.initialized = true;
    }

    public boolean isPoolOn() {
        return this.isPool;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void log(String msg) {
        this._log.log(msg, null, 3);
    }

    public void log(String msg, int level) {
        this._log.log(msg, null, level);
    }

    public void log(String msg, Throwable t) {
        this._log.log(msg, t, 1);
    }

    public void log(String msg, Throwable t, int level) {
        this._log.log(msg, t, level);
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public void setConnectionHandler(TcpConnectionHandler handler) {
        this.handler = handler;
    }

    public void setMaxSpareThreads(int maxThreads) {
        if (maxThreads > 0) {
            this.tp.setMaxSpareThreads(maxThreads);
        }
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads > 0) {
            this.tp.setMaxThreads(maxThreads);
        }
    }

    public void setMinSpareThreads(int minThreads) {
        if (minThreads > 0) {
            this.tp.setMinSpareThreads(minThreads);
        }
    }

    public void setPoolOn(boolean isPool) {
        this.isPool = isPool;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerSoTimeout(int i) {
        this.serverTimeout = i;
    }

    public void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    void setSocketOptions(Socket socket) {
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
            if (this.tcpNoDelay) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
            if (this.socketTimeout > 0) {
                socket.setSoTimeout(this.socketTimeout);
            }
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public void startEndpoint() throws IOException, InstantiationException {
        if (!this.initialized) {
            this.initEndpoint();
        }
        if (this.isPool) {
            this.tp.start();
        }
        this.running = true;
        if (this.isPool) {
            this.listener = new TcpWorkerThread(this);
            this.tp.runIt(this.listener);
        } else {
            this.log("XXX Error - need pool !", null, 1);
        }
    }

    public void stopEndpoint() {
        if (this.running) {
            this.tp.shutdown();
            this.running = false;
            try {
                Socket s;
                if (this.inet == null) {
                    s = new Socket("127.0.0.1", this.port);
                } else {
                    s = new Socket(this.inet, this.port);
                    s.setSoLinger(true, 0);
                }
                s.close();
                this.serverSocket.close();
            }
            catch (Exception e) {
                this.log("Caught exception trying to unlock accept.", e);
            }
            this.serverSocket = null;
        }
    }
}

