/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.openide.util.NotImplementedException;

public final class SerParser
implements ObjectStreamConstants {
    private static final boolean DEBUG = false;
    private final InputStream is;
    private int seq = 0;
    private final List refs = new ArrayList(100);
    private int pushback = -1;
    public static final Object NULL = "null";

    public SerParser(InputStream inputStream) {
        this.is = inputStream;
    }

    private int makeRef(Object object) {
        this.refs.add(object);
        int n = this.seq++;
        return n;
    }

    private Object getRef(int n) throws CorruptException {
        int n2 = n - 0x7E0000;
        if (n2 < 0 || n2 >= this.seq) {
            throw new CorruptException("Invalid reference: " + n);
        }
        Object e = this.refs.get(n2);
        if (e == null) {
            throw new CorruptException("Invalid reference: " + n);
        }
        return e;
    }

    public Stream parse() throws IOException, CorruptException {
        Stream stream = new Stream();
        stream.magic = this.readShort();
        stream.version = this.readShort();
        if (stream.magic != -21267 || stream.version != 5) {
            throw new CorruptException("stream version mismatch: " + SerParser.hexify(stream.magic) + " != " + SerParser.hexify((short)-21267) + " or " + SerParser.hexify(stream.version) + " != " + SerParser.hexify((short)5));
        }
        stream.contents = new ArrayList(10);
        while (this.peek() != -1) {
            stream.contents.add(this.readContent());
        }
        return stream;
    }

    private int rb() throws IOException {
        if (this.pushback != -1) {
            int n = this.pushback;
            this.pushback = -1;
            return n;
        }
        int n = this.is.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    private int peek() throws IOException {
        if (this.pushback != -1) {
            throw new IllegalStateException("can only peek once");
        }
        this.pushback = this.is.read();
        return this.pushback;
    }

    static String hexify(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = Integer.toHexString(n2).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(string, 2);
    }

    static String hexify(short n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 65536;
        }
        String string = Integer.toHexString(n2).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(string, 4);
    }

    static String hexify(int n) {
        String string = Integer.toHexString(n).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(string, 4);
    }

    static String hexify(long l) {
        String string = Integer.toHexString((int)((l & 0xFFFFFFFF00000000L) << 32)).toUpperCase(Locale.US);
        String string2 = Integer.toHexString((int)(l & 0xFFFFFFFFL)).toUpperCase(Locale.US);
        return "0x" + SerParser.pad(string, 4) + SerParser.pad(string2, 4);
    }

    static String hexify(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(2 + byArray.length * 2);
        stringBuffer.append("0x");
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            stringBuffer.append(SerParser.pad(Integer.toHexString(n2).toUpperCase(Locale.US), 2));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String pad(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n3 = 0;
        while (n3 < n - n2) {
            stringBuffer.append('0');
            ++n3;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private long readLong() throws IOException {
        long l = this.rb();
        long l2 = this.rb();
        long l3 = this.rb();
        long l4 = this.rb();
        long l5 = this.rb();
        long l6 = this.rb();
        long l7 = this.rb();
        long l8 = this.rb();
        long l9 = (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
        return l9;
    }

    private int readInt() throws IOException {
        int n = this.rb();
        int n2 = this.rb();
        int n3 = this.rb();
        int n4 = this.rb();
        int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        return n5;
    }

    private short readShort() throws IOException {
        int n = this.rb();
        int n2 = this.rb();
        short s = (short)((n << 8) + n2);
        return s;
    }

    private byte readByte() throws IOException {
        return (byte)this.rb();
    }

    private String readUTF() throws IOException {
        int n = this.readShort();
        if (n < 0) {
            throw new NotImplementedException();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.readByte();
            ++n2;
        }
        String string = new String(byArray, "UTF-8");
        return string;
    }

    private String readLongUTF() throws IOException {
        long l = this.readLong();
        if (l < 0L) {
            throw new NotImplementedException();
        }
        if (l > Integer.MAX_VALUE) {
            throw new NotImplementedException();
        }
        int n = (int)l;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.readByte();
            ++n2;
        }
        String string = new String(byArray, "UTF-8");
        return string;
    }

    private Object readContent() throws IOException {
        byte by = this.readByte();
        switch (by) {
            case 115: {
                return this.readNewObject();
            }
            case 118: {
                return this.readNewClass();
            }
            case 117: {
                return this.readNewArray();
            }
            case 114: {
                return this.readNewClassDesc();
            }
            case 125: {
                throw new NotImplementedException("TC_PROXYCLASSDESC");
            }
            case 116: {
                return this.readNewString();
            }
            case 124: {
                throw new NotImplementedException("TC_LONGSTRING");
            }
            case 113: {
                return this.readReference();
            }
            case 112: {
                return NULL;
            }
            case 123: {
                throw new NotImplementedException("TC_EXCEPTION");
            }
            case 121: {
                throw new NotImplementedException("TC_RESET");
            }
            case 119: {
                return this.readBlockData();
            }
            case 122: {
                return this.readBlockDataLong();
            }
        }
        throw new CorruptException("Unknown typecode: " + SerParser.hexify(by));
    }

    private ObjectWrapper readNewObject() throws IOException {
        ObjectWrapper objectWrapper = new ObjectWrapper();
        objectWrapper.classdesc = this.readClassDesc();
        this.makeRef(objectWrapper);
        objectWrapper.data = new ArrayList(10);
        LinkedList<ClassDesc> linkedList = new LinkedList<ClassDesc>();
        ClassDesc classDesc = objectWrapper.classdesc;
        while (classDesc != null) {
            linkedList.addFirst(classDesc);
            classDesc = classDesc.superclass;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ClassDesc classDesc2 = (ClassDesc)iterator.next();
            if (classDesc2.serializable) {
                objectWrapper.data.addAll(this.readNoWrClass(classDesc2));
                if (!classDesc2.writeMethod) continue;
                objectWrapper.data.addAll(this.readContents());
                continue;
            }
            if (classDesc2.blockData) {
                objectWrapper.data.addAll(this.readContents());
                continue;
            }
            objectWrapper.data.add(this.readContent());
        }
        return objectWrapper;
    }

    private ClassDesc readClassDesc() throws IOException {
        Object object = this.readContent();
        if (object instanceof ClassDesc) {
            return (ClassDesc)object;
        }
        if (object == NULL) {
            return null;
        }
        throw new CorruptException("Expected class desc, got: " + object);
    }

    private ClassDesc readNewClass() throws IOException {
        ClassDesc classDesc = this.readClassDesc();
        this.makeRef(classDesc);
        return classDesc;
    }

    private ClassDesc readNewClassDesc() throws IOException {
        ClassDesc classDesc = new ClassDesc();
        classDesc.name = this.readUTF();
        if (!(classDesc.name.startsWith("[") || classDesc.name.length() == 1 && "BSIJFDCZ".indexOf(classDesc.name) != -1 || classDesc.name.endsWith(";"))) {
            classDesc.name = "L" + classDesc.name + ";";
        }
        classDesc.svuid = this.readLong();
        this.makeRef(classDesc);
        byte by = this.readByte();
        classDesc.writeMethod = (by & 1) != 0;
        classDesc.blockData = (by & 8) != 0;
        classDesc.serializable = (by & 2) != 0;
        classDesc.externalizable = (by & 4) != 0;
        int n = this.readShort();
        classDesc.fields = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            classDesc.fields.add(this.readFieldDesc());
            ++n2;
        }
        classDesc.annotation = this.readContents();
        classDesc.superclass = this.readClassDesc();
        return classDesc;
    }

    private FieldDesc readFieldDesc() throws IOException {
        FieldDesc fieldDesc;
        char c = (char)this.readByte();
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                fieldDesc = new FieldDesc();
                fieldDesc.type = new String(new char[]{c});
                break;
            }
            case '[': {
                fieldDesc = new ObjFieldDesc();
                ((ObjFieldDesc)fieldDesc).array = true;
                break;
            }
            case 'L': {
                fieldDesc = new ObjFieldDesc();
                ((ObjFieldDesc)fieldDesc).array = false;
                break;
            }
            default: {
                throw new CorruptException("Strange field type: " + c);
            }
        }
        fieldDesc.name = this.readUTF();
        if (fieldDesc instanceof ObjFieldDesc) {
            String string;
            fieldDesc.type = string = (String)this.readContent();
        }
        return fieldDesc;
    }

    private List readContents() throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        while (this.peek() != 120) {
            arrayList.add(this.readContent());
        }
        if (this.readByte() != 120) {
            throw new IllegalStateException();
        }
        return arrayList;
    }

    private ArrayWrapper readNewArray() throws IOException {
        ArrayWrapper arrayWrapper = new ArrayWrapper();
        arrayWrapper.classdesc = this.readClassDesc();
        this.makeRef(arrayWrapper);
        int n = this.readInt();
        if (n < 0) {
            throw new NotImplementedException();
        }
        arrayWrapper.values = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            if (arrayWrapper.classdesc.name.equals("[B")) {
                arrayWrapper.values.add(new Byte(this.readByte()));
            } else if (arrayWrapper.classdesc.name.equals("[S")) {
                arrayWrapper.values.add(new Short(this.readShort()));
            } else if (arrayWrapper.classdesc.name.equals("[I")) {
                arrayWrapper.values.add(new Integer(this.readInt()));
            } else if (arrayWrapper.classdesc.name.equals("[J")) {
                arrayWrapper.values.add(new Long(this.readLong()));
            } else if (arrayWrapper.classdesc.name.equals("[F")) {
                arrayWrapper.values.add(new Float(Float.intBitsToFloat(this.readInt())));
            } else if (arrayWrapper.classdesc.name.equals("[D")) {
                arrayWrapper.values.add(new Double(Double.longBitsToDouble(this.readLong())));
            } else if (arrayWrapper.classdesc.name.equals("[C")) {
                arrayWrapper.values.add(new Character((char)this.readShort()));
            } else if (arrayWrapper.classdesc.name.equals("[Z")) {
                arrayWrapper.values.add(this.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE);
            } else {
                arrayWrapper.values.add(this.readContent());
            }
            ++n2;
        }
        return arrayWrapper;
    }

    private String readNewString() throws IOException {
        String string = this.readUTF();
        this.makeRef(string);
        return string;
    }

    private Object readReference() throws IOException {
        int n = this.readInt();
        Object object = this.getRef(n);
        return object;
    }

    private byte[] readBlockData() throws IOException {
        int n = this.readByte();
        if (n < 0) {
            n += 256;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.readByte();
            ++n2;
        }
        return byArray;
    }

    private byte[] readBlockDataLong() throws IOException {
        int n = this.readInt();
        if (n < 0) {
            throw new NotImplementedException();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.readByte();
            ++n2;
        }
        return byArray;
    }

    private List readNoWrClass(ClassDesc classDesc) throws IOException {
        List list = classDesc.fields;
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>(list.size());
        int n = 0;
        while (n < list.size()) {
            FieldDesc fieldDesc = (FieldDesc)list.get(n);
            if (fieldDesc.type.equals("B")) {
                arrayList.add(new NameValue(fieldDesc, new Byte(this.readByte())));
            } else if (fieldDesc.type.equals("S")) {
                arrayList.add(new NameValue(fieldDesc, new Short(this.readShort())));
            } else if (fieldDesc.type.equals("I")) {
                arrayList.add(new NameValue(fieldDesc, new Integer(this.readInt())));
            } else if (fieldDesc.type.equals("J")) {
                arrayList.add(new NameValue(fieldDesc, new Long(this.readLong())));
            } else if (fieldDesc.type.equals("F")) {
                arrayList.add(new NameValue(fieldDesc, new Float(Float.intBitsToFloat(this.readInt()))));
            } else if (fieldDesc.type.equals("D")) {
                arrayList.add(new NameValue(fieldDesc, new Double(Double.longBitsToDouble(this.readLong()))));
            } else if (fieldDesc.type.equals("C")) {
                arrayList.add(new NameValue(fieldDesc, new Character((char)this.readShort())));
            } else if (fieldDesc.type.equals("Z")) {
                arrayList.add(new NameValue(fieldDesc, this.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE));
            } else {
                arrayList.add(new NameValue(fieldDesc, this.readContent()));
            }
            ++n;
        }
        return arrayList;
    }

    public static final class ArrayWrapper {
        public ClassDesc classdesc;
        public List values;

        public String toString() {
            return this.classdesc.name + "{" + this.values + "}";
        }
    }

    public static final class ObjFieldDesc
    extends FieldDesc {
        public boolean array;

        public String toString() {
            return "Field[name=" + this.name + ",type=" + this.type + (this.array ? "[]" : "") + "]";
        }
    }

    public static class FieldDesc {
        public String name;
        public String type;

        public String toString() {
            return "Field[name=" + this.name + ",type=" + this.type + "]";
        }
    }

    public static final class ClassDesc {
        public String name;
        public long svuid;
        public boolean writeMethod;
        public boolean blockData;
        public boolean serializable;
        public boolean externalizable;
        public List fields;
        public List annotation;
        public ClassDesc superclass;

        public String toString() {
            return "Class[name=" + this.name + "]";
        }
    }

    public static final class NameValue {
        public final FieldDesc name;
        public final Object value;

        public NameValue(FieldDesc fieldDesc, Object object) {
            this.name = fieldDesc;
            this.value = object;
        }

        public String toString() {
            return this.name.toString() + "=" + this.value.toString();
        }
    }

    public static final class ObjectWrapper {
        public ClassDesc classdesc;
        public List data;

        public String toString() {
            return "Object[class=" + this.classdesc.name + ",data=" + this.data + "]";
        }
    }

    public static final class Stream {
        public short magic;
        public short version;
        public List contents;

        public String toString() {
            return "Stream[contents=" + this.contents + "]";
        }
    }

    public static final class CorruptException
    extends IOException {
        public CorruptException() {
        }

        public CorruptException(String string) {
            super(string);
        }
    }
}

