/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.EventsProducer;
import org.netbeans.modules.debugger.Register;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;

public abstract class CoreBreakpoint
extends Breakpoint
implements Serializable {
    static final long serialVersionUID = 3686204002781932191L;
    public static final String PROP_EVENT = "event";
    public static final String PROP_ACTIONS = "actions";
    public static final String PROP_HIDDEN = "hidden";
    private transient PropertyChangeSupport pcs;
    protected transient AbstractDebugger debugger;
    private Action[] actions;
    protected Event event;
    private BreakpointGroup group;

    public CoreBreakpoint() {
        this.init();
    }

    protected void init() {
        this.pcs = new PropertyChangeSupport(this);
        if (this.debugger == null) {
            try {
                this.debugger = (AbstractDebugger)TopManager.getDefault().getDebugger();
            }
            catch (DebuggerNotFoundException debuggerNotFoundException) {
                // empty catch block
            }
        }
        if (this.actions == null) {
            this.actions = new Action[0];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public Event getEvent(Debugger debugger) {
        if (debugger == this.debugger) {
            return this.event;
        }
        return null;
    }

    protected Event createEvent(AbstractDebugger abstractDebugger, String string) {
        try {
            DebuggerImpl debuggerImpl = null;
            debuggerImpl = abstractDebugger == TopManager.getDefault().getDebugger() ? Register.getDebuggerCoreImpl() : Register.getDebuggerImpl(abstractDebugger);
            if (!(debuggerImpl instanceof EventsProducer)) {
                return null;
            }
            Event[] eventArray = ((EventsProducer)((Object)debuggerImpl)).getEvents();
            int n = eventArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (eventArray[n2].getTypeName().equals(string)) {
                    try {
                        Event event = (Event)eventArray[n2].getClass().newInstance();
                        event.breakpoint = this;
                        event.debugger = abstractDebugger;
                        return event;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public Event getEvent() {
        try {
            AbstractDebugger abstractDebugger = ((CoreDebugger)TopManager.getDefault().getDebugger()).getCurrentDebugger();
            if (!(abstractDebugger instanceof BreakpointProducer)) {
                return this.event;
            }
            if (abstractDebugger != null) {
                return this.getEvent(abstractDebugger);
            }
            return this.event;
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            return null;
        }
    }

    public synchronized void setEvent(Event event) {
        if (event != this.event) {
            Event event2 = this.event;
            if (event != null) {
                event.breakpoint = this;
            }
            this.event = event;
            this.firePropertyChange(PROP_EVENT, event2, this.event);
            if (event2 != null) {
                event2.dispose();
            }
            if (this.event != null) {
                this.setActions(this.event.getActions());
            }
        }
    }

    public Action[] getActions() {
        return this.actions;
    }

    public void setActions(Action[] actionArray) {
        Action[] actionArray2 = this.actions;
        this.actions = actionArray;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            this.actions[n2].breakpoint = this;
            ++n2;
        }
        n2 = 0;
        while (n2 < actionArray2.length) {
            actionArray2[n2].dispose();
            ++n2;
        }
        this.firePropertyChange(PROP_ACTIONS, actionArray2, this.actions);
    }

    public abstract void setHidden(boolean var1);

    protected void perform(Event event) {
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            this.actions[n2].perform(event);
            ++n2;
        }
    }

    protected abstract void setValid(boolean var1);

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireEventPropertyChange(Event event, String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public void remove() {
        if (this.group != null) {
            this.group.removeBreakpoint(this);
        }
    }

    public BreakpointGroup getGroup() {
        return this.group;
    }

    void setGroup(BreakpointGroup breakpointGroup) {
        this.group = breakpointGroup;
    }

    public static abstract class Action
    implements Serializable {
        static final long serialVersionUID = 5993327662505228239L;
        private CoreBreakpoint breakpoint;

        protected abstract void perform(Event var1);

        public void dispose() {
        }

        public abstract Node.Property[] getProperties();

        public abstract JComponent getCustomizer();

        public CoreBreakpoint getBreakpoint() {
            return this.breakpoint;
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (this.breakpoint != null) {
                this.breakpoint.firePropertyChange(string, object, object2);
            }
        }
    }

    public static interface CompoundEvent {
        public static final String PROP_EVENTS = "event";

        public Event[] getEvents();
    }

    public static interface SessionEvent {
        public void synchronizeWith(Event var1);
    }

    public static interface AnnotatableEvent {
        public void annotate();
    }

    public static abstract class Event
    implements Serializable {
        static final long serialVersionUID = -4232563710736961248L;
        private CoreBreakpoint breakpoint;
        private Debugger debugger;

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.debugger = null;
        }

        public abstract boolean set();

        public abstract void remove();

        public void dispose() {
        }

        public abstract String getTypeName();

        public abstract String getTypeDisplayName();

        public String getCategoryDisplayName() {
            return null;
        }

        public boolean isDefault() {
            return false;
        }

        public abstract String getDisplayName();

        public String getIconBase() {
            return null;
        }

        public abstract Line[] getLines();

        public abstract Node.Property[] getProperties();

        public abstract JComponent getCustomizer();

        public Action[] getActions() {
            return new Action[0];
        }

        public CoreBreakpoint getBreakpoint() {
            return this.breakpoint;
        }

        public Debugger getDebugger() {
            if (this.debugger == null) {
                try {
                    this.debugger = TopManager.getDefault().getDebugger();
                }
                catch (DebuggerNotFoundException debuggerNotFoundException) {
                    // empty catch block
                }
            }
            return this.debugger;
        }

        protected void setValid(boolean bl) {
            this.getBreakpoint().setValid(bl);
        }

        protected void perform() {
            this.getBreakpoint().perform(this);
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (this.breakpoint != null) {
                this.breakpoint.fireEventPropertyChange(this, string, object, object2);
            }
        }
    }
}

