/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.DebuggerCoreImpl;
import org.netbeans.modules.debugger.DebuggerImpl;

public class Register {
    private static DebuggerImpl defaultImpl;
    private static LinkedList debuggerImpls;
    private static HashMap listeners;

    public static DebuggerImpl getDebuggerCoreImpl() {
        if (defaultImpl == null && debuggerImpls.size() == 1) {
            return (DebuggerImpl)debuggerImpls.get(0);
        }
        return defaultImpl;
    }

    public static void setDebuggerCoreImpl(DebuggerImpl debuggerImpl) {
        if (defaultImpl != null) {
            throw new SecurityException("Second default DebuggerImpl can not be set!");
        }
        if (!(debuggerImpl instanceof DebuggerCoreImpl)) {
            throw new SecurityException("DebuggerImpl does not implement DebuggerCoreImpl!");
        }
        defaultImpl = debuggerImpl;
    }

    public static DebuggerImpl getDebuggerImpl(AbstractDebugger abstractDebugger) {
        if (defaultImpl != null) {
            return ((DebuggerCoreImpl)((Object)defaultImpl)).getDebuggerImpl(abstractDebugger);
        }
        if (debuggerImpls.size() == 1) {
            return (DebuggerImpl)debuggerImpls.get(0);
        }
        return null;
    }

    public static void registerDebuggerImpl(DebuggerImpl debuggerImpl) {
        debuggerImpls.add(debuggerImpl);
        Iterator iterator = listeners.keySet().iterator();
        while (iterator.hasNext()) {
            ((RegisterListener)iterator.next()).debuggerImplAdded(debuggerImpl);
        }
    }

    public static void unregisterDebuggerImpl(DebuggerImpl debuggerImpl) {
        debuggerImpls.remove(debuggerImpl);
        Iterator iterator = listeners.keySet().iterator();
        while (iterator.hasNext()) {
            ((RegisterListener)iterator.next()).debuggerImplRemoved(debuggerImpl);
        }
    }

    public static List getDebuggerImpls() {
        return Collections.unmodifiableList(debuggerImpls);
    }

    public static void addRegisterListener(RegisterListener registerListener) {
        listeners.put(registerListener, registerListener);
    }

    public static void removeRegisterListener(RegisterListener registerListener) {
        listeners.remove(registerListener);
    }

    static {
        debuggerImpls = new LinkedList();
        listeners = new HashMap();
    }

    public static abstract class RegisterListener {
        public abstract void debuggerImplAdded(DebuggerImpl var1);

        public abstract void debuggerImplRemoved(DebuggerImpl var1);
    }
}

