/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.delegator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.delegator.DelegatingThreadProducer;
import org.netbeans.modules.debugger.delegator.DelegatingWatch;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.Watch;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class DelegatingDebugger
extends DebuggerSupport
implements ThreadsRoot,
CoreDebugger {
    static final long serialVersionUID = 7558733005739651906L;
    private static transient ResourceBundle bundle;
    private transient Listener listener;
    private transient DelegatingThreadProducer threadProducer = null;
    private transient AbstractDebugger[] debuggers = new AbstractDebugger[0];
    private AbstractDebugger currentDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$delegator$DelegatingDebugger;

    static String getLocString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$delegator$DelegatingDebugger == null ? (class$org$netbeans$modules$debugger$delegator$DelegatingDebugger = DelegatingDebugger.class$("org.netbeans.modules.debugger.delegator.DelegatingDebugger")) : class$org$netbeans$modules$debugger$delegator$DelegatingDebugger));
        }
        return bundle.getString(string);
    }

    public void traceInto() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(3);
        abstractDebugger.traceInto();
    }

    public void traceOver() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(2);
        abstractDebugger.traceOver();
    }

    public void go() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(5);
        abstractDebugger.go();
    }

    public void stepOut() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(4);
        abstractDebugger.stepOut();
    }

    public void pause() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(9);
        abstractDebugger.pause();
    }

    public void runToCursor(Line line) {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(10);
        abstractDebugger.runToCursor(line);
    }

    public void goToCalledMethod() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(7);
        abstractDebugger.goToCalledMethod();
    }

    public void goToCallingMethod() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(8);
        abstractDebugger.goToCallingMethod();
    }

    public void fix() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        abstractDebugger.fix();
    }

    public void popTopmostFrame() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        abstractDebugger.popTopmostFrame();
    }

    public Watch createWatch() {
        DelegatingWatch delegatingWatch = new DelegatingWatch(false);
        this.addWatch(delegatingWatch);
        return delegatingWatch;
    }

    public Watch createWatch(String string, boolean bl) {
        DelegatingWatch delegatingWatch = new DelegatingWatch(bl);
        delegatingWatch.setVariableName(string);
        this.addWatch(delegatingWatch);
        return delegatingWatch;
    }

    public int getLastAction() {
        if (this.getCurrentDebugger() == null) {
            return 6;
        }
        if (!(this.getCurrentDebugger() instanceof AbstractDebugger)) {
            return 6;
        }
        return this.getCurrentDebugger().getLastAction();
    }

    public Line getCurrentLine() {
        if (this.getCurrentDebugger() == null) {
            return null;
        }
        return this.getCurrentDebugger().getCurrentLine();
    }

    public int getState() {
        if (this.getCurrentDebugger() == null) {
            return 1;
        }
        return this.getCurrentDebugger().getState();
    }

    public State getDebuggerState() {
        if (this.getCurrentDebugger() == null) {
            return DebuggerSupport.STATE_NOT_RUNNING;
        }
        return this.getCurrentDebugger().getDebuggerState();
    }

    public ThreadsProducer getThreadsRoot() {
        if (this.threadProducer == null) {
            this.threadProducer = new DelegatingThreadProducer();
        }
        return this.threadProducer;
    }

    public AbstractThread getCurrentThread() {
        if (this.getCurrentDebugger() == null) {
            return null;
        }
        if (!(this.getCurrentDebugger() instanceof ThreadsRoot)) {
            return null;
        }
        return ((ThreadsRoot)((Object)this.getCurrentDebugger())).getCurrentThread();
    }

    public void setCurrentThread(AbstractThread abstractThread) {
        abstractThread.setCurrent(true);
    }

    public AbstractDebugger getCurrentDebugger() {
        return this.currentDebugger;
    }

    public AbstractDebugger[] getDebuggers() {
        return this.debuggers;
    }

    public void setCurrentDebugger(AbstractDebugger abstractDebugger) {
        if (abstractDebugger != null) {
            int n = this.debuggers.length;
            int n2 = 0;
            while (n2 < n) {
                if (abstractDebugger == this.debuggers[n2]) break;
                ++n2;
            }
            if (n2 == n) {
                return;
            }
        }
        AbstractDebugger abstractDebugger2 = this.getCurrentDebugger();
        State state = this.getDebuggerState();
        Integer n = new Integer(this.getState());
        AbstractThread abstractThread = this.getCurrentThread();
        Line line = this.getCurrentLine();
        Integer n3 = new Integer(this.getLastAction());
        this.currentDebugger = abstractDebugger;
        this.firePropertyChange("currentDebugger", abstractDebugger2, this.currentDebugger);
        this.firePropertyChange("state", n, new Integer(this.getState()));
        this.firePropertyChange("debuggerState", state, this.getDebuggerState());
        this.firePropertyChange("currentThread", abstractThread, this.getCurrentThread());
        this.firePropertyChange("currentLine", line, this.getCurrentLine());
        this.firePropertyChange("lastAction", n3, new Integer(this.getLastAction()));
        if (this.threadProducer != null) {
            if (this.currentDebugger instanceof ThreadsRoot) {
                this.threadProducer.setRemoteThreadGroup(((ThreadsRoot)((Object)this.currentDebugger)).getThreadsRoot());
            } else {
                this.threadProducer.setRemoteThreadGroup(null);
            }
        }
    }

    protected void addDebugger(AbstractDebugger abstractDebugger) {
        int n = this.debuggers.length;
        int n2 = 0;
        while (n2 < n) {
            if (abstractDebugger == this.debuggers[n2]) {
                return;
            }
            ++n2;
        }
        AbstractDebugger[] abstractDebuggerArray = new AbstractDebugger[this.debuggers.length + 1];
        System.arraycopy(this.debuggers, 0, abstractDebuggerArray, 0, this.debuggers.length);
        abstractDebuggerArray[this.debuggers.length] = abstractDebugger;
        abstractDebugger.addPropertyChangeListener(this.getListener());
        AbstractDebugger[] abstractDebuggerArray2 = this.debuggers;
        this.debuggers = abstractDebuggerArray;
        this.firePropertyChange("debuggers", abstractDebuggerArray2, this.debuggers);
    }

    protected void removeDebugger(AbstractDebugger abstractDebugger) {
        AbstractDebugger abstractDebugger2 = null;
        int n = this.debuggers.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.debuggers[n2] == abstractDebugger) break;
            if (abstractDebugger2 == null) {
                abstractDebugger2 = this.debuggers[n2];
            }
            ++n2;
        }
        if (n2 == n) {
            return;
        }
        if (abstractDebugger == this.getCurrentDebugger()) {
            if (abstractDebugger2 == null && n > 1) {
                abstractDebugger2 = this.debuggers[1];
            }
            this.setCurrentDebugger(abstractDebugger2);
        }
        AbstractDebugger[] abstractDebuggerArray = new AbstractDebugger[this.debuggers.length - 1];
        System.arraycopy(this.debuggers, 0, abstractDebuggerArray, 0, n2);
        if (this.debuggers.length - n2 > 1) {
            System.arraycopy(this.debuggers, n2 + 1, abstractDebuggerArray, n2, this.debuggers.length - n2 - 1);
        }
        abstractDebugger.removePropertyChangeListener(this.getListener());
        AbstractDebugger[] abstractDebuggerArray2 = this.debuggers;
        this.debuggers = abstractDebuggerArray;
        this.firePropertyChange("debuggers", abstractDebuggerArray2, this.debuggers);
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        return this.listener;
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Listener
    implements PropertyChangeListener {
        protected Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractDebugger abstractDebugger = (AbstractDebugger)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getPropertyName().equals("state")) {
                AbstractDebugger abstractDebugger2 = DelegatingDebugger.this.getCurrentDebugger();
                if (abstractDebugger.getState() == 1) {
                    DelegatingDebugger.this.removeDebugger(abstractDebugger);
                }
                if (abstractDebugger != abstractDebugger2) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("state", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("debuggerState")) {
                if (abstractDebugger != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("debuggerState", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("currentThread")) {
                if (abstractDebugger != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("currentThread", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("currentLine")) {
                if (abstractDebugger != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("currentLine", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("lastAction")) {
                if (abstractDebugger != DelegatingDebugger.this.getCurrentDebugger()) {
                    return;
                }
                DelegatingDebugger.this.firePropertyChange("lastAction", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

