/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.delegator.DelegatingBreakpoint;
import org.netbeans.modules.debugger.delegator.DelegatingDebugger;
import org.netbeans.modules.debugger.delegator.DelegatingDebuggerImpl;
import org.netbeans.modules.debugger.multisession.FinishActionPanel;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.multisession.SessionBreakpoint;
import org.netbeans.modules.debugger.multisession.SessionsListener;
import org.netbeans.modules.debugger.support.DebuggerContextSettings;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.netbeans.modules.debugger.support.actions.ContinueAction;
import org.netbeans.modules.debugger.support.actions.FinishAction;
import org.netbeans.modules.debugger.support.actions.FixAction;
import org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction;
import org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction;
import org.netbeans.modules.debugger.support.actions.PauseAction;
import org.netbeans.modules.debugger.support.actions.PopTopmostFrameAction;
import org.netbeans.modules.debugger.support.actions.RunToCursorAction;
import org.netbeans.modules.debugger.support.actions.StepIntoAction;
import org.netbeans.modules.debugger.support.actions.StepOutAction;
import org.netbeans.modules.debugger.support.actions.StepOverAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.netbeans.modules.debugger.support.util.ValidatorImpl;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.StartDebuggerAction;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class EnterpriseDebugger
extends DelegatingDebugger
implements ValidatorHolder {
    static final long serialVersionUID = 1969501498004072694L;
    public static final String PROP_CURRENT_SESSION = "currentSession";
    public static final int RUN_SINGLE = 0;
    public static final int RUN_MULTI = 1;
    public static final int RUN_CANCEL = 2;
    private static ResourceBundle bundle;
    private transient HashMap sessions = new HashMap();
    private transient Vector sessionsListener = new Vector();
    private transient HashSet startingDebuggers = new HashSet();
    private transient HashSet persistentSessions = new HashSet();
    private static ArrayList ioToClose;
    private transient Validator validator;
    private StepIntoAction stepIntoAction;
    private StepOverAction stepOverAction;
    private StepOutAction stepOutAction;
    private GoToCalledMethodAction goToCalledMethodAction;
    private GoToCallingMethodAction goToCallingMethodAction;
    private RunToCursorAction runToCursorAction;
    private PauseAction pauseAction;
    private ContinueAction continueAction;
    private FinishAction finishAction;
    private FixAction fixAction;
    private PopTopmostFrameAction popTopmostFrameAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerContextSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$delegator$DelegatingDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepIntoAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOverAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOutAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FixAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$RunToCursorAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$PauseAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$ContinueAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FinishAction;

    public EnterpriseDebugger() {
        this.setValidator(new ValidatorImpl());
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger == null ? (class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger = EnterpriseDebugger.class$("org.netbeans.modules.debugger.multisession.EnterpriseDebugger")) : class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger));
        }
        return bundle.getString(string);
    }

    static String getProcessName(AbstractDebugger abstractDebugger) {
        DebuggerInfo debuggerInfo = abstractDebugger.getDebuggerInfo();
        return debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getProcessName() : "process";
    }

    static String getLocationName(AbstractDebugger abstractDebugger) {
        DebuggerInfo debuggerInfo = abstractDebugger.getDebuggerInfo();
        return debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getLocationName() : "localhost";
    }

    protected void setDebugger(AbstractDebugger abstractDebugger) {
        super.setDebugger(abstractDebugger);
        Breakpoint[] breakpointArray = this.getBreakpoints();
        int n = 0;
        while (n < breakpointArray.length) {
            if (breakpointArray[n] instanceof DelegatingBreakpoint) {
                breakpointArray[n].remove();
                this.createBreakpoint(false).setEvent(((DelegatingBreakpoint)breakpointArray[n]).getEvent(this));
            }
            ++n;
        }
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        int n;
        super.startDebugger(debuggerInfo);
        WindowManager windowManager = TopManager.getDefault().getWindowManager();
        String string = ((DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true)).getDesktop();
        Workspace workspace = windowManager.findWorkspace(string);
        if (workspace != null) {
            workspace.activate();
        }
        AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        int n2 = 1;
        if (debuggerInfo != null && abstractDebuggerArray.length > 0) {
            n2 = this.showStartSessionDialog();
        }
        if (n2 == 2) {
            AbstractDebugger abstractDebugger = this.getCurrentDebugger();
            if (abstractDebugger == null && abstractDebuggerArray.length > 0) {
                abstractDebugger = abstractDebuggerArray[0];
            }
            this.setState(2);
            if (abstractDebugger != null) {
                this.setState(abstractDebugger.getState());
            } else {
                this.setState(1);
            }
            return;
        }
        if (n2 == 0) {
            n = abstractDebuggerArray.length - 1;
            while (n >= 0) {
                abstractDebuggerArray[n].finishDebugger();
                --n;
            }
        }
        int n3 = ioToClose.size();
        n = 0;
        while (n < n3) {
            ((InputOutput)ioToClose.get(n)).closeInputOutput();
            ++n;
        }
        ioToClose = new ArrayList();
        if (debuggerInfo == null) {
            return;
        }
        AbstractDebugger abstractDebugger = this.createDebugger(debuggerInfo);
        this.addDebugger(abstractDebugger);
        abstractDebugger.startDebugger(debuggerInfo);
        this.setCurrentDebugger(abstractDebugger);
        if (this.getDebuggers().length == 2) {
            Utils.setViewVisibility(DebuggerModule.SESSIONS_VIEW, true);
        }
    }

    public void finishDebugger() throws DebuggerException {
        AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        if (abstractDebuggerArray.length != 0) {
            DebuggerContextSettings debuggerContextSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
            if (debuggerContextSettings.getShowFinishDialog() && !this.showFinishDialog()) {
                return;
            }
            int n = abstractDebuggerArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!this.isSessionPersistent(abstractDebuggerArray[n2])) {
                    abstractDebuggerArray[n2].finishDebugger();
                }
                ++n2;
            }
        }
        super.finishDebugger();
    }

    public CoreBreakpoint createBreakpoint(boolean bl) {
        SessionBreakpoint sessionBreakpoint = new SessionBreakpoint(bl);
        this.getRootBreakpointGroup().addBreakpoint(sessionBreakpoint);
        this.addBreakpoint(sessionBreakpoint);
        return sessionBreakpoint;
    }

    protected void addDebugger(AbstractDebugger abstractDebugger) {
        super.addDebugger(abstractDebugger);
        this.fireSessionCreated(this.getSession(abstractDebugger));
        this.startingDebuggers.add(abstractDebugger);
    }

    protected void removeDebugger(AbstractDebugger abstractDebugger) {
        super.removeDebugger(abstractDebugger);
        Session session = (Session)this.sessions.remove(abstractDebugger);
        if (session != null) {
            this.fireSessionDeath(session);
        }
        this.removeEvents(abstractDebugger);
        this.startingDebuggers.remove(abstractDebugger);
        if (this.getDebuggers().length < 1) {
            TopManager.getDefault().setStatusText(EnterpriseDebugger.getString("CTL_Debugger_end"));
        }
    }

    protected DelegatingDebugger.Listener createListener() {
        return new SessionListener();
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setSessionPersistent(AbstractDebugger abstractDebugger, boolean bl) {
        if (bl) {
            this.persistentSessions.add(abstractDebugger);
        } else {
            this.persistentSessions.remove(abstractDebugger);
        }
    }

    public boolean isSessionPersistent(AbstractDebugger abstractDebugger) {
        return this.persistentSessions.contains(abstractDebugger);
    }

    private int showStartSessionDialog() {
        Object object;
        Object object2;
        DebuggerContextSettings debuggerContextSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        if (!debuggerContextSettings.getShowRunMultisessionDialog()) {
            return debuggerContextSettings.getRunMultisession() ? 1 : 0;
        }
        AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        String string = null;
        String string2 = EnterpriseDebugger.getString("TITLE_Start_session_dialog");
        int n = abstractDebuggerArray.length;
        if (n > 1) {
            string = new MessageFormat(EnterpriseDebugger.getString("MSG_Start_session_dialog")).format(new Object[]{new Integer(n)});
        } else {
            object2 = abstractDebuggerArray[0].getDebuggerInfo();
            object = object2 instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)((Object)object2)).getProcessName() : "process";
            string = new MessageFormat(EnterpriseDebugger.getString("MSG_Start_second_session_dialog")).format(new Object[]{object});
        }
        object2 = new JPanel();
        ((Container)object2).setLayout(new BorderLayout(0, 8));
        object = new JTextArea(string);
        ((JTextArea)object).setWrapStyleWord(true);
        ((JTextArea)object).setLineWrap(true);
        ((JTextComponent)object).setEditable(false);
        ((JComponent)object).setEnabled(false);
        ((JComponent)object).setOpaque(false);
        ((JTextArea)object).setFont(UIManager.getFont("Label.font"));
        ((JTextComponent)object).setDisabledTextColor(UIManager.getColor("Label.foreground"));
        ((JPanel)object2).getAccessibleContext().setAccessibleName(bundle.getString("ACS_MSG_Start_session_dialog"));
        ((JPanel)object2).getAccessibleContext().setAccessibleDescription(((JTextComponent)object).getText());
        ((Container)object2).add((Component)object, "North");
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setText(EnterpriseDebugger.getString("CTL_DNSTDNT"));
        jCheckBox.setMnemonic(EnterpriseDebugger.getString("CTL_DNSTDNT_Mnemonic").charAt(0));
        jCheckBox.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_DNSTDNT"));
        ((Container)object2).add((Component)jCheckBox, "South");
        ((JComponent)object2).setPreferredSize(new Dimension(100, 110));
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object2, string2);
        JButton jButton = new JButton(EnterpriseDebugger.getString("CTL_FinishAndStart"));
        jButton.setMnemonic(EnterpriseDebugger.getString("CTL_FinishAndStart_Mnemonic").charAt(0));
        jButton.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_FinishAndStart"));
        JButton jButton2 = new JButton(EnterpriseDebugger.getString("CTL_StartNewSession"));
        jButton2.setMnemonic(EnterpriseDebugger.getString("CTL_StartNewSession_Mnemonic").charAt(0));
        jButton2.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_StartNewSession"));
        confirmation.setOptions(new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION});
        Object object3 = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
        if (object3 == jButton) {
            debuggerContextSettings.setRunMultisession(false);
            debuggerContextSettings.setShowRunMultisessionDialog(!jCheckBox.isSelected());
            return 0;
        }
        if (object3 == jButton2) {
            debuggerContextSettings.setRunMultisession(true);
            debuggerContextSettings.setShowRunMultisessionDialog(!jCheckBox.isSelected());
            return 1;
        }
        return 2;
    }

    protected AbstractDebugger createDebugger(DebuggerInfo debuggerInfo) {
        AbstractDebugger abstractDebugger = ((DelegatingDebuggerImpl)Register.getDebuggerCoreImpl()).createDebugger(debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getDebuggerImpl() : null);
        if (abstractDebugger instanceof ValidatorHolder) {
            ((ValidatorHolder)((Object)abstractDebugger)).setValidator(this.getValidator());
        }
        return abstractDebugger;
    }

    private boolean showFinishDialog() {
        final AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        final Dialog[] dialogArray = new Dialog[1];
        final FinishActionPanel finishActionPanel = new FinishActionPanel(this);
        finishActionPanel.setSessions(abstractDebuggerArray);
        final DebuggerContextSettings debuggerContextSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        finishActionPanel.setShowFinishDialog(debuggerContextSettings.getShowFinishDialog());
        final boolean[] blArray = new boolean[]{false};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)finishActionPanel, EnterpriseDebugger.getString("CTL_Finish_debugging_dialog"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    boolean[] blArray2 = finishActionPanel.getState();
                    int n = blArray2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EnterpriseDebugger.this.setSessionPersistent(abstractDebuggerArray[n2], blArray2[n2]);
                        ++n2;
                    }
                    blArray[0] = true;
                    debuggerContextSettings.setShowFinishDialog(finishActionPanel.getShowFinishDialog());
                }
                dialogArray[0].dispose();
            }
        });
        dialogDescriptor.setHelpCtx(new HelpCtx((class$org$netbeans$modules$debugger$delegator$DelegatingDebugger == null ? (class$org$netbeans$modules$debugger$delegator$DelegatingDebugger = EnterpriseDebugger.class$("org.netbeans.modules.debugger.delegator.DelegatingDebugger")) : class$org$netbeans$modules$debugger$delegator$DelegatingDebugger).getName() + ".dialog"));
        dialogArray[0] = TopManager.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].show();
        return blArray[0];
    }

    boolean wakeUpDebugger(AbstractDebugger abstractDebugger) {
        Session session = this.findSession(abstractDebugger);
        if (TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)new MessageFormat(EnterpriseDebugger.getString("CTL_Hidden_debugger_on_breakpoint")).format(new Object[]{session.getSessionName()}), 0)) == NotifyDescriptor.YES_OPTION) {
            WindowManager windowManager = TopManager.getDefault().getWindowManager();
            Workspace workspace = windowManager.findWorkspace(StartDebuggerAction.getWorkspace());
            if (workspace != null) {
                workspace.activate();
            }
            this.setState(2);
            this.setState(3);
            this.debuggerStateChanged();
            try {
                this.startDebugger(null);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void addEvents(AbstractDebugger abstractDebugger) {
        Breakpoint[] breakpointArray = this.getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((SessionBreakpoint)breakpointArray[n2]).addDebugger(abstractDebugger);
            ++n2;
        }
    }

    private void removeEvents(AbstractDebugger abstractDebugger) {
        Breakpoint[] breakpointArray = this.getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((SessionBreakpoint)breakpointArray[n2]).removeDebugger(abstractDebugger);
            ++n2;
        }
    }

    protected void debuggerStateChanged() {
        if (this.stepIntoAction == null) {
            this.stepIntoAction = (StepIntoAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepIntoAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepIntoAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepIntoAction")) : class$org$netbeans$modules$debugger$support$actions$StepIntoAction));
            this.stepOverAction = (StepOverAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOverAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOverAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOverAction")) : class$org$netbeans$modules$debugger$support$actions$StepOverAction));
            this.stepOutAction = (StepOutAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOutAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOutAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOutAction")) : class$org$netbeans$modules$debugger$support$actions$StepOutAction));
            this.goToCalledMethodAction = (GoToCalledMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction));
            this.goToCallingMethodAction = (GoToCallingMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction));
            this.fixAction = (FixAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FixAction == null ? (class$org$netbeans$modules$debugger$support$actions$FixAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.FixAction")) : class$org$netbeans$modules$debugger$support$actions$FixAction));
            this.popTopmostFrameAction = (PopTopmostFrameAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction == null ? (class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.PopTopmostFrameAction")) : class$org$netbeans$modules$debugger$support$actions$PopTopmostFrameAction));
            this.runToCursorAction = (RunToCursorAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$RunToCursorAction == null ? (class$org$netbeans$modules$debugger$support$actions$RunToCursorAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.RunToCursorAction")) : class$org$netbeans$modules$debugger$support$actions$RunToCursorAction));
            this.pauseAction = (PauseAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$PauseAction == null ? (class$org$netbeans$modules$debugger$support$actions$PauseAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.PauseAction")) : class$org$netbeans$modules$debugger$support$actions$PauseAction));
            this.continueAction = (ContinueAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$ContinueAction == null ? (class$org$netbeans$modules$debugger$support$actions$ContinueAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.ContinueAction")) : class$org$netbeans$modules$debugger$support$actions$ContinueAction));
            this.finishAction = (FinishAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FinishAction == null ? (class$org$netbeans$modules$debugger$support$actions$FinishAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.FinishAction")) : class$org$netbeans$modules$debugger$support$actions$FinishAction));
        }
        this.stepIntoAction.checkEnabled();
        this.stepOverAction.setEnabled(this.getDebuggerState().isStepOverEnabled());
        this.stepOutAction.setEnabled(this.getDebuggerState().isStepOutEnabled());
        this.goToCalledMethodAction.setEnabled(this.getDebuggerState().isGoToCalledMethodEnabled());
        this.goToCallingMethodAction.setEnabled(this.getDebuggerState().isGoToCallingMethodEnabled());
        this.fixAction.setEnabled(this.getDebuggerState().isFixEnabled());
        this.popTopmostFrameAction.setEnabled(this.getDebuggerState().isPopTopmostFrameEnabled());
        this.runToCursorAction.checkEnabled();
        this.pauseAction.setEnabled(this.getDebuggerState().isPauseEnabled());
        this.continueAction.setEnabled(this.getDebuggerState().isContinueEnabled());
        this.finishAction.setEnabled(this.getState() != 1);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    private Session getSession(AbstractDebugger abstractDebugger) {
        Session session = (Session)this.sessions.get(abstractDebugger);
        if (session == null) {
            session = new Session(abstractDebugger, abstractDebugger.getDebuggerInfo() == null ? this.getDebuggerInfo() : abstractDebugger.getDebuggerInfo());
            this.sessions.put(abstractDebugger, session);
            this.fireSessionCreated(session);
        }
        return session;
    }

    public void setCurrentDebugger(AbstractDebugger abstractDebugger) {
        AbstractDebugger abstractDebugger2 = this.getCurrentDebugger();
        Session session = null;
        if (abstractDebugger2 != null) {
            session = this.getSession(abstractDebugger2);
        }
        super.setCurrentDebugger(abstractDebugger);
        AbstractDebugger abstractDebugger3 = this.getCurrentDebugger();
        Session session2 = null;
        if (abstractDebugger3 != null) {
            session2 = this.getSession(abstractDebugger3);
        }
        this.firePropertyChange(PROP_CURRENT_SESSION, session, session2);
        this.debuggerStateChanged();
    }

    public void startSession(DebuggerInfo debuggerInfo) throws DebuggerException {
        AbstractDebugger abstractDebugger = this.createDebugger(debuggerInfo);
        this.addDebugger(abstractDebugger);
        abstractDebugger.startDebugger(debuggerInfo);
        this.setCurrentDebugger(abstractDebugger);
    }

    public void addSessionsListener(SessionsListener sessionsListener) {
        this.sessionsListener.addElement(sessionsListener);
    }

    public void removeSessionsListener(SessionsListener sessionsListener) {
        this.sessionsListener.removeElement(sessionsListener);
    }

    protected void fireSessionCreated(final Session session) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = EnterpriseDebugger.this.sessionsListener.size();
                int n2 = 0;
                while (n2 < n) {
                    ((SessionsListener)EnterpriseDebugger.this.sessionsListener.elementAt(n2)).sessionCreated(session);
                    ++n2;
                }
            }
        });
    }

    protected void fireSessionDeath(final Session session) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = EnterpriseDebugger.this.sessionsListener.size();
                int n2 = 0;
                while (n2 < n) {
                    ((SessionsListener)EnterpriseDebugger.this.sessionsListener.elementAt(n2)).sessionDeath(session);
                    ++n2;
                }
            }
        });
    }

    public AbstractDebugger getInnerDebugger() {
        return this.getCurrentDebugger();
    }

    public Session findSession(AbstractDebugger abstractDebugger) {
        return this.getSession(abstractDebugger);
    }

    public Session getCurrentSession() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return null;
        }
        return this.getSession(abstractDebugger);
    }

    public void setCurrentSession(Session session) {
        if (session == null) {
            this.setCurrentDebugger(null);
        } else {
            this.setCurrentDebugger(session.getDebugger());
        }
    }

    public Session[] getSessions() {
        AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        Session[] sessionArray = new Session[abstractDebuggerArray.length];
        int n = abstractDebuggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            sessionArray[n2] = this.getSession(abstractDebuggerArray[n2]);
            ++n2;
        }
        return sessionArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ioToClose = new ArrayList();
    }

    private class SessionListener
    extends DelegatingDebugger.Listener {
        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractDebugger abstractDebugger = (AbstractDebugger)propertyChangeEvent.getSource();
            int n = abstractDebugger.getState();
            if (propertyChangeEvent.getPropertyName().equals("state")) {
                if (n != 2 && n != 1 && EnterpriseDebugger.this.startingDebuggers.contains(abstractDebugger)) {
                    EnterpriseDebugger.this.addEvents(abstractDebugger);
                    EnterpriseDebugger.this.startingDebuggers.remove(abstractDebugger);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("debuggerState")) {
                EnterpriseDebugger.this.debuggerStateChanged();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

