/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Vector;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.DebuggerListener;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.support.BreakpointGroupSupport;
import org.netbeans.modules.debugger.support.BreakpointSupport;
import org.netbeans.modules.debugger.support.DebuggerProjectSettings;
import org.netbeans.modules.debugger.support.StateSupport;
import org.netbeans.modules.debugger.support.util.Find;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.text.Line;
import org.openide.util.SharedClassObject;

public abstract class DebuggerSupport
extends AbstractDebugger
implements BreakpointProducer {
    static final long serialVersionUID = 2822234994389243393L;
    public static final State STATE_NOT_RUNNING = new StateSupport(17);
    private Vector breakpoints = new Vector();
    private Vector watches = new Vector();
    private BreakpointGroupSupport rootBreakpointGroup;
    private transient int lastAction = 6;
    private transient PropertyChangeSupport pcs;
    private transient Vector listener = new Vector();
    private transient Line currentLine = null;
    private transient int state = 1;
    private transient State debuggerState = STATE_NOT_RUNNING;
    private transient DebuggerProjectSettings settings;
    private transient boolean watchesInitialized = false;
    private transient boolean breakpointsInitialized = false;
    private transient DebuggerInfo debuggerInfo = null;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerProjectSettings;

    public DebuggerSupport() {
        this.pcs = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.watches == null) {
            this.watches = new Vector();
        }
        this.watchesInitialized = true;
        if (this.breakpoints == null) {
            this.breakpoints = new Vector();
        }
        this.breakpointsInitialized = true;
    }

    protected void setDebugger(AbstractDebugger abstractDebugger) {
        this.removeAllBreakpoints();
        this.removeAllWatches();
        Breakpoint[] breakpointArray = abstractDebugger.getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!breakpointArray[n2].isHidden()) {
                this.breakpoints.addElement(breakpointArray[n2]);
                this.fireBreakpointCreated(breakpointArray[n2]);
            }
            ++n2;
        }
        AbstractWatch[] abstractWatchArray = (AbstractWatch[])abstractDebugger.getWatches();
        n = abstractWatchArray.length;
        n2 = 0;
        while (n2 < n) {
            if (!abstractWatchArray[n2].isHidden()) {
                this.watches.addElement(abstractWatchArray[n2]);
                this.fireWatchCreated(abstractWatchArray[n2]);
            }
            ++n2;
        }
        BreakpointGroupSupport breakpointGroupSupport = (BreakpointGroupSupport)this.getRootBreakpointGroup();
        breakpointGroupSupport.delete();
        if (abstractDebugger instanceof DebuggerSupport) {
            BreakpointGroup breakpointGroup = ((DebuggerSupport)abstractDebugger).getRootBreakpointGroup();
            CoreBreakpoint[] coreBreakpointArray = breakpointGroup.getBreakpoints();
            n = coreBreakpointArray.length;
            n2 = 0;
            while (n2 < n) {
                breakpointGroupSupport.addBreakpoint(coreBreakpointArray[n2]);
                ++n2;
            }
            BreakpointGroup[] breakpointGroupArray = breakpointGroup.getGroups();
            n = breakpointGroupArray.length;
            n2 = 0;
            while (n2 < n) {
                breakpointGroupSupport.addGroup(breakpointGroupArray[n2]);
                ++n2;
            }
        }
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        this.debuggerInfo = debuggerInfo;
    }

    public DebuggerInfo getDebuggerInfo() {
        return this.debuggerInfo;
    }

    public void finishDebugger() throws DebuggerException {
        this.setState(1);
        this.refreshBreakpoints();
        this.setCurrentLine(null);
    }

    public int getLastAction() {
        return this.lastAction;
    }

    protected void setLastAction(int n) {
        int n2 = this.lastAction;
        this.lastAction = n;
        this.firePropertyChange("lastAction", new Integer(n2), new Integer(n));
    }

    protected void setState(int n) {
        if (n == this.state) {
            return;
        }
        Integer n2 = new Integer(this.state);
        this.state = n;
        this.firePropertyChange("state", n2, new Integer(this.state));
    }

    public int getState() {
        return this.state;
    }

    protected void setDebuggerState(State state) {
        if (state.equals(this.debuggerState)) {
            return;
        }
        State state2 = this.debuggerState;
        this.debuggerState = state;
        this.firePropertyChange("debuggerState", state2, this.debuggerState);
    }

    public State getDebuggerState() {
        return this.debuggerState;
    }

    public Line getCurrentLine() {
        return this.currentLine;
    }

    protected void setCurrentLine(Line line) {
        Line line2 = this.currentLine;
        this.currentLine = line;
        this.firePropertyChange("currentLine", line2, this.currentLine);
    }

    public CoreBreakpoint createBreakpoint(boolean bl) {
        return new BreakpointSupport(bl);
    }

    public Breakpoint createBreakpoint(Line line) {
        BreakpointSupport breakpointSupport = (BreakpointSupport)this.createBreakpoint(false);
        breakpointSupport.setLine(line);
        return breakpointSupport;
    }

    public Breakpoint createBreakpoint(Line line, boolean bl) {
        BreakpointSupport breakpointSupport = (BreakpointSupport)this.createBreakpoint(bl);
        breakpointSupport.setLine(line);
        return breakpointSupport;
    }

    public Breakpoint createBreakpoint(ConstructorElement constructorElement) {
        return this.createBreakpoint(constructorElement, false);
    }

    public Breakpoint createBreakpoint(ConstructorElement constructorElement, boolean bl) {
        BreakpointSupport breakpointSupport = (BreakpointSupport)this.createBreakpoint(bl);
        ClassElement classElement = constructorElement.getDeclaringClass();
        String string = constructorElement.getName().getName();
        if (string.equals(classElement.getName().getName())) {
            string = "<init>";
        }
        breakpointSupport.createMethodBreakpoint(classElement.getVMName(), string);
        return breakpointSupport;
    }

    public Breakpoint findBreakpoint(Line line) {
        CoreBreakpoint[] coreBreakpointArray = Find.breakpoint((Debugger)this, line, true, true, true, true);
        if (coreBreakpointArray.length > 0) {
            return coreBreakpointArray[0];
        }
        return null;
    }

    public Breakpoint findBreakpoint(ConstructorElement constructorElement) {
        CoreBreakpoint[] coreBreakpointArray = Find.breakpoint((Debugger)this, constructorElement, true, true, true, true);
        if (coreBreakpointArray.length > 0) {
            return coreBreakpointArray[0];
        }
        return null;
    }

    public Breakpoint[] getBreakpoints() {
        Object[] objectArray;
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        Vector vector = this.breakpoints;
        synchronized (vector) {
            objectArray = new CoreBreakpoint[this.breakpoints.size()];
            this.breakpoints.copyInto(objectArray);
        }
        return objectArray;
    }

    public BreakpointGroup getRootBreakpointGroup() {
        if (this.rootBreakpointGroup == null) {
            this.initGroups();
        }
        return this.rootBreakpointGroup;
    }

    private void initGroups() {
        DebuggerSupport debuggerSupport = ((DebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerProjectSettings = DebuggerSupport.class$("org.netbeans.modules.debugger.support.DebuggerProjectSettings")) : class$org$netbeans$modules$debugger$support$DebuggerProjectSettings), (boolean)true)).getRemoteDebugger();
        if (debuggerSupport == null) {
            this.rootBreakpointGroup = new BreakpointGroupSupport("main");
        } else {
            this.rootBreakpointGroup = debuggerSupport.rootBreakpointGroup;
            if (debuggerSupport.breakpoints != null) {
                this.breakpoints = debuggerSupport.breakpoints;
            }
            this.breakpointsInitialized = true;
            if (this.rootBreakpointGroup == null) {
                this.rootBreakpointGroup = new BreakpointGroupSupport("main");
                Breakpoint[] breakpointArray = debuggerSupport.getBreakpoints();
                int n = breakpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    this.rootBreakpointGroup.addBreakpoint((CoreBreakpoint)breakpointArray[n2]);
                    ++n2;
                }
            }
        }
    }

    public void removeAllBreakpoints() {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        Vector vector = (Vector)this.breakpoints.clone();
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            ((Breakpoint)vector.elementAt(n2)).remove();
            --n2;
        }
    }

    protected void addBreakpoint(Breakpoint breakpoint) {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        this.breakpoints.addElement(breakpoint);
        this.fireBreakpointCreated(breakpoint);
    }

    protected void removeBreakpoint(Breakpoint breakpoint) {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        this.breakpoints.removeElement(breakpoint);
        this.fireBreakpointRemoved(breakpoint);
    }

    protected void refreshBreakpoints() {
        if (!this.breakpointsInitialized) {
            this.initBreakpoints();
        }
        Vector vector = (Vector)this.breakpoints.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) instanceof BreakpointSupport) {
                ((BreakpointSupport)vector.elementAt(n2)).setBreakpoint();
            }
            ++n2;
        }
    }

    private void initBreakpoints() {
        DebuggerSupport debuggerSupport = ((DebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerProjectSettings = DebuggerSupport.class$("org.netbeans.modules.debugger.support.DebuggerProjectSettings")) : class$org$netbeans$modules$debugger$support$DebuggerProjectSettings), (boolean)true)).getRemoteDebugger();
        if (debuggerSupport != null && debuggerSupport.breakpoints != null) {
            this.breakpoints = debuggerSupport.breakpoints;
        }
        this.breakpointsInitialized = true;
    }

    public Watch[] getWatches() {
        Object[] objectArray;
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        if (this.watches == null) {
            return new Watch[0];
        }
        Vector vector = this.watches;
        synchronized (vector) {
            objectArray = new Watch[this.watches.size()];
            this.watches.copyInto(objectArray);
        }
        return objectArray;
    }

    public void removeAllWatches() {
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        Vector vector = (Vector)this.watches.clone();
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            ((Watch)vector.elementAt(n2)).remove();
            --n2;
        }
    }

    public void addWatch(AbstractWatch abstractWatch) {
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        this.watches.addElement(abstractWatch);
        this.fireWatchCreated(abstractWatch);
    }

    public void removeWatch(AbstractWatch abstractWatch) {
        if (!this.watchesInitialized) {
            this.initWatches();
        }
        this.watches.removeElement(abstractWatch);
        this.fireWatchRemoved(abstractWatch);
    }

    private void initWatches() {
        this.watchesInitialized = true;
        DebuggerSupport debuggerSupport = ((DebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerProjectSettings = DebuggerSupport.class$("org.netbeans.modules.debugger.support.DebuggerProjectSettings")) : class$org$netbeans$modules$debugger$support$DebuggerProjectSettings), (boolean)true)).getRemoteDebugger();
        if (debuggerSupport != null) {
            Watch[] watchArray = debuggerSupport.getWatches();
            if (this.watches == null) {
                this.watches = new Vector();
            }
            this.watches.addAll(Arrays.asList(watchArray));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public void addDebuggerListener(DebuggerListener debuggerListener) {
        this.listener.addElement(debuggerListener);
    }

    public void removeDebuggerListener(DebuggerListener debuggerListener) {
        this.listener.removeElement(debuggerListener);
    }

    private void fireBreakpointCreated(Breakpoint breakpoint) {
        Vector vector = (Vector)this.listener.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((DebuggerListener)vector.elementAt(n2)).breakpointAdded(breakpoint);
            ++n2;
        }
        this.pcs.firePropertyChange("breakpoints", null, null);
    }

    private void fireBreakpointRemoved(Breakpoint breakpoint) {
        Vector vector = (Vector)this.listener.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((DebuggerListener)vector.elementAt(n2)).breakpointRemoved(breakpoint);
            ++n2;
        }
        this.pcs.firePropertyChange("breakpoints", null, null);
    }

    private void fireWatchCreated(AbstractWatch abstractWatch) {
        Vector vector = (Vector)this.listener.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((DebuggerListener)vector.elementAt(n2)).watchAdded(abstractWatch);
            ++n2;
        }
        this.pcs.firePropertyChange("watches", null, null);
    }

    private void fireWatchRemoved(AbstractWatch abstractWatch) {
        Vector vector = (Vector)this.listener.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((DebuggerListener)vector.elementAt(n2)).watchRemoved(abstractWatch);
            ++n2;
        }
        this.pcs.firePropertyChange("watches", null, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

